/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.StepIntersection;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCheckinHandlerWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.checkin.TodoCheckinHandler");
    private final Collection<Change> changes;
    private final TodoFilter myTodoFilter;
    private final boolean myIncludePattern;
    private final PsiManager myPsiManager;
    private final PsiTodoSearchHelper mySearchHelper;
    private final List<TodoItem> myAddedOrEditedTodos;
    private final List<TodoItem> myInChangedTodos;
    private final List<Pair<FilePath, String>> mySkipped;
    private PsiFile myPsiFile;
    private List<TodoItem> myNewTodoItems;
    private final MyEditedFileProcessor myEditedFileProcessor;
    private static final String ourInvalidFile = "Invalid file (s)";
    private static final String ourCannotLoadPreviousRevision = "Can not load previous revision";
    private static final String ourCannotLoadCurrentRevision = "Can not load current revision";
    private static final Convertor<TodoItem, TextRange> TODO_ITEM_CONVERTOR = o -> {
        TextRange textRange = o.getTextRange();
        return new TextRange(textRange.getStartOffset(), textRange.getEndOffset() - 1);
    };
    private static final Convertor<LineFragment, TextRange> LINE_FRAGMENT_CONVERTOR = o -> {
        int start = o.getStartOffset2();
        int end = o.getEndOffset2();
        return new TextRange(start, Math.max(start, end - 1));
    };

    public TodoCheckinHandlerWorker(Project project2, Collection<Change> changes, TodoFilter todoFilter, boolean includePattern) {
        this.changes = changes;
        this.myTodoFilter = todoFilter;
        this.myIncludePattern = includePattern;
        this.myPsiManager = PsiManager.getInstance((Project)project2);
        this.mySearchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)project2);
        this.myAddedOrEditedTodos = new ArrayList<TodoItem>();
        this.myInChangedTodos = new ArrayList<TodoItem>();
        this.mySkipped = new SmartList();
        this.myEditedFileProcessor = new MyEditedFileProcessor(project2, new Acceptor(){

            @Override
            public void skipped(Pair<FilePath, String> pair2) {
                TodoCheckinHandlerWorker.this.mySkipped.add(pair2);
            }

            @Override
            public void addedOrEdited(TodoItem todoItem) {
                TodoCheckinHandlerWorker.this.myAddedOrEditedTodos.add(todoItem);
            }

            @Override
            public void inChanged(TodoItem todoItem) {
                TodoCheckinHandlerWorker.this.myInChangedTodos.add(todoItem);
            }
        }, this.myTodoFilter);
    }

    public void execute() {
        for (Change change : this.changes) {
            VirtualFile afterFile;
            ProgressManager.checkCanceled();
            if (change.getAfterRevision() == null || (afterFile = TodoCheckinHandlerWorker.getFileWithRefresh(change.getAfterRevision().getFile())) == null || afterFile.isDirectory() || afterFile.getFileType().isBinary()) continue;
            this.myPsiFile = null;
            if (afterFile.isValid()) {
                this.myPsiFile = (PsiFile)ReadAction.compute(() -> this.myPsiManager.findFile(afterFile));
            }
            if (this.myPsiFile == null) {
                this.mySkipped.add((Pair<FilePath, String>)Pair.create((Object)change.getAfterRevision().getFile(), (Object)ourInvalidFile));
                continue;
            }
            this.myNewTodoItems = new ArrayList<Object>(Arrays.asList((Object[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<TodoItem[]>(){

                public TodoItem[] compute() {
                    return TodoCheckinHandlerWorker.this.mySearchHelper.findTodoItems(TodoCheckinHandlerWorker.this.myPsiFile);
                }
            })));
            TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicates(this.myNewTodoItems, this.myTodoFilter);
            if (change.getBeforeRevision() == null) {
                if (this.myNewTodoItems.isEmpty()) continue;
                this.myAddedOrEditedTodos.addAll(this.myNewTodoItems);
                continue;
            }
            this.myEditedFileProcessor.process(change, this.myNewTodoItems);
        }
    }

    @Nullable
    private static VirtualFile getFileWithRefresh(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker", "getFileWithRefresh"));
        }
        VirtualFile file2 = filePath.getVirtualFile();
        if (file2 == null) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        return file2;
    }

    private static void applyFilterAndRemoveDuplicates(List<TodoItem> todoItems, TodoFilter filter) {
        TodoItem previous = null;
        Iterator<TodoItem> iterator = todoItems.iterator();
        while (iterator.hasNext()) {
            TodoItem next = iterator.next();
            if (filter != null && !filter.contains(next.getPattern())) {
                iterator.remove();
                continue;
            }
            if (previous != null && next.getTextRange().equals((Object)previous.getTextRange())) {
                iterator.remove();
                continue;
            }
            previous = next;
        }
    }

    public List<TodoItem> getAddedOrEditedTodos() {
        return this.myAddedOrEditedTodos;
    }

    public List<TodoItem> getInChangedTodos() {
        return this.myInChangedTodos;
    }

    public List<Pair<FilePath, String>> getSkipped() {
        return this.mySkipped;
    }

    private static String getTodoText(TodoItem oldItem, String content) {
        String fragment = content.substring(oldItem.getTextRange().getStartOffset(), oldItem.getTextRange().getEndOffset());
        return StringUtil.join((String[])fragment.split("\\s"), (String)" ");
    }

    private static List<LineFragment> getLineFragments(@NotNull String fileName, @NotNull String beforeContent, @NotNull String afterContent) throws VcsException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker", "getLineFragments"));
        }
        if (beforeContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeContent", "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker", "getLineFragments"));
        }
        if (afterContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterContent", "com/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker", "getLineFragments"));
        }
        try {
            ProgressIndicator indicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)DumbProgressIndicator.INSTANCE);
            return ComparisonManager.getInstance().compareLines((CharSequence)beforeContent, (CharSequence)afterContent, ComparisonPolicy.IGNORE_WHITESPACES, indicator);
        }
        catch (DiffTooBigException e) {
            throw new VcsException("File " + fileName + " is too big and there are too many changes to build a diff", (Throwable)e);
        }
    }

    public List<TodoItem> inOneList() {
        ArrayList<TodoItem> list2 = new ArrayList<TodoItem>();
        list2.addAll(this.getAddedOrEditedTodos());
        list2.addAll(this.getInChangedTodos());
        return list2;
    }

    static interface Acceptor {
        public void skipped(Pair<FilePath, String> var1);

        public void addedOrEdited(TodoItem var1);

        public void inChanged(TodoItem var1);
    }

    private static class MyEditedFileProcessor {
        private String myBeforeContent;
        private String myAfterContent;
        private List<TodoItem> myOldItems;
        private LineFragment myCurrentLineFragment;
        private HashSet<String> myOldTodoTexts;
        private PsiFile myBeforeFile;
        private final PsiFileFactory myPsiFileFactory;
        private FilePath myAfterFile;
        private final Acceptor myAcceptor;
        private final TodoFilter myTodoFilter;

        private MyEditedFileProcessor(Project project2, Acceptor acceptor, TodoFilter todoFilter) {
            this.myAcceptor = acceptor;
            this.myTodoFilter = todoFilter;
            this.myPsiFileFactory = PsiFileFactory.getInstance((Project)project2);
        }

        public void process(Change change, List<TodoItem> newTodoItems) {
            this.myBeforeFile = null;
            this.myOldItems = null;
            this.myOldTodoTexts = null;
            this.myAfterFile = change.getAfterRevision().getFile();
            try {
                this.myBeforeContent = change.getBeforeRevision().getContent();
                this.myAfterContent = change.getAfterRevision().getContent();
                if (this.myAfterContent == null) {
                    this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadCurrentRevision));
                    return;
                }
                if (this.myBeforeContent == null) {
                    this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadPreviousRevision));
                    return;
                }
                List lineFragments = TodoCheckinHandlerWorker.getLineFragments(this.myAfterFile.getPath(), this.myBeforeContent, this.myAfterContent);
                lineFragments = ContainerUtil.filter((Collection)lineFragments, it -> DiffUtil.getLineDiffType(it) != TextDiffType.DELETED);
                StepIntersection intersection = new StepIntersection(TODO_ITEM_CONVERTOR, LINE_FRAGMENT_CONVERTOR, lineFragments);
                intersection.process(newTodoItems, (todoItem, lineFragment) -> {
                    ProgressManager.checkCanceled();
                    if (this.myCurrentLineFragment == null || this.myCurrentLineFragment != lineFragment) {
                        this.myCurrentLineFragment = lineFragment;
                        this.myOldTodoTexts = null;
                    }
                    if (DiffUtil.getLineDiffType(lineFragment) == TextDiffType.INSERTED) {
                        this.myAcceptor.addedOrEdited((TodoItem)todoItem);
                    } else {
                        this.checkEditedFragment((TodoItem)todoItem);
                    }
                });
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                this.myAcceptor.skipped((Pair<FilePath, String>)Pair.create((Object)this.myAfterFile, (Object)TodoCheckinHandlerWorker.ourCannotLoadPreviousRevision));
            }
        }

        private void checkEditedFragment(TodoItem newTodoItem) {
            String text2;
            if (this.myBeforeFile == null) {
                this.myBeforeFile = (PsiFile)ReadAction.compute(() -> this.myPsiFileFactory.createFileFromText("old" + this.myAfterFile.getName(), this.myAfterFile.getFileType(), (CharSequence)this.myBeforeContent));
            }
            if (this.myOldItems == null) {
                Collection all = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(this.myBeforeFile, (IndexPatternProvider)TodoIndexPatternProvider.getInstance())).findAll();
                TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
                this.myOldItems = new ArrayList<TodoItem>();
                if (all.isEmpty()) {
                    this.myAcceptor.addedOrEdited(newTodoItem);
                    return;
                }
                for (IndexPatternOccurrence occurrence : all) {
                    this.myOldItems.add(todoItemsCreator.createTodo(occurrence));
                }
                TodoCheckinHandlerWorker.applyFilterAndRemoveDuplicates(this.myOldItems, this.myTodoFilter);
            }
            if (this.myOldTodoTexts == null) {
                StepIntersection intersection = new StepIntersection(LINE_FRAGMENT_CONVERTOR, TODO_ITEM_CONVERTOR, this.myOldItems);
                this.myOldTodoTexts = new HashSet();
                intersection.process(Collections.singletonList(this.myCurrentLineFragment), (lineFragment, todoItem) -> this.myOldTodoTexts.add(TodoCheckinHandlerWorker.getTodoText(todoItem, this.myBeforeContent)));
            }
            if (!this.myOldTodoTexts.contains(text2 = TodoCheckinHandlerWorker.getTodoText(newTodoItem, this.myAfterContent))) {
                this.myAcceptor.addedOrEdited(newTodoItem);
            } else {
                this.myAcceptor.inChanged(newTodoItem);
            }
        }
    }
}

