/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.vcs.commit.CommitMessageInspectionsPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommitDialogSettingsPanel
implements ConfigurableUi<VcsConfiguration>,
Disposable {
    @NotNull
    private final Project myProject;
    private JBCheckBox myShowUnversionedFiles;
    private JPanel myMainPanel;
    private CommitMessageInspectionsPanel myInspectionsPanel;

    public CommitDialogSettingsPanel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel", "<init>"));
        }
        this.myProject = project2;
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel", "reset"));
        }
        this.myShowUnversionedFiles.setSelected(settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT);
        this.myInspectionsPanel.reset();
    }

    public boolean isModified(@NotNull VcsConfiguration settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel", "isModified"));
        }
        return settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT != this.myShowUnversionedFiles.isSelected() || this.myInspectionsPanel.isModified();
    }

    public void apply(@NotNull VcsConfiguration settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel", "apply"));
        }
        settings.SHOW_UNVERSIONED_FILES_WHILE_COMMIT = this.myShowUnversionedFiles.isSelected();
        this.myInspectionsPanel.apply();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/CommitDialogSettingsPanel", "getComponent"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myInspectionsPanel = new CommitMessageInspectionsPanel(this.myProject);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myInspectionsPanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myShowUnversionedFiles = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show unversioned files");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Commit message inspections", (int)0, (int)0, null, null));
        CommitMessageInspectionsPanel commitMessageInspectionsPanel = this.myInspectionsPanel;
        jPanel2.add((Component)((Object)commitMessageInspectionsPanel), new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

