/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfigurableProvider;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.CommitDialogConfigurable;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurationPanel;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurable;
import com.intellij.openapi.vcs.configurable.VcsBackgroundOperationsConfigurable;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationConfigurable;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    @NotNull
    private final Project myProject;
    private VcsDirectoryConfigurationPanel myMappings;
    private VcsGeneralConfigurationConfigurable myGeneralPanel;

    public VcsManagerConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "<init>"));
        }
        this.myProject = project2;
    }

    public JComponent createComponent() {
        this.myMappings = new VcsDirectoryConfigurationPanel(this.myProject);
        return this.myMappings;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myMappings != null && this.myMappings.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myMappings.apply();
    }

    public void reset() {
        super.reset();
        this.myMappings.reset();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myMappings != null) {
            this.myMappings.disposeUIResources();
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.disposeUIResources();
        }
        this.myMappings = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("project.propVCSSupport.Mappings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getHelpTopic"));
        }
        return "project.propVCSSupport.Mappings";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getId"));
        }
        return string;
    }

    protected Configurable[] buildConfigurables() {
        this.myGeneralPanel = new VcsGeneralConfigurationConfigurable(this.myProject, this);
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(this.myGeneralPanel);
        result2.add(new VcsBackgroundOperationsConfigurable(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add(new IgnoredSettingsPanel(this.myProject));
        }
        result2.add(new IssueNavigationConfigurationPanel(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add(new ChangelistConflictConfigurable(ChangeListManagerImpl.getInstanceImpl(this.myProject)));
        }
        result2.add(new CommitDialogConfigurable(this.myProject));
        result2.add(new ShelfProjectConfigurable(this.myProject));
        for (VcsConfigurableProvider provider : (VcsConfigurableProvider[])VcsConfigurableProvider.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)provider.getConfigurable(this.myProject));
        }
        Set projectConfigurableIds = ContainerUtil.map2Set((Object[])this.myProject.getExtensions(Configurable.PROJECT_CONFIGURABLE), ep -> ep.id);
        for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss()) {
            if (projectConfigurableIds.contains(VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName()))) continue;
            result2.add(ConfigurableWrapper.wrapConfigurable(new VcsConfigurableEP(this.myProject, descriptor)));
        }
        return (Configurable[])ArrayUtil.toObjectArray((Collection)result2, Configurable.class);
    }

    @Nullable
    public VcsDirectoryConfigurationPanel getMappings() {
        return this.myMappings;
    }

    @NotNull
    public static String getVcsConfigurableId(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getVcsConfigurableId"));
        }
        String string = "vcs." + displayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getVcsConfigurableId"));
        }
        return string;
    }

    private static class VcsConfigurableEP
    extends ConfigurableEP<Configurable> {
        private static final int WEIGHT = -500;
        @NotNull
        private final VcsDescriptor myDescriptor;

        public VcsConfigurableEP(@NotNull Project project2, @NotNull VcsDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$VcsConfigurableEP", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$VcsConfigurableEP", "<init>"));
            }
            super(project2);
            this.myDescriptor = descriptor;
            this.displayName = descriptor.getDisplayName();
            this.id = VcsManagerConfigurable.getVcsConfigurableId(descriptor.getDisplayName());
            this.groupWeight = -500;
        }

        @NotNull
        protected ConfigurableEP.ObjectProducer createProducer() {
            ConfigurableEP.ObjectProducer objectProducer = new ConfigurableEP.ObjectProducer(){

                protected Object createElement() {
                    return ((AbstractVcs)ObjectUtils.notNull((Object)ProjectLevelVcsManager.getInstance((Project)this.getProject()).findVcsByName(myDescriptor.getName()))).getConfigurable();
                }

                protected boolean canCreateElement() {
                    return true;
                }

                protected Class<?> getType() {
                    return SearchableConfigurable.class;
                }
            };
            if (objectProducer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$VcsConfigurableEP", "createProducer"));
            }
            return objectProducer;
        }
    }
}

