/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LineStatusTracker
extends LineStatusTrackerBase {
    private static final Key<JPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    @NotNull
    private Mode myMode;

    private LineStatusTracker(@NotNull Project project2, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        super(project2, document);
        this.myVirtualFile = virtualFile;
        this.myMode = mode;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project2);
        this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
    }

    public static LineStatusTracker createOn(@NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull Project project2, @NotNull Mode mode) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        return new LineStatusTracker(project2, document, virtualFile, mode);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = super.getProject();
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getProject"));
        }
        return project2;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getMode"));
        }
        return mode;
    }

    public boolean isAvailableAt(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTracker", "isAvailableAt"));
        }
        return this.myMode != Mode.SILENT && editor.getSettings().isLineMarkerAreaShown() && !DiffUtil.isDiffEditor(editor);
    }

    public void setMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "setMode"));
        }
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        this.reinstallRanges();
    }

    @Override
    protected boolean isDetectWhitespaceChangedLines() {
        return this.myMode == Mode.SMART;
    }

    @Override
    protected void installNotification(@NotNull String text2) {
        FileEditor[] editors;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/ex/LineStatusTracker", "installNotification"));
        }
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 != null) continue;
            EditorNotificationPanel newPanel = new EditorNotificationPanel().text(text2);
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)newPanel);
        }
    }

    @Override
    protected void destroyNotification() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)panel2);
            editor.putUserData(PANEL_KEY, null);
        }
    }

    @Override
    protected void createHighlighter(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createHighlighter"));
        }
        this.myApplication.assertIsDispatchThread();
        if (range.getHighlighter() != null) {
            LOG.error("Multiple highlighters registered for the same Range");
            return;
        }
        if (this.myMode == Mode.SILENT) {
            return;
        }
        int first = range.getLine1() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine1());
        int second = range.getLine2() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine2());
        MarkupModel markupModel = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range, new TextRange(first, second), markupModel);
        highlighter.setLineMarkerRenderer(LineStatusMarkerRenderer.createRenderer(range, (Function<Editor, LineStatusMarkerPopup>)((Function)editor -> {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "lambda$createHighlighter$0"));
            }
            return new LineStatusTrackerDrawing.MyLineStatusMarkerPopup(this, (Editor)editor, range);
        })));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        range.setHighlighter(highlighter);
    }

    @Override
    protected void fireFileUnchanged() {
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.getProject(), () -> FileDocumentManager.getInstance().saveDocument(this.myDocument));
        }
    }

    @Override
    protected void doRollbackRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doRollbackRange"));
        }
        super.doRollbackRange(range);
        this.markLinesUnchanged(range.getLine1(), range.getLine1() + range.getVcsLine2() - range.getVcsLine1());
    }

    private void markLinesUnchanged(int startLine, int endLine) {
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)this.myDocument).clearLineModificationFlags(startLine, endLine);
    }

    public static enum Mode {
        DEFAULT,
        SMART,
        SILENT;

    }
}

