/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range {
    private static final Logger LOG = Logger.getInstance(Range.class);
    public static final byte EQUAL = 0;
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myLine1;
    private int myLine2;
    private int myVcsLine1;
    private int myVcsLine2;
    @Nullable
    private final List<InnerRange> myInnerRanges;
    @Nullable
    private RangeHighlighter myRangeHighlighter;
    private boolean myValid;

    public Range(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/Range", "<init>"));
        }
        this(range.getLine1(), range.getLine2(), range.getVcsLine1(), range.getVcsLine2());
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2) {
        this(line1, line2, vcsLine1, vcsLine2, null);
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2, @Nullable List<InnerRange> innerRanges) {
        this.myValid = true;
        assert (line1 != line2 || vcsLine1 != vcsLine2);
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myVcsLine1 = vcsLine1;
        this.myVcsLine2 = vcsLine2;
        this.myInnerRanges = innerRanges;
    }

    public int hashCode() {
        return this.myVcsLine1 ^ this.myVcsLine2 ^ this.myLine1 ^ this.myLine2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (this.myLine1 != range.myLine1) {
            return false;
        }
        if (this.myLine2 != range.myLine2) {
            return false;
        }
        if (this.myVcsLine1 != range.myVcsLine1) {
            return false;
        }
        if (this.myVcsLine2 != range.myVcsLine2) {
            return false;
        }
        if (this.myInnerRanges == null) {
            return range.myInnerRanges == null;
        }
        if (range.myInnerRanges == null) {
            return false;
        }
        if (this.myInnerRanges.size() != range.myInnerRanges.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myInnerRanges.size(); ++i2) {
            if (this.myInnerRanges.get(i2).equals(range.myInnerRanges.get(i2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("%s, %s, %s, %s", this.myLine1, this.myLine2, this.myVcsLine1, this.myVcsLine2);
    }

    public byte getType() {
        if (this.myLine1 == this.myLine2) {
            return 3;
        }
        if (this.myVcsLine1 == this.myVcsLine2) {
            return 2;
        }
        return 1;
    }

    public void shift(int shift) {
        this.myLine1 += shift;
        this.myLine2 += shift;
        if (this.myInnerRanges != null) {
            for (InnerRange range : this.myInnerRanges) {
                range.shift(shift);
            }
        }
    }

    public void vcsShift(int shift) {
        this.myVcsLine1 += shift;
        this.myVcsLine2 += shift;
    }

    @Nullable
    public List<InnerRange> getInnerRanges() {
        return this.myInnerRanges;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    public int getVcsLine1() {
        return this.myVcsLine1;
    }

    public int getVcsLine2() {
        return this.myVcsLine2;
    }

    public void setHighlighter(@Nullable RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isSelectedByLine(int line) {
        return DiffUtil.isSelectedByLine(line, this.myLine1, this.myLine2);
    }

    @NotNull
    private static String getTypeName(byte type2) {
        switch (type2) {
            case 1: {
                if ("MODIFIED" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "getTypeName"));
                }
                return "MODIFIED";
            }
            case 2: {
                if ("INSERTED" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "getTypeName"));
                }
                return "INSERTED";
            }
            case 3: {
                if ("DELETED" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "getTypeName"));
                }
                return "DELETED";
            }
            case 0: {
                if ("EQUAL" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "getTypeName"));
                }
                return "EQUAL";
            }
        }
        String string = "UNKNOWN(" + type2 + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/Range", "getTypeName"));
        }
        return string;
    }

    public static class InnerRange {
        private int myLine1;
        private int myLine2;
        private final byte myType;

        public InnerRange(int line1, int line2, byte type2) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myType = type2;
        }

        public int getLine1() {
            return this.myLine1;
        }

        public int getLine2() {
            return this.myLine2;
        }

        public byte getType() {
            return this.myType;
        }

        public void shift(int shift) {
            this.myLine1 += shift;
            this.myLine2 += shift;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerRange range = (InnerRange)o;
            if (this.myLine1 != range.myLine1) {
                return false;
            }
            if (this.myLine2 != range.myLine2) {
                return false;
            }
            return this.myType == range.myType;
        }

        public int hashCode() {
            int result2 = this.myLine1;
            result2 = 31 * result2 + this.myLine2;
            result2 = 31 * result2 + this.myType;
            return result2;
        }

        public String toString() {
            return String.format("%s, %s, %s", this.myLine1, this.myLine2, Range.getTypeName(this.myType));
        }
    }
}

