/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListenerImpl;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectLevelVcsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements ProjectComponent,
PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
    @NonNls
    private static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final ProjectLevelVcsManagerSerialization mySerialization;
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    private final MappingsToRoots myMappingsToRoots;
    private ContentManager myContentManager;
    private ConsoleView myConsole;
    private final Disposable myConsoleDisposer = new Disposable(){

        public void dispose() {
            if (ProjectLevelVcsManagerImpl.this.myConsole != null) {
                Disposer.dispose((Disposable)ProjectLevelVcsManagerImpl.this.myConsole);
                ProjectLevelVcsManagerImpl.this.myConsole = null;
            }
        }
    };
    private final VcsInitialization myInitialization;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    private boolean myHaveLegacyVcsConfiguration;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private volatile int myBackgroundOperationCounter;
    private final Set<ActionKey> myBackgroundRunningTasks = ContainerUtil.newHashSet();
    private final List<Pair<String, ConsoleViewContentType>> myPendingOutput = ContainerUtil.newArrayList();
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;
    private final FileIndexFacade myExcludedIndex;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private final VcsAnnotationLocalChangesListenerImpl myAnnotationLocalChangesListener;
    private final Map<VcsListener, MessageBusConnection> myAdapters = new HashMap<VcsListener, MessageBusConnection>();

    public ProjectLevelVcsManagerImpl(Project project2, FileStatusManager manager, FileIndexFacade excludedFileIndex, ProjectManager projectManager, DefaultVcsRootPolicy defaultVcsRootPolicy, VcsFileListenerContextHelper vcsFileListenerContextHelper) {
        this.myProject = project2;
        this.mySerialization = new ProjectLevelVcsManagerSerialization();
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myDefaultVcsRootPolicy = defaultVcsRootPolicy;
        this.myInitialization = new VcsInitialization(this.myProject);
        Disposer.register((Disposable)project2, (Disposable)this.myInitialization);
        projectManager.addProjectManagerListener(project2, new ProjectManagerListener(){

            public void projectClosing(Project project2) {
                Disposer.dispose((Disposable)ProjectLevelVcsManagerImpl.this.myInitialization);
            }
        });
        if (project2.isDefault()) {
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                @Override
                public void appClosing() {
                    Disposer.dispose((Disposable)ProjectLevelVcsManagerImpl.this.myInitialization);
                }
            });
        }
        this.myMappings = new NewMappings(this.myProject, this, manager);
        this.myMappingsToRoots = new MappingsToRoots(this.myMappings, this.myProject);
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        this.myVcsFileListenerContextHelper = vcsFileListenerContextHelper;
        VcsListener vcsListener = () -> {
            this.myVcsHistoryCache.clear();
            this.myVcsFileListenerContextHelper.possiblySwitchActivation(this.hasActiveVcss());
        };
        this.myExcludedIndex = excludedFileIndex;
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)vcsListener);
        connection.subscribe(UpdatedFilesListener.UPDATED_FILES, arg_0 -> ((ContentRevisionCache)this.myContentRevisionCache).clearCurrent(arg_0));
        this.myAnnotationLocalChangesListener = new VcsAnnotationLocalChangesListenerImpl(this.myProject, this);
    }

    public void initComponent() {
        this.myOptionsAndConfirmations.init((Convertor<String, VcsShowConfirmationOption.Value>)((Convertor)this.mySerialization::getInitOptionValue));
    }

    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(String name2) {
        if (name2 == null) {
            return null;
        }
        AbstractVcs result2 = this.myProject.isDisposed() ? null : AllVcses.getInstance(this.myProject).getByName(name2);
        ProgressManager.checkCanceled();
        return result2;
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name2) {
        if (name2 == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name2);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file2, Processor<VirtualFile> processor2) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file2, processor2);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    public void dispose() {
        this.releaseConsole();
        this.myMappings.disposeMe();
        Disposer.dispose((Disposable)this.myAnnotationLocalChangesListener);
        this.myContentManager = null;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager != null && toolWindowManager.getToolWindow(ToolWindowId.VCS) != null) {
            toolWindowManager.unregisterToolWindow(ToolWindowId.VCS);
        }
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        VcsAnnotationLocalChangesListenerImpl vcsAnnotationLocalChangesListenerImpl = this.myAnnotationLocalChangesListener;
        if (vcsAnnotationLocalChangesListenerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getAnnotationLocalChangesListener"));
        }
        return vcsAnnotationLocalChangesListenerImpl;
    }

    public void projectOpened() {
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, () -> {
            VcsRootChecker[] checkers;
            if (!ApplicationManager.getApplication().isUnitTestMode() && (checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)).length != 0) {
                VcsRootScanner.start(this.myProject, checkers);
            }
        });
    }

    public void projectClosed() {
        this.releaseConsole();
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectLevelVcsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getComponentName"));
        }
        return "ProjectLevelVcsManager";
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        for (VirtualFile file2 : files) {
            if (this.getVcsFor(file2) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getVcsFor"));
        }
        String vcsName = this.myMappings.getVcsFor(file2);
        if (vcsName == null || vcsName.isEmpty()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getByName(vcsName);
    }

    @Nullable
    public AbstractVcs getVcsFor(FilePath file2) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        return (AbstractVcs)ReadAction.compute(() -> {
            if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myProject.isInitialized()) {
                return null;
            }
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null) {
                return this.getVcsFor(vFile);
            }
            return null;
        });
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        if (directory.isEmpty()) {
            return this.myDefaultVcsRootPolicy.getVcsRootFor(file2);
        }
        return LocalFileSystem.getInstance().findFileByPath(directory);
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(VirtualFile file2) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        AbstractVcs vcs = this.findVcsByName(mapping.getVcs());
        if (directory.isEmpty()) {
            return new VcsRoot(vcs, this.myDefaultVcsRootPolicy.getVcsRootFor(file2));
        }
        return new VcsRoot(vcs, LocalFileSystem.getInstance().findFileByPath(directory));
    }

    @Nullable
    public VirtualFile getVcsRootFor(FilePath file2) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        if (vFile != null) {
            return this.getVcsRootFor(vFile);
        }
        return null;
    }

    public VcsRoot getVcsRootObjectFor(FilePath file2) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        if (vFile != null) {
            return this.getVcsRootObjectFor(vFile);
        }
        return null;
    }

    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_VCS, "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "unregisterVcs"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        if (this.myContentManager == null) {
            ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS);
            this.myContentManager = changes == null ? null : changes.getContentManager();
        }
        return this.myContentManager;
    }

    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs[] getAllActiveVcss() {
        return this.myMappings.getActiveVcses();
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Deprecated
    public void addMessageToConsoleWindow(String message2, TextAttributes attributes) {
        this.addMessageToConsoleWindow(message2, new ConsoleViewContentType("", attributes));
    }

    public void addMessageToConsoleWindow(@Nullable String message2, @NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "addMessageToConsoleWindow"));
        }
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (contentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "lambda$addMessageToConsoleWindow$3"));
            }
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return;
            }
            ContentManager contentManager = this.getContentManager();
            if (contentManager == null) {
                this.myPendingOutput.add((Pair<String, ConsoleViewContentType>)Pair.create((Object)message2, (Object)contentType));
            } else {
                this.getOrCreateConsoleContent(contentManager);
                this.printToConsole(message2, contentType);
            }
        }, ModalityState.defaultModalityState());
    }

    private Content getOrCreateConsoleContent(ContentManager contentManager) {
        String displayName = VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]);
        Content content = contentManager.findContent(displayName);
        if (content == null) {
            this.releaseConsole();
            this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject).getConsole();
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)this.myConsole.getComponent(), "Center");
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)new DefaultActionGroup(this.myConsole.createConsoleActions()), false);
            panel2.add((Component)toolbar.getComponent(), "West");
            content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, displayName, true);
            content.setDisposer(this.myConsoleDisposer);
            contentManager.addContent(content);
            for (Pair<String, ConsoleViewContentType> pair2 : this.myPendingOutput) {
                this.printToConsole((String)pair2.first, (ConsoleViewContentType)pair2.second);
            }
            this.myPendingOutput.clear();
        }
        return content;
    }

    private void printToConsole(@NotNull String message2, @NotNull ConsoleViewContentType contentType) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "printToConsole"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "printToConsole"));
        }
        this.myConsole.print(message2 + "\n", contentType);
    }

    private void releaseConsole() {
        Disposer.dispose((Disposable)this.myConsoleDisposer);
    }

    @Override
    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        VcsShowSettingOption vcsShowSettingOption = this.myOptionsAndConfirmations.getOptions(option);
        if (vcsShowSettingOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOptions"));
        }
        return vcsShowSettingOption;
    }

    @Override
    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return this.myOptionsAndConfirmations.getAllOptions();
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option, @NotNull AbstractVcs vcs) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_VCS, "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        VcsShowOptionsSettingImpl options = (VcsShowOptionsSettingImpl)this.getOptions(option);
        options.addApplicableVcs(vcs);
        VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl = options;
        if (vcsShowOptionsSettingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardOption"));
        }
        return vcsShowOptionsSettingImpl;
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        if (vcsActionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsActionName", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_VCS, "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        VcsShowSettingOption vcsShowSettingOption = this.myOptionsAndConfirmations.getOrCreateCustomOption(vcsActionName, vcs);
        if (vcsShowSettingOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getOrCreateCustomOption"));
        }
        return vcsShowSettingOption;
    }

    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        UpdateInfoTree tree = this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree);
        }
    }

    @Override
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        ContentUtilEx.addTabbedContent(contentManager, (JComponent)((Object)updateInfoTree), "Update Info", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()), false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public void cleanupMappings() {
        this.myMappings.cleanupMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(FilePath path) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (vFile != null) {
            return this.myMappings.getMappingFor(vFile);
        }
        return null;
    }

    private boolean hasExplicitMapping(VirtualFile vFile) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(vFile);
        return mapping != null && !mapping.isDefaultMapping();
    }

    public void setDirectoryMapping(String path, String activeVcsName) {
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path), activeVcsName);
    }

    public void setAutoDirectoryMapping(String path, String activeVcsName) {
        List<VirtualFile> defaultRoots = this.myMappings.getDefaultRoots();
        if (defaultRoots.size() == 1 && StringUtil.isEmpty((String)this.myMappings.haveDefaultMapping())) {
            this.myMappings.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
        }
        this.myMappings.setMapping(path, activeVcsName);
    }

    public void removeDirectoryMapping(VcsDirectoryMapping mapping) {
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        this.mySerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        if (this.myHaveLegacyVcsConfiguration) {
            element.setAttribute(SETTINGS_EDITED_MANUALLY, "true");
        }
        return element;
    }

    public void loadState(Element state) {
        this.mySerialization.readExternalUtil(state, this.myOptionsAndConfirmations);
        Attribute attribute = state.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option, AbstractVcs vcs) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardConfirmation"));
        }
        VcsShowConfirmationOptionImpl result2 = this.getConfirmation(option);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl = result2;
        if (vcsShowConfirmationOptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getStandardConfirmation"));
        }
        return vcsShowConfirmationOptionImpl;
    }

    @Override
    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return this.myOptionsAndConfirmations.getAllConfirmations();
    }

    @Override
    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option) {
        VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl = this.myOptionsAndConfirmations.getConfirmation(option);
        if (vcsShowConfirmationOptionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getConfirmation"));
        }
        return vcsShowConfirmationOptionImpl;
    }

    public void addVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(VCS_CONFIGURATION_CHANGED, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void startBackgroundVcsOperation() {
        ++this.myBackgroundOperationCounter;
    }

    public void stopBackgroundVcsOperation() {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        LOG.assertTrue(this.myBackgroundOperationCounter > 0, (Object)"myBackgroundOperationCounter > 0");
        --this.myBackgroundOperationCounter;
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_VCS, "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getRootsUnderVcs"));
        }
        VirtualFile[] virtualFileArray = this.myMappingsToRoots.getRootsUnderVcs(vcs);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getRootsUnderVcs"));
        }
        return virtualFileArray;
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        return this.myMappingsToRoots.getDetailedVcsMappings(vcs);
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    @NotNull
    public VcsRoot[] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        VcsRoot[] vcsRootArray = vcsRoots.toArray(new VcsRoot[vcsRoots.size()]);
        if (vcsRootArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "getAllVcsRoots"));
        }
        return vcsRootArray;
    }

    public void updateActiveVcss() {
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsListener)this.myProject.getMessageBus().syncPublisher(VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    void readDirectoryMappings(Element element) {
        this.myMappings.clear();
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        boolean haveNonEmptyMappings = false;
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            VcsRootSettings rootSettings;
            String vcs = child.getAttributeValue(ATTRIBUTE_VCS);
            if (vcs != null && !vcs.isEmpty()) {
                haveNonEmptyMappings = true;
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(child.getAttributeValue(ATTRIBUTE_DIRECTORY), vcs);
            mappingsList.add(mapping);
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement == null) continue;
            String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
            AbstractVcs vcsInstance = this.findVcsByName(mapping.getVcs());
            if (vcsInstance == null || className == null || (rootSettings = vcsInstance.createEmptyVcsRootSettings()) == null) continue;
            try {
                rootSettings.readExternal(rootSettingsElement);
                mapping.setRootSettings(rootSettings);
            }
            catch (InvalidDataException e) {
                LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
            }
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    void writeDirectoryMappings(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "writeDirectoryMappings"));
        }
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && StringUtil.isEmpty((String)mapping.getDirectory()) && StringUtil.isEmpty((String)mapping.getVcs())) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(VirtualFile file2) {
        VcsDescriptor[] vcsDescriptors = this.getAllVcss();
        VcsDescriptor probableVcs = null;
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            if (!vcsDescriptor.probablyUnderVcs(file2)) continue;
            if (probableVcs != null) {
                return null;
            }
            probableVcs = vcsDescriptor;
        }
        return probableVcs == null ? null : this.findVcsByName(probableVcs.getName());
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.mappingsChanged();
        }
    }

    @Override
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    @Deprecated
    public BackgroundableActionEnabledHandler getBackgroundableActionHandler(VcsBackgroundableActions action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return new BackgroundableActionEnabledHandler(this.myProject, action);
    }

    boolean isBackgroundTaskRunning(Object ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "isBackgroundTaskRunning"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    void startBackgroundTask(Object ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "startBackgroundTask"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    void stopBackgroundTask(Object ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl", "stopBackgroundTask"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(VcsInitObject vcsInitObject, Runnable runnable2) {
        ApplicationManager.getApplication().runReadAction(() -> this.myInitialization.add(vcsInitObject, runnable2));
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        return (Boolean)ReadAction.compute(() -> vf != null && (this.myExcludedIndex.isInContent(vf) || this.isFileInBaseDir(vf) || vf.equals(this.myProject.getBaseDir()) || this.hasExplicitMapping(vf) || this.isInDirectoryBasedRoot(vf) || !Registry.is((String)"ide.hide.excluded.files") && this.myExcludedIndex.isExcludedFile(vf)) && !this.isIgnored(vf));
    }

    public boolean isIgnored(VirtualFile vf) {
        if (Registry.is((String)"ide.hide.excluded.files")) {
            return this.myExcludedIndex.isExcludedFile(vf);
        }
        return this.myExcludedIndex.isUnderIgnored(vf);
    }

    private boolean isInDirectoryBasedRoot(@Nullable VirtualFile file2) {
        if (file2 != null && ProjectKt.isDirectoryBased(this.myProject)) {
            return ProjectKt.getStateStore(this.myProject).isProjectFile(file2);
        }
        return false;
    }

    private boolean isFileInBaseDir(VirtualFile file2) {
        VirtualFile parent = file2.getParent();
        return !file2.isDirectory() && parent != null && parent.equals(this.myProject.getBaseDir());
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }

    public void waitForInitialized() {
        this.myInitialization.waitFinished();
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey", "<init>"));
            }
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return this.getClass() + " - " + Arrays.toString(this.myObjects);
        }
    }
}

