/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootChecker[] myCheckers;

    public VcsRootDetectorImpl(@NotNull Project project2, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        if (projectLevelVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLevelVcsManager", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "<init>"));
        }
        this.myProject = project2;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
    }

    @NotNull
    public Collection<VcsRoot> detect() {
        Collection<VcsRoot> collection = this.detect(this.myProject.getBaseDir());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null || this.myCheckers.length == 0) {
            List<VcsRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
            }
            return list2;
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        roots.addAll(this.scanForRootsInContentRoots());
        for (VcsRoot root : roots) {
            if (!startDir.equals(root.getPath())) continue;
            Set<VcsRoot> set2 = roots;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
            }
            return set2;
        }
        List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(startDir);
        roots.addAll(rootsAbove);
        Set<VcsRoot> set3 = roots;
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "detect"));
        }
        return set3;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        VirtualFile[] roots;
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        if (this.myProject.isDisposed()) {
            HashSet<VcsRoot> hashSet = vcsRoots;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInContentRoots"));
            }
            return hashSet;
        }
        for (VirtualFile contentRoot : roots = this.myProjectManager.getContentRoots()) {
            Set<VcsRoot> rootsInsideRoot = this.scanForRootsInsideDir(contentRoot);
            boolean shouldScanAbove = true;
            for (VcsRoot root : rootsInsideRoot) {
                if (!contentRoot.equals(root.getPath())) continue;
                shouldScanAbove = false;
            }
            if (shouldScanAbove) {
                List<VcsRoot> rootsAbove = this.scanForSingleRootAboveDir(contentRoot);
                rootsInsideRoot.addAll(rootsAbove);
            }
            vcsRoots.addAll(rootsInsideRoot);
        }
        HashSet<VcsRoot> hashSet = vcsRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInContentRoots"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        LOG.debug("Scanning inside [" + dir + "], depth = " + depth);
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        if (VcsRootDetectorImpl.depthLimitExceeded(depth)) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
            }
            return hashSet;
        }
        if (this.myProject.isDisposed() || !dir.isDirectory() || this.myProjectManager.getFileIndex().isExcluded(dir)) {
            HashSet<VcsRoot> hashSet = roots;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
            }
            return hashSet;
        }
        List<AbstractVcs> vcsList = this.getVcsListFor(dir);
        LOG.debug("Found following VCSs: " + vcsList);
        for (AbstractVcs vcs : vcsList) {
            roots.add(new VcsRoot(vcs, dir));
        }
        for (VirtualFile child : dir.getChildren()) {
            roots.addAll(this.scanForRootsInsideDir(child, depth + 1));
        }
        HashSet<VcsRoot> hashSet = roots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        return hashSet;
    }

    private static boolean depthLimitExceeded(int depth) {
        int maxDepth = Registry.intValue((String)"vcs.root.detector.folder.depth");
        return maxDepth >= 0 && maxDepth < depth;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        Set<VcsRoot> set2 = this.scanForRootsInsideDir(dir, 0);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForRootsInsideDir"));
        }
        return set2;
    }

    @NotNull
    private List<VcsRoot> scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
        }
        ArrayList<VcsRoot> roots = new ArrayList<VcsRoot>();
        if (this.myProject.isDisposed()) {
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
            }
            return arrayList;
        }
        for (VirtualFile par = dir.getParent(); par != null; par = par.getParent()) {
            List<AbstractVcs> vcsList = this.getVcsListFor(par);
            for (AbstractVcs vcs : vcsList) {
                roots.add(new VcsRoot(vcs, par));
            }
            if (roots.isEmpty()) continue;
            ArrayList<VcsRoot> arrayList = roots;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
            }
            return arrayList;
        }
        ArrayList<VcsRoot> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "scanForSingleRootAboveDir"));
        }
        return arrayList;
    }

    @NotNull
    private List<AbstractVcs> getVcsListFor(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "getVcsListFor"));
        }
        ArrayList<AbstractVcs> vcsList = new ArrayList<AbstractVcs>();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(dir.getPath())) continue;
            vcsList.add(this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName()));
        }
        ArrayList<AbstractVcs> arrayList = vcsList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl", "getVcsListFor"));
        }
        return arrayList;
    }
}

