/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.MonospaceEditorCustomization;
import com.intellij.ui.RightMarginEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.WrapWhenTypingReachesRightMarginCustomization;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageI {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;
    @NotNull
    private List<ChangeList> myChangeLists;

    public CommitMessage(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        this(project2, true, true, true);
    }

    public CommitMessage(@NotNull Project project2, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        super(new BorderLayout());
        this.myChangeLists = Collections.emptyList();
        this.myEditorField = CommitMessage.createCommitMessageEditor(project2, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.add((Component)((Object)this.myEditorField), "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)CommitMessage.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)CommitMessage.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @NotNull
    private static JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "createToolbar"));
        }
        return jComponent;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/ui/CommitMessage", "setSeparatorText"));
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text2);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @Deprecated
    public static EditorTextField createCommitTextEditor(@NotNull Project project2, boolean forceSpellCheckOn) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "createCommitTextEditor"));
        }
        return CommitMessage.createCommitMessageEditor(project2, false);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project2, boolean runInspections) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "createCommitMessageEditor"));
        }
        HashSet features = ContainerUtil.newHashSet();
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project2);
        if (configuration != null) {
            features.add(new RightMarginEditorCustomization(configuration.USE_COMMIT_MESSAGE_MARGIN, CommitMessageInspectionProfile.getBodyRightMargin(project2)));
            features.add(WrapWhenTypingReachesRightMarginCustomization.getInstance(configuration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN));
        } else {
            features.add(new RightMarginEditorCustomization(false, -1));
        }
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(MonospaceEditorCustomization.getInstance());
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project2));
        } else {
            features.add(SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project2, EditorTextFieldProvider.class);
        EditorTextField editorTextField = service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project2, features);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "createCommitMessageEditor"));
        }
        return editorTextField;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/ui/CommitMessage", "isCommitMessage"));
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        return document != null && document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ui/CommitMessage", "getEditor"));
        }
        CommitMessage commitMessage = (CommitMessage)document.getUserData(DATA_KEY);
        return commitMessage != null ? commitMessage.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getToolbarActions"));
        }
        return actionGroup;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField = this.myEditorField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getEditorField"));
        }
        return editorTextField;
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    @NotNull
    public String getComment() {
        String string = StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getComment"));
        }
        return string;
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myEditorField), true));
        this.myEditorField.selectAll();
    }

    public void dispose() {
    }

    public void setChangeLists(@NotNull List<ChangeList> value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/ui/CommitMessage", "setChangeLists"));
        }
        WriteAction.run(() -> {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/ui/CommitMessage", "lambda$setChangeLists$1"));
            }
            this.myChangeLists = value2;
        });
    }

    @NotNull
    public List<ChangeList> getChangeLists() {
        List<ChangeList> list2 = this.myChangeLists;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getChangeLists"));
        }
        return list2;
    }

    private static class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        public ConditionalTrafficLightRenderer(@NotNull Project project2, @NotNull Document document, @Nullable PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer", "<init>"));
            }
            super(project2, document, file2);
        }

        @Override
        protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
            super.refresh(editorMarkupModel);
            if (editorMarkupModel != null) {
                editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.errorCount));
            }
        }

        private boolean hasHighSeverities(@NotNull int[] errorCount) {
            if (errorCount == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCount", "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer", "hasHighSeverities"));
            }
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            for (int i2 = 0; i2 < errorCount.length; ++i2) {
                if (errorCount[i2] <= 0 || this.getSeverityRegistrar().compare(this.getSeverityRegistrar().getSeverityByIndex(i2), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        public InspectionCustomization(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization", "<init>"));
            }
            this.myProject = project2;
        }

        @Override
        public void customize(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization", "customize"));
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument());
            if (file2 != null) {
                file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, profile2 -> new InspectionProfileWrapper(CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, false);
            ((EditorMarkupModelImpl)editor.getMarkupModel()).setErrorStripeRenderer(new ConditionalTrafficLightRenderer(this.myProject, editor.getDocument(), file2));
        }
    }
}

