/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
    private final TempFileSystem TEMP_FILE_SYSTEM;
    private final LocalFileSystem LOCAL_FILE_SYSTEM;
    private final JarFileSystem JAR_FILE_SYSTEM;
    private final Map<VirtualFilePointerListener, FilePointerPartNode> myPointers;
    private final Set<VirtualFilePointerContainerImpl> myContainers;
    @NotNull
    private final VirtualFileManager myVirtualFileManager;
    @NotNull
    private final MessageBus myBus;
    private static final Comparator<String> URL_COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? String::compareTo : String::compareToIgnoreCase;
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;
    private final Set<VirtualFilePointerImpl> myStoredPointers;
    private List<EventDescriptor> myEvents;
    private List<FilePointerPartNode> myNodesToUpdateUrl;
    private List<FilePointerPartNode> myNodesToFire;

    VirtualFilePointerManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull MessageBus bus, @NotNull TempFileSystem tempFileSystem, @NotNull LocalFileSystem localFileSystem, @NotNull JarFileSystem jarFileSystem) {
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (tempFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (localFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        if (jarFileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileSystem", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "<init>"));
        }
        this.myPointers = new LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode>();
        this.myContainers = ContainerUtil.newIdentityTroveSet();
        this.myUrlToIdentity = new THashMap();
        this.myStoredPointers = ContainerUtil.newIdentityTroveSet();
        this.myEvents = Collections.emptyList();
        this.myNodesToUpdateUrl = Collections.emptyList();
        this.myNodesToFire = Collections.emptyList();
        this.myVirtualFileManager = virtualFileManager;
        this.myBus = bus;
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        this.TEMP_FILE_SYSTEM = tempFileSystem;
        this.LOCAL_FILE_SYSTEM = localFileSystem;
        this.JAR_FILE_SYSTEM = jarFileSystem;
    }

    public void dispose() {
        this.assertAllPointersDisposed();
    }

    @NotNull
    private static VirtualFilePointer[] toPointers(@NotNull List<FilePointerPartNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
        }
        if (nodes.isEmpty()) {
            if (VirtualFilePointer.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
            }
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        ArrayList list2 = new ArrayList(nodes.size());
        for (FilePointerPartNode node : nodes) {
            node.addAllPointersTo(list2);
        }
        VirtualFilePointer[] virtualFilePointerArray = list2.toArray(new VirtualFilePointer[list2.size()]);
        if (virtualFilePointerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "toPointers"));
        }
        return virtualFilePointerArray;
    }

    VirtualFilePointer[] getPointersUnder(VirtualFile parent, String childName) {
        ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
        this.addPointersUnder(parent, true, childName, nodes);
        return VirtualFilePointerManagerImpl.toPointers(nodes);
    }

    private void addPointersUnder(VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addPointersUnder"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addPointersUnder"));
        }
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.addPointersUnder(parent, separator, childName, out);
        }
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        VirtualFilePointer virtualFilePointer = this.create(null, url, parent, listener2);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointer;
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        VirtualFilePointer virtualFilePointer = this.create(file2, null, parent, listener2);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointer;
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file2, @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        boolean isJar;
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        if (file2 == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
                path = url;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = this.myVirtualFileManager.getFileSystem(protocol);
                path = url.substring(protocolEnd + "://".length());
            }
        } else {
            fileSystem = file2.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = file2.getPath();
            url = VirtualFileManager.constructUrl((String)protocol, (String)path);
        }
        if (fileSystem == this.TEMP_FILE_SYSTEM) {
            VirtualFile found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            LightFilePointer lightFilePointer = found == null ? new LightFilePointer(url) : new LightFilePointer(found);
            if (lightFilePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
            }
            return lightFilePointer;
        }
        boolean bl = isJar = fileSystem == this.JAR_FILE_SYSTEM;
        if (fileSystem != this.LOCAL_FILE_SYSTEM && !isJar) {
            VirtualFile found = fileSystem == null ? null : (file2 != null ? file2 : VirtualFileManager.getInstance().findFileByUrl(url));
            IdentityVirtualFilePointer identityVirtualFilePointer = this.getOrCreateIdentity(url, found, parentDisposable, listener2);
            if (identityVirtualFilePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
            }
            return identityVirtualFilePointer;
        }
        if (file2 == null) {
            String cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path, isJar);
            if (cleanPath != path) {
                url = VirtualFileManager.constructUrl((String)protocol, (String)cleanPath);
                path = cleanPath;
            }
            if (url.contains("..") && (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
                url = file2.getUrl();
                path = file2.getPath();
            }
        }
        VirtualFilePointerImpl pointer = this.getOrCreate(listener2, path, (Pair<VirtualFile, String>)Pair.create((Object)file2, (Object)url));
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "create"));
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    private IdentityVirtualFilePointer getOrCreateIdentity(final @NotNull String url, @Nullable VirtualFile found, @NotNull Disposable parentDisposable, VirtualFilePointerListener listener2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreateIdentity"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreateIdentity"));
        }
        IdentityVirtualFilePointer pointer = this.myUrlToIdentity.get(url);
        if (pointer == null) {
            pointer = new IdentityVirtualFilePointer(found, url, listener2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                    synchronized (virtualFilePointerManagerImpl) {
                        super.dispose();
                        VirtualFilePointerManagerImpl.this.myUrlToIdentity.remove(url);
                    }
                }
            };
            this.myUrlToIdentity.put(url, pointer);
            DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        }
        pointer.incrementUsageCount(1);
        IdentityVirtualFilePointer identityVirtualFilePointer = pointer;
        if (identityVirtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreateIdentity"));
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path, boolean isJar) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "cleanupPath"));
        }
        path = FileUtil.normalize((String)path);
        String string = path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path, isJar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "cleanupPath"));
        }
        return string;
    }

    private static String trimTrailingSeparators(@NotNull String path, boolean isJar) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "trimTrailingSeparators"));
        }
        while (!(!StringUtil.endsWithChar((CharSequence)path, (char)'/') || isJar && path.endsWith("!/"))) {
            path = StringUtil.trimEnd((String)path, (String)"/");
        }
        return path;
    }

    @NotNull
    private VirtualFilePointerImpl getOrCreate(@Nullable VirtualFilePointerListener listener2, @NotNull String path, @NotNull Pair<VirtualFile, String> fileAndUrl) {
        FilePointerPartNode node;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        if (fileAndUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAndUrl", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        FilePointerPartNode root = this.myPointers.get(listener2);
        if (root == null) {
            root = new FilePointerPartNode(path, null, fileAndUrl);
            ++root.pointersUnder;
            this.myPointers.put(listener2, root);
            node = root;
        } else {
            node = root.findPointerOrCreate(path, 0, fileAndUrl, 1);
        }
        VirtualFilePointerImpl pointer = node.getAnyPointer();
        if (pointer == null) {
            pointer = new VirtualFilePointerImpl(listener2);
            node.associate((Object)pointer, fileAndUrl);
        }
        pointer.incrementUsageCount(1);
        root.checkConsistency();
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "getOrCreate"));
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    public synchronized VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        VirtualFile file2 = pointer.getFile();
        VirtualFilePointer virtualFilePointer = file2 == null ? this.create(pointer.getUrl(), parent, listener2) : this.create(file2, parent, listener2);
        if (virtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "duplicate"));
        }
        return virtualFilePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        for (Map.Entry<VirtualFilePointerListener, FilePointerPartNode> entry : this.myPointers.entrySet()) {
            FilePointerPartNode root = entry.getValue();
            ArrayList<FilePointerPartNode> left = new ArrayList<FilePointerPartNode>();
            root.addPointersUnder(null, false, "", left);
            ArrayList pointers = new ArrayList();
            for (FilePointerPartNode node : left) {
                node.addAllPointersTo(pointers);
            }
            if (pointers.isEmpty()) continue;
            VirtualFilePointerImpl p = (VirtualFilePointerImpl)((Object)pointers.get(0));
            try {
                p.throwDisposalError("Not disposed pointer: " + (Object)((Object)p));
            }
            finally {
                for (VirtualFilePointerImpl pointer : pointers) {
                    pointer.dispose();
                }
            }
        }
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                container.throwDisposalError("Not disposed container");
            }
        }
    }

    public void storePointers() {
        this.myStoredPointers.clear();
        this.addAllPointersTo(this.myStoredPointers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertPointersAreDisposed() {
        ArrayList<VirtualFilePointerImpl> pointers = new ArrayList<VirtualFilePointerImpl>();
        this.addAllPointersTo(pointers);
        try {
            for (VirtualFilePointerImpl pointer : pointers) {
                if (this.myStoredPointers.contains((Object)pointer)) continue;
                pointer.throwDisposalError("Virtual pointer '" + (Object)((Object)pointer) + "' hasn't been disposed: " + pointer.getStackTrace());
            }
        }
        finally {
            this.myStoredPointers.clear();
        }
    }

    private void addAllPointersTo(@NotNull Collection<VirtualFilePointerImpl> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "addAllPointersTo"));
        }
        ArrayList<FilePointerPartNode> out = new ArrayList<FilePointerPartNode>();
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.addPointersUnder(null, false, "", out);
        }
        for (FilePointerPartNode node : out) {
            node.addAllPointersTo(pointers);
        }
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener2));
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl virtualFilePointerContainer) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        if (virtualFilePointerContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFilePointerContainer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            this.myContainers.add(virtualFilePointerContainer);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)virtualFilePointerContainer);
                Set set2 = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set2) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove((Object)virtualFilePointerContainer);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) assert (removed);
            }

            @NonNls
            @NotNull
            public String toString() {
                String string = "Disposing container " + (Object)((Object)virtualFilePointerContainer);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2", "toString"));
                }
                return string;
            }
        });
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = virtualFilePointerContainer;
        if (virtualFilePointerContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "registerContainer"));
        }
        return virtualFilePointerContainerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        Object[] toFirePointers;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "before"));
        }
        ArrayList<FilePointerPartNode> toFireEvents = new ArrayList<FilePointerPartNode>();
        ArrayList<FilePointerPartNode> toUpdateUrl = new ArrayList<FilePointerPartNode>();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            this.incModificationCount();
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent change;
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    this.addPointersUnder(deleteEvent.getFile(), false, "", toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.addPointersUnder(createEvent.getParent(), true, createEvent.getChildName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addPointersUnder(copyEvent.getNewParent(), true, copyEvent.getFile().getName(), toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = moveEvent.getFile();
                    this.addPointersUnder(moveEvent.getNewParent(), true, eventFile.getName(), toFireEvents);
                    ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                    this.addPointersUnder(eventFile, false, "", nodes);
                    toFireEvents.addAll(nodes);
                    for (FilePointerPartNode node : nodes) {
                        VirtualFilePointerImpl pointer2 = node.getAnyPointer();
                        VirtualFile file2 = pointer2 == null ? null : pointer2.getFile();
                        if (file2 == null) continue;
                        toUpdateUrl.add(node);
                    }
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || Comparing.equal((Object)change.getOldValue(), (Object)change.getNewValue())) continue;
                eventFile = change.getFile();
                VirtualFile parent = eventFile.getParent();
                this.addPointersUnder(parent, true, change.getNewValue().toString(), toFireEvents);
                ArrayList<FilePointerPartNode> nodes = new ArrayList<FilePointerPartNode>();
                this.addPointersUnder(eventFile, false, "", nodes);
                for (FilePointerPartNode node : nodes) {
                    VirtualFilePointerImpl pointer3 = node.getAnyPointer();
                    VirtualFile file3 = pointer3 == null ? null : pointer3.getFile();
                    if (file3 == null) continue;
                    toUpdateUrl.add(node);
                }
            }
            this.myEvents = new ArrayList<EventDescriptor>();
            toFirePointers = VirtualFilePointerManagerImpl.toPointers(toFireEvents);
            for (VirtualFilePointerListener virtualFilePointerListener : this.myPointers.keySet()) {
                List filtered;
                if (virtualFilePointerListener == null || (filtered = ContainerUtil.filter((Object[])toFirePointers, pointer -> ((VirtualFilePointerImpl)((Object)((Object)pointer))).getListener() == listener2)).isEmpty()) continue;
                EventDescriptor event = new EventDescriptor(virtualFilePointerListener, filtered.toArray(new VirtualFilePointer[filtered.size()]));
                this.myEvents.add(event);
            }
        }
        for (EventDescriptor descriptor : this.myEvents) {
            descriptor.fireBefore();
        }
        if (!toFireEvents.isEmpty()) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged((VirtualFilePointer[])toFirePointers);
        }
        this.myNodesToFire = toFireEvents;
        this.myNodesToUpdateUrl = toUpdateUrl;
        this.assertConsistency();
    }

    void assertConsistency() {
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.checkConsistency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "after"));
        }
        this.incModificationCount();
        for (FilePointerPartNode node : this.myNodesToUpdateUrl) {
            VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                String urlBefore = (String)node.myFileAndUrl.second;
                Pair<VirtualFile, String> after2 = node.update();
                assert (after2 != null) : "can't invalidate inside modification";
                String urlAfter = (String)after2.second;
                if (URL_COMPARATOR.compare(urlBefore, urlAfter) != 0 || !urlAfter.endsWith(node.part)) {
                    SmartList myPointers = new SmartList();
                    node.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                    int useCount = node.useCount;
                    FilePointerPartNode root = node.remove();
                    FilePointerPartNode newNode = root.findPointerOrCreate(VfsUtilCore.urlToPath((String)urlAfter), 0, after2, myPointers.size());
                    VirtualFilePointerImpl existingPointer = newNode.getAnyPointer();
                    if (existingPointer != null) {
                        FilePointerPartNode n = newNode;
                        while (n != null) {
                            n.pointersUnder += myPointers.size();
                            n = n.parent;
                        }
                    }
                    newNode.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                    VirtualFilePointerImpl[] newMyPointers = myPointers.toArray(new VirtualFilePointerImpl[myPointers.size()]);
                    newNode.associate(newMyPointers, after2);
                    newNode.incrementUsageCount(useCount);
                }
            }
        }
        VirtualFilePointer[] pointersToFireArray = VirtualFilePointerManagerImpl.toPointers(this.myNodesToFire);
        for (VirtualFilePointer pointer : pointersToFireArray) {
            ((VirtualFilePointerImpl)pointer).myNode.update();
        }
        for (EventDescriptor event : this.myEvents) {
            event.fireAfter();
        }
        if (pointersToFireArray.length != 0) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(pointersToFireArray);
        }
        this.myNodesToUpdateUrl = Collections.emptyList();
        this.myEvents = Collections.emptyList();
        this.myNodesToFire = Collections.emptyList();
        this.assertConsistency();
    }

    void removeNode(@NotNull FilePointerPartNode node, VirtualFilePointerListener listener2) {
        boolean rootNodeEmpty;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl", "removeNode"));
        }
        FilePointerPartNode root = node.remove();
        boolean bl = rootNodeEmpty = root.children.length == 0;
        if (rootNodeEmpty) {
            this.myPointers.remove(listener2);
        }
        this.assertConsistency();
    }

    public long getModificationCount() {
        return super.getModificationCount() + (long)PersistentFS.getInstance().getStructureModificationCount();
    }

    int numberOfPointers() {
        int number = 0;
        for (FilePointerPartNode root : this.myPointers.values()) {
            number = root.numberOfPointersUnder();
        }
        return number;
    }

    int numberOfListeners() {
        return this.myPointers.keySet().size();
    }

    int numberOfCachedUrlToIdentity() {
        return this.myUrlToIdentity.size();
    }

    private static class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        private final TObjectIntHashMap<VirtualFilePointerImpl> myCounts;
        private final Disposable myParent;

        private DelegatingDisposable(@NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "<init>"));
            }
            this.myCounts = new TObjectIntHashMap();
            this.myParent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "registerDisposable"));
            }
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable", "registerDisposable"));
            }
            DelegatingDisposable result2 = (DelegatingDisposable)ourInstances.get(parentDisposable);
            if (result2 == null && (result2 = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result2);
            }
            DelegatingDisposable delegatingDisposable = result2;
            synchronized (delegatingDisposable) {
                result2.myCounts.put((Object)pointer, result2.myCounts.get((Object)pointer) + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.forEachEntry((pointer, disposeCount) -> {
                    int after2 = pointer.incrementUsageCount(-disposeCount + 1);
                    LOG.assertTrue(after2 > 0, (Object)after2);
                    pointer.dispose();
                    return true;
                });
            }
        }
    }

    private static class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        @NotNull
        private final VirtualFilePointer[] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener2, @NotNull VirtualFilePointer[] pointers) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor", "<init>"));
            }
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor", "<init>"));
            }
            this.myListener = listener2;
            this.myPointers = pointers;
        }

        private void fireBefore() {
            if (this.myPointers.length != 0) {
                this.myListener.beforeValidityChanged(this.myPointers);
            }
        }

        private void fireAfter() {
            if (this.myPointers.length != 0) {
                this.myListener.validityChanged(this.myPointers);
            }
        }
    }
}

