/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Win32FsCache {
    private final IdeaWin32 myKernel = IdeaWin32.getInstance();
    private Reference<TIntObjectHashMap<THashMap<String, FileAttributes>>> myCache;

    Win32FsCache() {
    }

    void clearCache() {
        this.myCache = null;
    }

    @NotNull
    private TIntObjectHashMap<THashMap<String, FileAttributes>> getMap() {
        TIntObjectHashMap map2 = (TIntObjectHashMap)SoftReference.dereference(this.myCache);
        if (map2 == null) {
            map2 = new TIntObjectHashMap();
            this.myCache = new java.lang.ref.SoftReference<TIntObjectHashMap>(map2);
        }
        TIntObjectHashMap tIntObjectHashMap = map2;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/win32/Win32FsCache", "getMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    String[] list(@NotNull VirtualFile file2) {
        int parentId;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/win32/Win32FsCache", "list"));
        }
        String path = file2.getPath();
        FileInfo[] fileInfo = this.myKernel.listChildren(path);
        if (fileInfo == null || fileInfo.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/win32/Win32FsCache", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[fileInfo.length];
        TIntObjectHashMap<THashMap<String, FileAttributes>> map2 = this.getMap();
        THashMap nestedMap = (THashMap)map2.get(parentId = ((VirtualFileWithId)file2).getId());
        if (nestedMap == null) {
            nestedMap = new THashMap(fileInfo.length, FileUtil.PATH_HASHING_STRATEGY);
            map2.put(parentId, (Object)nestedMap);
        }
        for (FileInfo info : fileInfo) {
            String name2 = info.getName();
            nestedMap.put((Object)name2, (Object)info.toFileAttributes());
            names[i] = name2;
        }
        if (names == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/win32/Win32FsCache", "list"));
        }
        return names;
    }

    @Nullable
    FileAttributes getAttributes(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/win32/Win32FsCache", "getAttributes"));
        }
        VirtualFile parent = file2.getParent();
        int parentId = parent instanceof VirtualFileWithId ? ((VirtualFileWithId)parent).getId() : -((VirtualFileWithId)file2).getId();
        TIntObjectHashMap<THashMap<String, FileAttributes>> map2 = this.getMap();
        IncompleteChildrenMap nestedMap = (IncompleteChildrenMap)((Object)map2.get(parentId));
        String name2 = file2.getName();
        FileAttributes fileAttributes = attributes = nestedMap != null ? (FileAttributes)nestedMap.get(name2) : null;
        if (attributes == null) {
            if (nestedMap != null && !(nestedMap instanceof IncompleteChildrenMap)) {
                return null;
            }
            FileInfo info = this.myKernel.getInfo(file2.getPath());
            if (info == null) {
                return null;
            }
            attributes = info.toFileAttributes();
            if (nestedMap == null) {
                nestedMap = new IncompleteChildrenMap(FileUtil.PATH_HASHING_STRATEGY);
                map2.put(parentId, nestedMap);
            }
            nestedMap.put(name2, attributes);
        }
        return attributes;
    }

    private static class IncompleteChildrenMap<K, V>
    extends THashMap<K, V> {
        IncompleteChildrenMap(TObjectHashingStrategy<K> strategy) {
            super(strategy);
        }
    }
}

