/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Function;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFileSystemRefreshWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private static final Logger LOG_ATTRIBUTES = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker_Attributes");
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue;
    private final List<VFileEvent> myFileEventSet;
    private volatile boolean myCancelled;
    private static final AtomicInteger myRequests = new AtomicInteger();
    private static final AtomicLong myTime = new AtomicLong();
    private static Function<VirtualFile, Boolean> ourCancellingCondition;

    public LocalFileSystemRefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refreshRoot", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "<init>"));
        }
        this.myRefreshQueue = new Queue(100);
        this.myFileEventSet = new ArrayList<VFileEvent>();
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        List<VFileEvent> list2 = this.myFileEventSet;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "getEvents"));
        }
        return list2;
    }

    public void cancel() {
        this.myCancelled = true;
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)this.myRefreshQueue.pullFirst();
        boolean rootDirty = root.isDirty();
        if (LOG.isDebugEnabled()) {
            LOG.debug("root=" + root + " dirty=" + rootDirty);
        }
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes((VirtualFile)root);
        if (rootAttributes == null) {
            this.myFileEventSet.add(LocalFileSystemRefreshWorker.createDeletionEvent((VirtualFile)root));
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        this.myRefreshQueue.addLast((Object)root);
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(NewVirtualFileSystem fs, PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            NewVirtualFile file2 = (NewVirtualFile)this.myRefreshQueue.pullFirst();
            boolean fileDirty = file2.isDirty();
            if (LOG.isTraceEnabled()) {
                LOG.trace("file=" + file2 + " dirty=" + fileDirty);
            }
            if (!fileDirty) continue;
            this.checkCancelled(file2);
            if (file2.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                } else {
                    this.partialDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                }
            } else {
                this.refreshFile(fs, persistence, (TObjectHashingStrategy<String>)strategy, file2);
            }
            if (!this.myIsRecursive && file2.isDirectory()) continue;
            file2.markClean();
        }
    }

    private void refreshFile(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, NewVirtualFile file2) {
        RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)file2, persistence, fs, null, Collections.singletonList(file2), strategy);
        refreshingFileVisitor.visit((VirtualFile)file2);
        this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            Object[] children2;
            Object[] currentNames;
            Application application = ApplicationManager.getApplication();
            AccessToken token = application.acquireReadActionLock();
            try {
                if (application.isDisposed()) {
                    return;
                }
                currentNames = persistence.list((VirtualFile)dir);
                children2 = dir.getChildren();
            }
            finally {
                token.finish();
            }
            RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, null, Arrays.asList(children2), strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
            token = application.acquireReadActionLock();
            try {
                if (application.isDisposed()) {
                    return;
                }
                if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children2, dir.getChildren())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            List<String> wanted;
            Collection cached;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                cached = dir.getCachedChildren();
                wanted = dir.getSuspiciousNames();
            }
            finally {
                token.finish();
            }
            if (cached.size() == 0 && wanted.size() == 0) {
                return;
            }
            RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, wanted, cached, strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("retry: " + (Object)((Object)dir));
                    continue;
                }
                this.myFileEventSet.addAll(refreshingFileVisitor.getEventSet());
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "checkCancelled"));
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            LocalFileSystemRefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)this.myRefreshQueue.pullFirst();
                LocalFileSystemRefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    public static void setCancellingCondition(@Nullable Function<VirtualFile, Boolean> condition2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourCancellingCondition = condition2;
    }

    static VFileEvent createAttributeChangeEvent(@NotNull VirtualFile file2, @NotNull String property, Object current, Object upToDate) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "createAttributeChangeEvent"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "createAttributeChangeEvent"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("update '" + property + "' file=" + file2);
        }
        return new VFilePropertyChangeEvent(null, file2, property, current, upToDate, true);
    }

    static VFileEvent createUpdateContentEvent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "createUpdateContentEvent"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + file2);
        }
        return new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true);
    }

    static VFileEvent createCreationEvent(@NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isReCreation) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "createCreationEvent"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker", "createCreationEvent"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + parent + " name=" + childName + " dir=" + isDirectory);
        }
        return new VFileCreateEvent(null, parent, childName, isDirectory, true, isReCreation);
    }

    static VFileEvent createDeletionEvent(@Nullable VirtualFile file2) {
        if (file2 != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("delete file=" + file2);
            }
            return new VFileDeleteEvent(null, file2, true);
        }
        return null;
    }

    private class RefreshingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<VFileEvent> myFileEvents = new ArrayList<VFileEvent>();
        private final Map<String, VirtualFile> myPersistentChildren;
        private final Set<String> myChildrenWeAreInterested;
        private final VirtualFile myFileOrDir;
        private final PersistentFS myPersistence;
        private final NewVirtualFileSystem myFs;

        public RefreshingFileVisitor(VirtualFile fileOrDir, PersistentFS persistence, NewVirtualFileSystem fs, Collection<String> persistentChildrenToRefresh, Collection<VirtualFile> existingPersistentChildren, TObjectHashingStrategy<String> strategy) {
            this.myFileOrDir = fileOrDir;
            this.myPersistence = persistence;
            this.myFs = fs;
            this.myPersistentChildren = new THashMap(existingPersistentChildren.size(), strategy);
            this.myChildrenWeAreInterested = persistentChildrenToRefresh != null ? new THashSet(persistentChildrenToRefresh, strategy) : null;
            for (VirtualFile child : existingPersistentChildren) {
                String name2 = child.getName();
                this.myPersistentChildren.put(name2, child);
                if (this.myChildrenWeAreInterested == null) continue;
                this.myChildrenWeAreInterested.add(name2);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
            String name2 = file2.getName(file2.getNameCount() - 1).toString();
            if (this.acceptsFileName(name2)) {
                boolean upToDateHidden;
                boolean currentHidden;
                boolean isWritable;
                NewVirtualFile child = (NewVirtualFile)this.myPersistentChildren.remove(name2);
                if (child == null) {
                    VFileEvent event = LocalFileSystemRefreshWorker.createCreationEvent(this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent(), name2, attrs.isDirectory(), false);
                    this.myFileEvents.add(event);
                    return FileVisitResult.CONTINUE;
                }
                LocalFileSystemRefreshWorker.this.checkCancelled(child);
                boolean currentIsDirectory = child.isDirectory();
                boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
                boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
                if (currentIsDirectory != attrs.isDirectory() || currentIsSymlink != attrs.isSymbolicLink() || currentIsSpecial != attrs.isOther()) {
                    this.myFileEvents.add(LocalFileSystemRefreshWorker.createDeletionEvent((VirtualFile)child));
                    VFileEvent event = LocalFileSystemRefreshWorker.createCreationEvent(this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent(), child.getName(), attrs.isDirectory(), true);
                    this.myFileEvents.add(event);
                    child.markClean();
                    return FileVisitResult.CONTINUE;
                }
                String currentName = child.getName();
                if (!currentName.equals(name2)) {
                    this.myFileEvents.add(LocalFileSystemRefreshWorker.createAttributeChangeEvent((VirtualFile)child, "name", currentName, name2));
                }
                if (!attrs.isDirectory()) {
                    if (this.myPersistence.getTimeStamp((VirtualFile)child) != attrs.lastModifiedTime().toMillis() || this.myPersistence.getLastRecordedLength((VirtualFile)child) != attrs.size()) {
                        this.myFileEvents.add(LocalFileSystemRefreshWorker.createUpdateContentEvent((VirtualFile)child));
                        child.markClean();
                        return FileVisitResult.CONTINUE;
                    }
                } else if (LocalFileSystemRefreshWorker.this.myIsRecursive) {
                    LocalFileSystemRefreshWorker.this.myRefreshQueue.addLast((Object)child);
                }
                boolean currentWritable = this.myPersistence.isWritable((VirtualFile)child);
                if (attrs instanceof DosFileAttributes) {
                    DosFileAttributes dosFileAttributes = (DosFileAttributes)attrs;
                    isWritable = attrs.isDirectory() || !dosFileAttributes.isReadOnly();
                } else {
                    isWritable = attrs instanceof PosixFileAttributes ? ((PosixFileAttributes)attrs).permissions().contains((Object)PosixFilePermission.OWNER_WRITE) : file2.toFile().canWrite();
                }
                if (LOG_ATTRIBUTES.isDebugEnabled()) {
                    LOG_ATTRIBUTES.debug("file=" + file2 + " writable vfs=" + child.isWritable() + " persistence=" + currentWritable + " real=" + isWritable);
                }
                if (currentWritable != isWritable) {
                    this.myFileEvents.add(LocalFileSystemRefreshWorker.createAttributeChangeEvent((VirtualFile)child, "writable", currentWritable, isWritable));
                }
                if (attrs instanceof DosFileAttributes && (currentHidden = child.is(VFileProperty.HIDDEN)) != (upToDateHidden = ((DosFileAttributes)attrs).isHidden())) {
                    this.myFileEvents.add(LocalFileSystemRefreshWorker.createAttributeChangeEvent((VirtualFile)child, VirtualFile.PROP_HIDDEN, currentHidden, upToDateHidden));
                }
                if (attrs.isSymbolicLink()) {
                    String upToDateVfsTarget;
                    String currentTarget = child.getCanonicalPath();
                    String upToDateTarget = this.myFs.resolveSymLink((VirtualFile)child);
                    String string = upToDateVfsTarget = upToDateTarget != null ? FileUtil.toSystemIndependentName((String)upToDateTarget) : null;
                    if (!Comparing.equal((String)currentTarget, (String)upToDateVfsTarget)) {
                        this.myFileEvents.add(LocalFileSystemRefreshWorker.createAttributeChangeEvent((VirtualFile)child, "symlink", currentTarget, upToDateVfsTarget));
                    }
                }
                if (!child.isDirectory()) {
                    child.markClean();
                }
            }
            return FileVisitResult.CONTINUE;
        }

        protected boolean acceptsFileName(String name2) {
            return !VfsUtil.isBadName((String)name2) && (this.myChildrenWeAreInterested == null || this.myChildrenWeAreInterested.contains(name2));
        }

        public void visit(VirtualFile fileOrDir) {
            long started = System.nanoTime();
            try {
                Path path = Paths.get(fileOrDir.getPath(), new String[0]);
                if (fileOrDir.isDirectory()) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, this);
                } else {
                    this.visitFile(path, Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
                }
            }
            catch (AccessDeniedException ignore) {
                boolean bl = true;
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex);
            }
            int requests = myRequests.incrementAndGet();
            long l = myTime.addAndGet(System.nanoTime() - started);
            if (requests % 1000 == 0) {
                System.out.println("refresh:" + myRequests + " for " + l / 1000000L);
            }
        }

        public List<VFileEvent> getEventSet() {
            if (this.myPersistentChildren.size() > 0) {
                for (VirtualFile child : this.myPersistentChildren.values()) {
                    this.myFileEvents.add(LocalFileSystemRefreshWorker.createDeletionEvent(child));
                }
                this.myPersistentChildren.clear();
            }
            return this.myFileEvents;
        }
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

