/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.FrameStateManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.MaximizeActiveDialogAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.FrameEditorComponentProvider;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ActiveStack;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.SideStack;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowedDecorator;
import com.intellij.openapi.wm.impl.commands.ApplyWindowInfoCmd;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.commands.InvokeLaterCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInEditorComponentCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd;
import com.intellij.openapi.wm.impl.commands.UpdateRootPaneCmd;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ToolWindowManager", defaultStateAsResource=true, storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
public final class ToolWindowManagerImpl
extends ToolWindowManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
    private final Project myProject;
    private final WindowManagerEx myWindowManager;
    private final EventDispatcher<ToolWindowManagerListener> myDispatcher = EventDispatcher.create(ToolWindowManagerListener.class);
    private final DesktopLayout myLayout = new DesktopLayout();
    private final Map<String, InternalDecorator> myId2InternalDecorator = new HashMap();
    private final Map<String, FloatingDecorator> myId2FloatingDecorator = new HashMap();
    private final Map<String, WindowedDecorator> myId2WindowedDecorator = new HashMap();
    private final Map<String, StripeButton> myId2StripeButton = new HashMap();
    private final Map<String, FocusWatcher> myId2FocusWatcher = new HashMap();
    private final EditorComponentFocusWatcher myEditorComponentFocusWatcher = new EditorComponentFocusWatcher();
    private final MyToolWindowPropertyChangeListener myToolWindowPropertyChangeListener = new MyToolWindowPropertyChangeListener();
    private final InternalDecoratorListener myInternalDecoratorListener = new MyInternalDecoratorListener();
    private boolean myEditorWasActive;
    private final ActiveStack myActiveStack = new ActiveStack();
    private final SideStack mySideStack = new SideStack();
    private ToolWindowsPane myToolWindowsPane;
    private IdeFrameImpl myFrame;
    private DesktopLayout myLayoutToRestoreLater;
    @NonNls
    private static final String EDITOR_ELEMENT = "editor";
    @NonNls
    private static final String ACTIVE_ATTR_VALUE = "active";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    @NonNls
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";
    private final Map<String, Balloon> myWindow2Balloon = new HashMap();
    private KeyState myCurrentState = KeyState.waiting;
    private final Alarm myWaiterForSecondPress = new Alarm();
    private final Runnable mySecondPressRunnable = () -> {
        if (this.myCurrentState != KeyState.hold) {
            this.resetHoldState();
        }
    };
    private final Alarm myUpdateHeadersAlarm = new Alarm();
    private final CommandProcessor myCommandProcessor = new CommandProcessor();

    boolean isToolWindowRegistered(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToolWindowRegistered"));
        }
        return this.myLayout.isToolWindowRegistered(id);
    }

    public ToolWindowManagerImpl(Project project2, WindowManagerEx windowManagerEx, ActionManager actionManager) {
        this.myProject = project2;
        this.myWindowManager = windowManagerEx;
        if (project2.isDefault()) {
            return;
        }
        actionManager.addAnActionListener((action, dataContext, event) -> {
            if (this.myCurrentState != KeyState.hold) {
                this.resetHoldState();
            }
        }, (Disposable)project2);
        MessageBusConnection busConnection = project2.getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                if (project2 == ToolWindowManagerImpl.this.myProject) {
                    ToolWindowManagerImpl.this.init();
                }
            }

            public void projectClosed(Project project2) {
                if (project2 == ToolWindowManagerImpl.this.myProject) {
                    ToolWindowManagerImpl.this.projectClosed();
                }
            }
        });
        this.myLayout.copyFrom(windowManagerEx.getLayout());
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$2", "fileClosed"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$2", "fileClosed"));
                }
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                    public void run() {
                        if (!ToolWindowManagerImpl.this.hasOpenEditorFiles()) {
                            ToolWindowManagerImpl.this.focusToolWindowByDefault(null);
                        }
                    }
                });
            }
        });
        PropertyChangeListener focusListener = it -> {
            if ("focusOwner".equals(it.getPropertyName())) {
                this.myUpdateHeadersAlarm.cancelAllRequests();
                this.myUpdateHeadersAlarm.addRequest(this::updateToolWindowHeaders, 50);
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(focusListener);
        Disposer.register((Disposable)this, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(focusListener));
    }

    private void updateToolWindowHeaders() {
        this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                WindowInfoImpl[] infos;
                for (WindowInfoImpl each : infos = ToolWindowManagerImpl.this.myLayout.getInfos()) {
                    InternalDecorator decorator;
                    ToolWindow tw;
                    if (!each.isVisible() || !((tw = ToolWindowManagerImpl.this.getToolWindow(each.getId())) instanceof ToolWindowImpl) || (decorator = ((ToolWindowImpl)tw).getDecorator()) == null) continue;
                    decorator.repaint();
                }
            }
        });
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "dispatchKeyEvent"));
        }
        if (e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 157) {
            if (e.getModifiers() == 0) {
                this.resetHoldState();
            }
            return false;
        }
        if (e.getID() != 401 && e.getID() != 402) {
            return false;
        }
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        if (parent instanceof IdeFrame && ((IdeFrame)parent).getProject() != this.myProject) {
            this.resetHoldState();
            return false;
        }
        Set<Integer> vks = ToolWindowManagerImpl.getActivateToolWindowVKs();
        if (vks.isEmpty()) {
            this.resetHoldState();
            return false;
        }
        if (vks.contains(e.getKeyCode())) {
            boolean pressed = e.getID() == 401;
            int modifiers = e.getModifiers();
            int mouseMask = 7168;
            if ((e.getModifiersEx() & mouseMask) == 0) {
                if (ToolWindowManagerImpl.areAllModifiersPressed(modifiers, vks) || !pressed) {
                    this.processState(pressed);
                } else {
                    this.resetHoldState();
                }
            }
        }
        return false;
    }

    private static boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, Set<Integer> modifierCodes) {
        int mask = 0;
        for (Integer each : modifierCodes) {
            if (each == 16) {
                mask |= 1;
            }
            if (each == 17) {
                mask |= 2;
            }
            if (each == 157) {
                mask |= 4;
            }
            if (each != 18) continue;
            mask |= 8;
        }
        return (modifiers ^ mask) == 0;
    }

    @NotNull
    private static Set<Integer> getActivateToolWindowVKs() {
        KeyStroke keyStroke;
        Shortcut each;
        if (ApplicationManager.getApplication() == null) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getActivateToolWindowVKs"));
            }
            return hashSet;
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] baseShortcut = keymap.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        Shortcut[] shortcutArray = baseShortcut;
        int n = shortcutArray.length;
        for (int i = 0; !(i >= n || (each = shortcutArray[i]) instanceof KeyboardShortcut && (baseModifiers = (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()).getModifiers()) > 0); ++i) {
        }
        Set<Integer> set2 = ToolWindowManagerImpl.getModifiersVKs(baseModifiers);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getActivateToolWindowVKs"));
        }
        return set2;
    }

    @NotNull
    private static Set<Integer> getModifiersVKs(int mask) {
        THashSet codes = new THashSet();
        if ((mask & 1) > 0) {
            codes.add(16);
        }
        if ((mask & 2) > 0) {
            codes.add(17);
        }
        if ((mask & 4) > 0) {
            codes.add(157);
        }
        if ((mask & 8) > 0) {
            codes.add(18);
        }
        THashSet tHashSet = codes;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getModifiersVKs"));
        }
        return tHashSet;
    }

    private void resetHoldState() {
        this.myCurrentState = KeyState.waiting;
        this.processHoldState();
    }

    private void processState(boolean pressed) {
        if (pressed) {
            if (this.myCurrentState == KeyState.waiting) {
                this.myCurrentState = KeyState.pressed;
            } else if (this.myCurrentState == KeyState.released) {
                this.myCurrentState = KeyState.hold;
                this.processHoldState();
            }
        } else if (this.myCurrentState == KeyState.pressed) {
            this.myCurrentState = KeyState.released;
            this.restartWaitingForSecondPressAlarm();
        } else {
            this.resetHoldState();
        }
    }

    private void processHoldState() {
        if (this.myToolWindowsPane != null) {
            this.myToolWindowsPane.setStripesOverlayed(this.myCurrentState == KeyState.hold);
        }
    }

    private void restartWaitingForSecondPressAlarm() {
        this.myWaiterForSecondPress.cancelAllRequests();
        this.myWaiterForSecondPress.addRequest(this.mySecondPressRunnable, Registry.intValue((String)"actionSystem.keyGestureDblClickTime"));
    }

    private boolean hasOpenEditorFiles() {
        return FileEditorManager.getInstance((Project)this.myProject).getOpenFiles().length > 0;
    }

    private static IdeFocusManager getFocusManagerImpl(Project project2) {
        return IdeFocusManager.getInstance((Project)project2);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getProject"));
        }
        return project2;
    }

    public void dispose() {
        for (String id : new ArrayList<String>(this.myId2StripeButton.keySet())) {
            this.unregisterToolWindow(id);
        }
        assert (this.myId2StripeButton.isEmpty());
    }

    public void init() {
        MyUIManagerPropertyChangeListener uiManagerPropertyListener = new MyUIManagerPropertyChangeListener();
        MyLafManagerListener lafManagerListener = new MyLafManagerListener();
        UIManager.addPropertyChangeListener(uiManagerPropertyListener);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)lafManagerListener);
        Disposer.register((Disposable)this, () -> {
            UIManager.removePropertyChangeListener(uiManagerPropertyListener);
            LafManager.getInstance().removeLafManagerListener((LafManagerListener)lafManagerListener);
        });
        this.myFrame = this.myWindowManager.allocateFrame(this.myProject);
        LOG.assertTrue(this.myFrame != null);
        this.myToolWindowsPane = new ToolWindowsPane(this.myFrame, this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myToolWindowsPane);
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(this.myToolWindowsPane);
        this.myFrame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(this.myProject));
        ((IdeRootPane)this.myFrame.getRootPane()).updateToolbar();
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof KeyEvent) {
                this.dispatchKeyEvent((KeyEvent)e);
            }
            if (e instanceof WindowEvent && e.getID() == 208 && e.getSource() == this.myFrame) {
                this.resetHoldState();
            }
            return false;
        }, (Disposable)this.myProject);
    }

    private void initAll(List<FinalizableCommand> commandsList) {
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        JComponent editorComponent = ToolWindowManagerImpl.createEditorComponent(this.myProject);
        this.myEditorComponentFocusWatcher.install(editorComponent);
        this.appendSetEditorComponentCmd(editorComponent, commandsList);
        if (this.myEditorWasActive && editorComponent instanceof EditorsSplitters) {
            this.activateEditorComponentImpl(commandsList, true);
        }
    }

    private static JComponent createEditorComponent(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "createEditorComponent"));
        }
        return ((FrameEditorComponentProvider[])FrameEditorComponentProvider.EP.getExtensions())[0].createEditorComponent(project2);
    }

    private void registerToolWindowsFromBeans(List<FinalizableCommand> list2) {
        List<Object> beans = Arrays.asList(Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME));
        for (final ToolWindowEP toolWindowEP : beans) {
            Condition condition2 = toolWindowEP.getCondition();
            if (condition2 != null && !condition2.value((Object)this.myProject)) continue;
            list2.add(new FinalizableCommand(EmptyRunnable.INSTANCE){

                @Override
                public void run() {
                    ToolWindowManagerImpl.this.initToolWindow(toolWindowEP);
                }
            });
        }
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        WindowInfoImpl info;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "initToolWindow"));
        }
        WindowInfoImpl before = this.myLayout.getInfo(bean.id, false);
        boolean visible = before != null && before.isVisible();
        JLabel label = ToolWindowManagerImpl.createInitializingLabel();
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.fromText((String)bean.anchor);
        ToolWindowFactory factory = bean.getToolWindowFactory();
        ToolWindow window = this.registerToolWindow(bean.id, label, toolWindowAnchor, false, bean.canCloseContents, DumbService.isDumbAware((Object)factory), factory.shouldBeAvailable(this.myProject));
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.registerDisposable(bean.id, (Disposable)this.myProject, window);
        toolWindow.setContentFactory(factory);
        if (bean.icon != null && toolWindow.getIcon() == null) {
            Icon icon = IconLoader.findIcon((String)bean.icon, factory.getClass());
            if (icon == null) {
                try {
                    icon = IconLoader.getIcon((String)bean.icon);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            toolWindow.setIcon(icon);
        }
        if (!(info = this.getInfo(bean.id)).isSplit() && bean.secondary && !info.wasRead()) {
            toolWindow.setSplitMode(true, null);
        }
        toolWindow.setActivation(new ActionCallback()).setDone();
        DumbAwareRunnable runnable2 = () -> {
            if (toolWindow.isDisposed()) {
                return;
            }
            toolWindow.ensureContentInitialized();
        };
        if (visible) {
            runnable2.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)label, () -> ApplicationManager.getApplication().invokeLater((Runnable)runnable2));
        }
    }

    @NotNull
    private static JLabel createInitializingLabel() {
        JLabel label = new JLabel("Initializing...", 0);
        label.setOpaque(true);
        Color treeBg = UIManager.getColor("Tree.background");
        label.setBackground(ColorUtil.toAlpha((Color)treeBg, (int)180));
        Color treeFg = UIUtil.getTreeForeground();
        label.setForeground(ColorUtil.toAlpha((Color)treeFg, (int)180));
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "createInitializingLabel"));
        }
        return jLabel;
    }

    public void projectClosed() {
        if (this.myFrame == null) {
            return;
        }
        String[] ids = this.getToolWindowIds();
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(null);
        this.myWindowManager.releaseFrame(this.myFrame);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        for (String id : ids) {
            this.deactivateToolWindowImpl(id, true, commandsList);
        }
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(this.myProject).getComponent();
        this.myEditorComponentFocusWatcher.deinstall(editorComponent);
        this.appendSetEditorComponentCmd(null, commandsList);
        this.execute(commandsList);
        this.myFrame = null;
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "removeToolWindowManagerListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void execute(@NotNull List<FinalizableCommand> commandList) {
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "execute"));
        }
        for (FinalizableCommand each : commandList) {
            if (!each.willChangeState()) continue;
            this.fireStateChanged();
            break;
        }
        for (FinalizableCommand each : commandList) {
            each.beforeExecute(this);
        }
        this.myCommandProcessor.execute(commandList, this.myProject.getDisposed());
    }

    private void flushCommands() {
        this.myCommandProcessor.flush();
    }

    public void activateEditorComponent() {
        this.activateEditorComponent(true);
    }

    private void activateEditorComponent(boolean forced) {
        this.activateEditorComponent(forced, false);
    }

    private void activateEditorComponent(final boolean forced, boolean now) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateEditorComponent()");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ExpirableRunnable.ForProject runnable2 = new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
                ToolWindowManagerImpl.this.activateEditorComponentImpl(commandList, forced);
                ToolWindowManagerImpl.this.execute(commandList);
            }
        };
        if (now) {
            if (!runnable2.isExpired()) {
                runnable2.run();
            }
        } else {
            final FocusRequestor requestor = this.getFocusManager().getFurtherRequestor();
            this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject, (ExpirableRunnable)runnable2, forced){
                final /* synthetic */ ExpirableRunnable val$runnable;
                final /* synthetic */ boolean val$forced;
                {
                    this.val$runnable = expirableRunnable;
                    this.val$forced = bl;
                    super(arg0);
                }

                public void run() {
                    requestor.requestFocus(new FocusCommand(){

                        @NotNull
                        public ActionCallback run() {
                            val$runnable.run();
                            ActionCallback actionCallback = ActionCallback.DONE;
                            if (actionCallback == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$6$1", "run"));
                            }
                            return actionCallback;
                        }
                    }.setExpirable((Expirable)this.val$runnable), this.val$forced);
                }
            });
        }
    }

    private void activateEditorComponentImpl(@NotNull List<FinalizableCommand> commandList, boolean forced) {
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "activateEditorComponentImpl"));
        }
        final String active = this.getActiveToolWindowId();
        this.appendRequestFocusInEditorComponentCmd(commandList, forced).doWhenDone(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("editor activated");
            }
            ArrayList<FinalizableCommand> commandList12 = new ArrayList<FinalizableCommand>();
            this.deactivateWindows(null, commandList12);
            this.myActiveStack.clear();
            this.execute(commandList12);
        }).doWhenRejected(() -> {
            if (forced) {
                ToolWindowManagerImpl.getFocusManagerImpl(this.myProject).requestFocus(new FocusCommand(){

                    @NotNull
                    public ActionCallback run() {
                        ArrayList<FinalizableCommand> commandList1 = new ArrayList<FinalizableCommand>();
                        WindowInfoImpl toReactivate = active == null ? null : ToolWindowManagerImpl.this.getInfo(active);
                        boolean reactivateLastActive = toReactivate != null && !ToolWindowManagerImpl.isToHideOnDeactivation(toReactivate);
                        ToolWindowManagerImpl.this.deactivateWindows(reactivateLastActive ? active : null, commandList1);
                        ToolWindowManagerImpl.this.execute(commandList1);
                        if (reactivateLastActive) {
                            ToolWindowManagerImpl.this.activateToolWindow(active, false, true);
                        } else {
                            if (active != null) {
                                ToolWindowManagerImpl.this.myActiveStack.remove(active, false);
                            }
                            if (!ToolWindowManagerImpl.this.myActiveStack.isEmpty()) {
                                ToolWindowManagerImpl.this.activateToolWindow(ToolWindowManagerImpl.this.myActiveStack.peek(), false, true);
                            }
                        }
                        ActionCallback actionCallback = ActionCallback.DONE;
                        if (actionCallback == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$7", "run"));
                        }
                        return actionCallback;
                    }
                }, false);
            }
        });
    }

    private void deactivateWindows(@Nullable String idToIgnore, @NotNull List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "deactivateWindows"));
        }
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            if (idToIgnore != null && idToIgnore.equals(info.getId())) continue;
            this.deactivateToolWindowImpl(info.getId(), ToolWindowManagerImpl.isToHideOnDeactivation(info), commandList);
        }
    }

    private static boolean isToHideOnDeactivation(@NotNull WindowInfoImpl info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToHideOnDeactivation"));
        }
        if (info.isFloating() || info.isWindowed()) {
            return false;
        }
        return info.isAutoHide() || info.isSliding();
    }

    private void showAndActivate(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList, boolean autoFocusContents, boolean forcedFocusRequest) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "showAndActivate"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "showAndActivate"));
        }
        if (!this.getToolWindow(id).isAvailable()) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        boolean toApplyInfo = false;
        if (!info.isActive()) {
            info.setActive(true);
            toApplyInfo = true;
        }
        this.showToolWindowImpl(id, dirtyMode, commandsList);
        if (toApplyInfo) {
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.myActiveStack.push(id);
        }
        if (autoFocusContents && ApplicationManager.getApplication().isActive()) {
            this.appendRequestFocusInToolWindowCmd(id, commandsList, forcedFocusRequest);
        }
    }

    void activateToolWindow(@NotNull String id, boolean forced, boolean autoFocusContents) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "activateToolWindow"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateToolWindowImpl(id, commandList, forced, autoFocusContents);
        this.execute(commandList);
    }

    private void activateToolWindowImpl(@NotNull String id, @NotNull List<FinalizableCommand> commandList, boolean forced, boolean autoFocusContents) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "activateToolWindowImpl"));
        }
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "activateToolWindowImpl"));
        }
        autoFocusContents &= forced || FocusManagerImpl.getInstance().isUnforcedRequestAllowed();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindowImpl(" + id + ")");
        }
        if (!this.getToolWindow(id).isAvailable()) {
            InternalDecorator decorator = this.getInternalDecorator(id);
            if (!decorator.hasFocus() && autoFocusContents) {
                this.appendRequestFocusInToolWindowCmd(id, commandList, forced);
            }
            return;
        }
        this.deactivateWindows(id, commandList);
        this.showAndActivate(id, false, commandList, autoFocusContents, forced);
    }

    private void checkId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "checkId"));
        }
        if (!this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalStateException("window with id=\"" + id + "\" isn't registered");
        }
    }

    private void deactivateToolWindowImpl(@NotNull String id, boolean shouldHide, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "deactivateToolWindowImpl"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "deactivateToolWindowImpl"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: deactivateToolWindowImpl(" + id + "," + shouldHide + ")");
        }
        WindowInfoImpl info = this.getInfo(id);
        if (shouldHide && info.isVisible()) {
            this.applyInfo(id, info, commandsList);
        }
        info.setActive(false);
        this.appendApplyWindowInfoCmd(info, commandsList);
    }

    @NotNull
    public String[] getToolWindowIds() {
        WindowInfoImpl[] infos = this.myLayout.getInfos();
        String[] ids = ArrayUtil.newStringArray((int)infos.length);
        for (int i = 0; i < infos.length; ++i) {
            ids[i] = infos[i].getId();
        }
        if (ids == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowIds"));
        }
        return ids;
    }

    public String getActiveToolWindowId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout.getActiveId();
    }

    @Override
    public String getLastActiveToolWindowId() {
        return this.getLastActiveToolWindowId(null);
    }

    @Override
    @Nullable
    public String getLastActiveToolWindowId(@Nullable Condition<JComponent> condition2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String lastActiveToolWindowId = null;
        for (int i = 0; i < this.myActiveStack.getPersistentSize(); ++i) {
            String id = this.myActiveStack.peekPersistent(i);
            ToolWindow toolWindow = this.getToolWindow(id);
            LOG.assertTrue(toolWindow != null);
            if (!toolWindow.isAvailable() || condition2 != null && !condition2.value((Object)toolWindow.getComponent())) continue;
            lastActiveToolWindowId = id;
            break;
        }
        return lastActiveToolWindowId;
    }

    private FloatingDecorator getFloatingDecorator(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getFloatingDecorator"));
        }
        return this.myId2FloatingDecorator.get(id);
    }

    private WindowedDecorator getWindowedDecorator(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getWindowedDecorator"));
        }
        return this.myId2WindowedDecorator.get(id);
    }

    private InternalDecorator getInternalDecorator(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getInternalDecorator"));
        }
        return this.myId2InternalDecorator.get(id);
    }

    StripeButton getStripeButton(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getStripeButton"));
        }
        return this.myId2StripeButton.get(id);
    }

    private WindowInfoImpl getInfo(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getInfo"));
        }
        return this.myLayout.getInfo(id, true);
    }

    @Override
    @NotNull
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getIdsOn"));
        }
        List<String> list2 = this.myLayout.getVisibleIdsOn(anchor, this);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getIdsOn"));
        }
        return list2;
    }

    @Nullable
    public ToolWindow getToolWindow(String id) {
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return null;
        }
        InternalDecorator decorator = this.getInternalDecorator(id);
        return decorator != null ? decorator.getToolWindow() : null;
    }

    void showToolWindow(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "showToolWindow"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: showToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.showToolWindowImpl(id, false, commandList);
        this.execute(commandList);
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "hideToolWindow"));
        }
        this.hideToolWindow(id, hideSide, true);
    }

    public void hideToolWindow(@NotNull String id, boolean hideSide, boolean moveFocus) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "hideToolWindow"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (!info.isVisible()) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        boolean wasActive = info.isActive();
        this.deactivateToolWindowImpl(id, true, commandList);
        if (hideSide && !info.isFloating() && !info.isWindowed()) {
            String[] all;
            List<String> ids = this.myLayout.getVisibleIdsOn(info.getAnchor(), this);
            for (String string : ids) {
                this.myActiveStack.remove(string, true);
            }
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                this.mySideStack.pop(info.getAnchor());
            }
            for (String eachId : all = this.getToolWindowIds()) {
                WindowInfoImpl eachInfo = this.getInfo(eachId);
                if (!eachInfo.isVisible() || eachInfo.getAnchor() != info.getAnchor()) continue;
                this.deactivateToolWindowImpl(eachId, true, commandList);
            }
            this.activateEditorComponentImpl(commandList, true);
        } else if (ToolWindowManagerImpl.isStackEnabled()) {
            WindowInfoImpl info2 = null;
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                WindowInfoImpl storedInfo = this.mySideStack.pop(info.getAnchor());
                if (storedInfo.isSplit() != info.isSplit()) continue;
                WindowInfoImpl windowInfoImpl = this.getInfo(storedInfo.getId());
                LOG.assertTrue(windowInfoImpl != null);
                if (storedInfo.getAnchor() != windowInfoImpl.getAnchor() || storedInfo.getType() != windowInfoImpl.getType() || storedInfo.isAutoHide() != windowInfoImpl.isAutoHide()) continue;
                info2 = storedInfo;
                break;
            }
            if (info2 != null) {
                this.showToolWindowImpl(info2.getId(), false, commandList);
            }
            this.myActiveStack.remove(id, false);
            if (wasActive && moveFocus) {
                if (this.myActiveStack.isEmpty()) {
                    if (this.hasOpenEditorFiles()) {
                        this.activateEditorComponentImpl(commandList, false);
                    } else {
                        this.focusToolWindowByDefault(id);
                    }
                } else {
                    String toBeActivatedId = this.myActiveStack.pop();
                    if (this.getInfo(toBeActivatedId).isVisible() || ToolWindowManagerImpl.isStackEnabled()) {
                        this.activateToolWindowImpl(toBeActivatedId, commandList, false, true);
                    } else {
                        this.focusToolWindowByDefault(id);
                    }
                }
            }
        }
        this.execute(commandList);
    }

    private static boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private void showToolWindowImpl(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "showToolWindowImpl"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "showToolWindowImpl"));
        }
        WindowInfoImpl toBeShownInfo = this.getInfo(id);
        ToolWindow window = this.getToolWindow(id);
        if (window != null && toBeShownInfo.isWindowed()) {
            UIUtil.toFront((Window)UIUtil.getWindow((Component)window.getComponent()));
        }
        if (toBeShownInfo.isVisible() || window == null || !window.isAvailable()) {
            return;
        }
        toBeShownInfo.setVisible(true);
        InternalDecorator decorator = this.getInternalDecorator(id);
        if (toBeShownInfo.isFloating()) {
            commandsList.add(new AddFloatingDecoratorCmd(decorator, toBeShownInfo));
        } else if (toBeShownInfo.isWindowed()) {
            commandsList.add(new AddWindowedDecoratorCmd(decorator, toBeShownInfo));
        } else {
            WindowInfoImpl[] infos;
            for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
                if (id.equals(info.getId()) || !info.isVisible() || info.getType() != toBeShownInfo.getType() || info.getAnchor() != toBeShownInfo.getAnchor() || info.isSplit() != toBeShownInfo.isSplit()) continue;
                info.setVisible(false);
                this.appendRemoveDecoratorCmd(info.getId(), false, commandsList);
                if (info.isActive()) {
                    info.setActive(false);
                }
                this.appendApplyWindowInfoCmd(info, commandsList);
                if (!info.isDocked() || info.isAutoHide()) continue;
                this.mySideStack.push(info);
            }
            this.appendAddDecoratorCmd(decorator, toBeShownInfo, dirtyMode, commandsList);
            this.mySideStack.remove(id);
        }
        if (!toBeShownInfo.isShowStripeButton()) {
            toBeShownInfo.setShowStripeButton(true);
        }
        this.appendApplyWindowInfoCmd(toBeShownInfo, commandsList);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, false, false, false, true);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, parentDisposable, false, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, this.registerToolWindow(id, component, anchor, false, canCloseContents, canWorkInDumbMode, true));
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor, false, canCloseContent, false, true);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor, secondary, canCloseContent, false, true);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, canCloseContent, anchor, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow window = this.registerToolWindow(id, null, anchor, secondary, canCloseContent, canWorkInDumbMode, true);
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, window);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    private ToolWindow registerToolWindow(@NotNull String id, @Nullable JComponent component, @NotNull ToolWindowAnchor anchor, boolean sideTool, boolean canCloseContent, boolean canWorkInDumbMode, boolean shouldBeAvailable) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (this.myToolWindowsPane == null) {
            this.init();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: installToolWindow(" + id + "," + component + "," + anchor + "\")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean known = this.myLayout.isToolWindowUnregistered(id);
        if (this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalArgumentException("window with id=\"" + id + "\" is already registered");
        }
        WindowInfoImpl info = this.myLayout.register(id, anchor, sideTool);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        info.setActive(false);
        info.setVisible(false);
        if (!known) {
            info.setShowStripeButton(shouldBeAvailable);
        }
        ToolWindowImpl toolWindow = new ToolWindowImpl(this, id, canCloseContent, component);
        InternalDecorator decorator = new InternalDecorator(this.myProject, info.copy(), toolWindow, canWorkInDumbMode);
        ActivateToolWindowAction.ensureToolWindowActionRegistered(toolWindow);
        this.myId2InternalDecorator.put(id, decorator);
        decorator.addInternalDecoratorListener(this.myInternalDecoratorListener);
        toolWindow.addPropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2FocusWatcher.put(id, new ToolWindowFocusWatcher(toolWindow));
        StripeButton button = new StripeButton(decorator, this.myToolWindowsPane);
        this.myId2StripeButton.put(id, button);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendAddButtonCmd(button, info, commandsList);
        if (!info.isAutoHide() && (info.isDocked() || info.isFloating())) {
            if (wasActive) {
                this.activateToolWindowImpl(info.getId(), commandsList, true, true);
            } else if (wasVisible) {
                this.showToolWindowImpl(info.getId(), false, commandsList);
            }
        } else if (wasActive) {
            this.activateEditorComponentImpl(commandsList, true);
        }
        this.execute(commandsList);
        this.fireToolWindowRegistered(id);
        ToolWindowImpl toolWindowImpl = toolWindow;
        if (toolWindowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindowImpl;
    }

    @NotNull
    private ToolWindow registerDisposable(@NotNull String id, @NotNull Disposable parentDisposable, @NotNull ToolWindow window) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        Disposer.register((Disposable)parentDisposable, () -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "lambda$registerDisposable$10"));
            }
            this.unregisterToolWindow(id);
        });
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "unregisterToolWindow"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: unregisterToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        ToolWindowEx toolWindow = (ToolWindowEx)this.getToolWindow(id);
        this.myLayout.unregister(id);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        if (info.isVisible()) {
            this.applyInfo(id, info, commandsList);
        }
        this.appendRemoveButtonCmd(id, commandsList);
        this.appendApplyWindowInfoCmd(info, commandsList);
        this.execute(commandsList);
        assert (toolWindow != null);
        toolWindow.removePropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myActiveStack.remove(id, true);
        this.mySideStack.remove(id);
        StripeButton button = this.getStripeButton(id);
        Disposer.dispose((Disposable)button);
        this.myId2StripeButton.remove(id);
        ToolWindowFocusWatcher watcher = (ToolWindowFocusWatcher)this.myId2FocusWatcher.remove(id);
        watcher.deinstall();
        InternalDecorator decorator = this.getInternalDecorator(id);
        decorator.dispose();
        decorator.removeInternalDecoratorListener(this.myInternalDecoratorListener);
        this.myId2InternalDecorator.remove(id);
    }

    private void applyInfo(@NotNull String id, WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "applyInfo"));
        }
        info.setVisible(false);
        if (info.isFloating()) {
            this.appendRemoveFloatingDecoratorCmd(info, commandsList);
        } else if (info.isWindowed()) {
            this.appendRemoveWindowedDecoratorCmd(info, commandsList);
        } else {
            this.appendRemoveDecoratorCmd(id, false, commandsList);
        }
    }

    @Override
    public DesktopLayout getLayout() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout;
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
        this.myLayoutToRestoreLater = layout;
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return this.myLayoutToRestoreLater;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        WindowInfoImpl info;
        WindowInfoImpl[] currentInfos;
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setLayout"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        for (WindowInfoImpl currentInfo : currentInfos = this.myLayout.getInfos()) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !currentInfo.isVisible() || info.isVisible()) continue;
            this.deactivateToolWindowImpl(currentInfo.getId(), true, commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getAnchor() == info.getAnchor() && currentInfo.getOrder() == info.getOrder()) continue;
            this.setToolWindowAnchorImpl(currentInfo.getId(), info.getAnchor(), info.getOrder(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getType() == info.getType()) continue;
            this.setToolWindowTypeImpl(currentInfo.getId(), info.getType(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.isAutoHide() == info.isAutoHide()) continue;
            this.setToolWindowAutoHideImpl(currentInfo.getId(), info.isAutoHide(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !info.isVisible()) continue;
            this.showToolWindowImpl(currentInfo.getId(), false, commandList);
        }
        if (!this.myEditorWasActive && this.getActiveToolWindowId() == null) {
            this.activateEditorComponentImpl(commandList, true);
        }
        this.execute(commandList);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "invokeLater"));
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        commandList.add(new InvokeLaterCmd(runnable2, this.myCommandProcessor));
        this.execute(commandList);
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (ideFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getFocusManager"));
        }
        return ideFocusManager;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "canShowNotification"));
        }
        if (!Arrays.asList(this.getToolWindowIds()).contains(toolWindowId)) {
            return false;
        }
        Stripe stripe = this.myToolWindowsPane.getStripeFor(toolWindowId);
        return stripe != null && stripe.getButtonFor(toolWindowId) != null;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type2, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlBody", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        this.notifyByBalloon(toolWindowId, type2, htmlBody, null, null);
    }

    public void notifyByBalloon(final @NotNull String toolWindowId, final @NotNull MessageType type2, final @NotNull String text2, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        Stripe stripe;
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        this.checkId(toolWindowId);
        Balloon existing = this.myWindow2Balloon.get(toolWindowId);
        if (existing != null) {
            existing.hide();
        }
        if ((stripe = this.myToolWindowsPane.getStripeFor(toolWindowId)) == null) {
            return;
        }
        ToolWindowImpl window = this.getInternalDecorator(toolWindowId).getToolWindow();
        if (!window.isAvailable()) {
            window.setPlaceholderMode(true);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
        }
        final ToolWindowAnchor anchor = this.getInfo(toolWindowId).getAnchor();
        final Ref position = Ref.create((Object)Balloon.Position.below);
        if (ToolWindowAnchor.TOP == anchor) {
            position.set((Object)Balloon.Position.below);
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            position.set((Object)Balloon.Position.above);
        } else if (ToolWindowAnchor.LEFT == anchor) {
            position.set((Object)Balloon.Position.atRight);
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            position.set((Object)Balloon.Position.atLeft);
        }
        BalloonHyperlinkListener listenerWrapper = new BalloonHyperlinkListener(listener2);
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text2.replace("\n", "<br>"), icon, type2.getPopupBackground(), (HyperlinkListener)listenerWrapper).setHideOnClickOutside(false).setHideOnFrameResize(false).createBalloon();
        FrameStateManager.getInstance().getApplicationActive().doWhenDone(() -> {
            Alarm alarm = new Alarm();
            alarm.addRequest(() -> {
                ((BalloonImpl)balloon).setHideOnClickOutside(true);
                Disposer.dispose((Disposable)alarm);
            }, 100);
        });
        listenerWrapper.myBalloon = balloon;
        this.myWindow2Balloon.put(toolWindowId, balloon);
        Disposer.register((Disposable)balloon, () -> {
            if (toolWindowId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "lambda$notifyByBalloon$13"));
            }
            window.setPlaceholderMode(false);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
            this.myWindow2Balloon.remove(toolWindowId);
        });
        Disposer.register((Disposable)this.getProject(), (Disposable)balloon);
        this.execute(new ArrayList<FinalizableCommand>(Collections.singletonList(new FinalizableCommand(null){

            @Override
            public void run() {
                StripeButton button = stripe.getButtonFor(toolWindowId);
                LOG.assertTrue(button != null, (Object)("Button was not found, popup won't be shown. Toolwindow id: " + toolWindowId + ", message: " + text2 + ", message type: " + type2));
                if (button == null) {
                    return;
                }
                Runnable show = () -> {
                    if (toolWindowId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$8", "lambda$run$0"));
                    }
                    PositionTracker<Balloon> tracker = button.isShowing() ? new PositionTracker<Balloon>((Component)button){

                        @Nullable
                        public RelativePoint recalculateLocation(Balloon object) {
                            StripeButton twButton;
                            Stripe twStripe = ToolWindowManagerImpl.this.myToolWindowsPane.getStripeFor(toolWindowId);
                            StripeButton stripeButton = twButton = twStripe != null ? twStripe.getButtonFor(toolWindowId) : null;
                            if (twButton == null) {
                                return null;
                            }
                            if (ToolWindowManagerImpl.this.getToolWindow(toolWindowId).getAnchor() != anchor) {
                                object.hide();
                                return null;
                            }
                            Point point = new Point(twButton.getBounds().width / 2, twButton.getHeight() / 2 - 2);
                            return new RelativePoint((Component)twButton, point);
                        }
                    } : new PositionTracker<Balloon>((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane)){

                        public RelativePoint recalculateLocation(Balloon object) {
                            Rectangle bounds = ToolWindowManagerImpl.this.myToolWindowsPane.getBounds();
                            Point target2 = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)new Dimension(1, 1));
                            if (ToolWindowAnchor.TOP == anchor) {
                                target2.y = 0;
                            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                                target2.y = bounds.height - 3;
                            } else if (ToolWindowAnchor.LEFT == anchor) {
                                target2.x = 0;
                            } else if (ToolWindowAnchor.RIGHT == anchor) {
                                target2.x = bounds.width;
                            }
                            return new RelativePoint((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane), target2);
                        }
                    };
                    if (!balloon.isDisposed()) {
                        balloon.show((PositionTracker)tracker, (Balloon.Position)position.get());
                    }
                };
                if (!button.isValid()) {
                    SwingUtilities.invokeLater(show);
                } else {
                    show.run();
                }
            }
        })));
    }

    public Balloon getToolWindowBalloon(String id) {
        return this.myWindow2Balloon.get(id);
    }

    public boolean isEditorComponentActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component owner2 = this.getFocusManager().getFocusOwner();
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)owner2));
        return splitters != null;
    }

    @NotNull
    ToolWindowAnchor getToolWindowAnchor(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowAnchor"));
        }
        this.checkId(id);
        ToolWindowAnchor toolWindowAnchor = this.getInfo(id).getAnchor();
        if (toolWindowAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowAnchor"));
        }
        return toolWindowAnchor;
    }

    void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchor"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setToolWindowAnchor(id, anchor, -1);
    }

    private void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor, int order) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchor"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchorImpl(id, anchor, order, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAnchorImpl(@NotNull String id, @NotNull ToolWindowAnchor anchor, int order, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchorImpl"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchorImpl"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAnchorImpl"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (anchor == info.getAnchor() && order == info.getOrder()) {
            return;
        }
        if (!info.isVisible() || anchor == info.getAnchor() || info.isFloating()) {
            WindowInfoImpl[] infos;
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
        } else {
            WindowInfoImpl[] infos;
            info.setVisible(false);
            this.appendRemoveDecoratorCmd(id, false, commandsList);
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
            this.showToolWindowImpl(id, false, commandsList);
            if (info.isActive()) {
                this.appendRequestFocusInToolWindowCmd(id, commandsList, true);
            }
        }
    }

    boolean isSplitMode(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isSplitMode"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isSplit();
    }

    @NotNull
    ToolWindowContentUiType getContentUiType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getContentUiType"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ToolWindowContentUiType toolWindowContentUiType = this.getInfo(id).getContentUiType();
        if (toolWindowContentUiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getContentUiType"));
        }
        return toolWindowContentUiType;
    }

    void setSideTool(@NotNull String id, boolean isSide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setSideTool"));
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    void setContentUiType(@NotNull String id, @NotNull ToolWindowContentUiType type2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setContentUiType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setContentUiType"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        info.setContentUiType(type2);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    void setSideToolAndAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor, int order, boolean isSide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setSideToolAndAnchor"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setSideToolAndAnchor"));
        }
        this.setToolWindowAnchor(id, anchor, order);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    private void setSplitModeImpl(@NotNull String id, boolean isSplit, @NotNull List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setSplitModeImpl"));
        }
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setSplitModeImpl"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (isSplit == info.isSplit()) {
            return;
        }
        this.myLayout.setSplitMode(id, isSplit);
        boolean wasActive = info.isActive();
        if (wasActive) {
            this.deactivateToolWindowImpl(id, true, commandList);
        }
        for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
            this.appendApplyWindowInfoCmd(info1, commandList);
        }
        if (wasActive) {
            this.activateToolWindowImpl(id, commandList, true, true);
        }
        commandList.add(this.myToolWindowsPane.createUpdateButtonPositionCmd(id, this.myCommandProcessor));
    }

    ToolWindowType getToolWindowInternalType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowInternalType"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getInternalType();
    }

    ToolWindowType getToolWindowType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowType"));
        }
        this.checkId(id);
        return this.getInfo(id).getType();
    }

    private void fireToolWindowRegistered(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "fireToolWindowRegistered"));
        }
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).toolWindowRegistered(id);
    }

    private void fireStateChanged() {
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).stateChanged();
    }

    boolean isToolWindowActive(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToolWindowActive"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isActive();
    }

    boolean isToolWindowAutoHide(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToolWindowAutoHide"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isAutoHide();
    }

    boolean isToolWindowVisible(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToolWindowVisible"));
        }
        this.checkId(id);
        return this.getInfo(id).isVisible();
    }

    void setToolWindowAutoHide(@NotNull String id, boolean autoHide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAutoHide"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAutoHideImpl(id, autoHide, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAutoHideImpl(@NotNull String id, boolean autoHide, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAutoHideImpl"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowAutoHideImpl"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.isAutoHide() == autoHide) {
            return;
        }
        info.setAutoHide(autoHide);
        this.appendApplyWindowInfoCmd(info, commandsList);
        if (info.isVisible()) {
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, false, commandsList, true, true);
        }
    }

    void setToolWindowType(@NotNull String id, @NotNull ToolWindowType type2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowType"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowTypeImpl(id, type2, commandList);
        this.execute(commandList);
    }

    private void setToolWindowTypeImpl(@NotNull String id, @NotNull ToolWindowType type2, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowTypeImpl"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowTypeImpl"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setToolWindowTypeImpl"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.getType() == type2) {
            return;
        }
        if (info.isVisible()) {
            boolean dirtyMode = info.isDocked() || info.isSliding();
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, dirtyMode, commandsList);
            }
            info.setType(type2);
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, dirtyMode, commandsList, true, true);
            this.appendUpdateToolWindowsPaneCmd(commandsList);
        } else {
            info.setType(type2);
            this.appendApplyWindowInfoCmd(info, commandsList);
        }
    }

    private void appendApplyWindowInfoCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendApplyWindowInfoCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendApplyWindowInfoCmd"));
        }
        StripeButton button = this.getStripeButton(info.getId());
        InternalDecorator decorator = this.getInternalDecorator(info.getId());
        commandsList.add(new ApplyWindowInfoCmd(info, button, decorator, this.myCommandProcessor));
    }

    private void appendAddDecoratorCmd(@NotNull InternalDecorator decorator, @NotNull WindowInfoImpl info, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendAddDecoratorCmd"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendAddDecoratorCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendAddDecoratorCmd"));
        }
        commandsList.add(this.myToolWindowsPane.createAddDecoratorCmd(decorator, info, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveDecoratorCmd(@NotNull String id, boolean dirtyMode, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveDecoratorCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveDecoratorCmd"));
        }
        commandsList.add(this.myToolWindowsPane.createRemoveDecoratorCmd(id, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveFloatingDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveFloatingDecoratorCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveFloatingDecoratorCmd"));
        }
        commandsList.add(new RemoveFloatingDecoratorCmd(info));
    }

    private void appendRemoveWindowedDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveWindowedDecoratorCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveWindowedDecoratorCmd"));
        }
        commandsList.add(new RemoveWindowedDecoratorCmd(info));
    }

    private void appendAddButtonCmd(StripeButton button, @NotNull WindowInfoImpl info, @NotNull List<FinalizableCommand> commandsList) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendAddButtonCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendAddButtonCmd"));
        }
        Comparator<StripeButton> comparator2 = this.myLayout.comparator(info.getAnchor());
        commandsList.add(this.myToolWindowsPane.createAddButtonCmd(button, info, comparator2, this.myCommandProcessor));
    }

    private void appendRemoveButtonCmd(@NotNull String id, @NotNull List<FinalizableCommand> commandsList) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveButtonCmd"));
        }
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendRemoveButtonCmd"));
        }
        commandsList.add(this.myToolWindowsPane.createRemoveButtonCmd(id, this.myCommandProcessor));
    }

    private ActionCallback appendRequestFocusInEditorComponentCmd(List<FinalizableCommand> commandList, boolean forced) {
        if (this.myProject.isDisposed()) {
            return ActionCallback.DONE;
        }
        EditorsSplitters splitters = this.getSplittersToFocus();
        RequestFocusInEditorComponentCmd command = new RequestFocusInEditorComponentCmd(splitters, this.getFocusManager(), this.myCommandProcessor, forced);
        commandList.add(command);
        return command.getDoneCallback();
    }

    private void appendRequestFocusInToolWindowCmd(String id, List<FinalizableCommand> commandList, boolean forced) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.getToolWindow(id);
        FocusWatcher focusWatcher = this.myId2FocusWatcher.get(id);
        commandList.add(new RequestFocusInToolWindowCmd(this.getFocusManager(), toolWindow, focusWatcher, this.myCommandProcessor, this.myProject));
    }

    private void appendSetEditorComponentCmd(@Nullable JComponent component, @NotNull List<FinalizableCommand> commandsList) {
        if (commandsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandsList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "appendSetEditorComponentCmd"));
        }
        commandsList.add(this.myToolWindowsPane.createSetEditorComponentCmd(component, this.myCommandProcessor));
    }

    private void appendUpdateToolWindowsPaneCmd(List<FinalizableCommand> commandsList) {
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            commandsList.add(new UpdateRootPaneCmd(rootPane, this.myCommandProcessor));
        }
    }

    private EditorsSplitters getSplittersToFocus() {
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow instanceof FloatingDecorator) {
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            activeWindow = (Window)ObjectUtils.notNull((Object)lastFocusedWindow, (Object)activeWindow);
        }
        FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(this.myProject);
        EditorsSplitters splitters = activeWindow != null ? fem.getSplittersFor(activeWindow) : null;
        return splitters != null ? splitters : fem.getSplitters();
    }

    @Override
    public void clearSideStack() {
        this.mySideStack.clear();
    }

    @Nullable
    public Element getState() {
        Element layoutToRestoreElement;
        Element layoutElement;
        if (this.myFrame == null) {
            return null;
        }
        for (String id : this.getToolWindowIds()) {
            WindowInfoImpl info = this.getInfo(id);
            if (!info.isVisible()) continue;
            InternalDecorator decorator = this.getInternalDecorator(id);
            LOG.assertTrue(decorator != null);
            decorator.fireResized();
        }
        Element element = new Element("state");
        Rectangle frameBounds = this.myFrame.getBounds();
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        frameElement.setAttribute(X_ATTR, Integer.toString(frameBounds.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(frameBounds.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(frameBounds.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(frameBounds.height));
        frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(this.myFrame.getExtendedState()));
        if (this.isEditorComponentActive()) {
            Element editorElement = new Element(EDITOR_ELEMENT);
            editorElement.setAttribute(ACTIVE_ATTR_VALUE, "true");
            element.addContent(editorElement);
        }
        if ((layoutElement = this.myLayout.writeExternal("layout")) != null) {
            element.addContent(layoutElement);
        }
        Element element2 = layoutToRestoreElement = this.myLayoutToRestoreLater == null ? null : this.myLayoutToRestoreLater.writeExternal(LAYOUT_TO_RESTORE);
        if (layoutToRestoreElement != null) {
            element.addContent(layoutToRestoreElement);
        }
        return element;
    }

    public void loadState(Element state) {
        for (Element e : state.getChildren()) {
            if (EDITOR_ELEMENT.equals(e.getName())) {
                this.myEditorWasActive = Boolean.valueOf(e.getAttributeValue(ACTIVE_ATTR_VALUE));
                continue;
            }
            if ("layout".equals(e.getName())) {
                this.myLayout.readExternal(e);
                continue;
            }
            if (!LAYOUT_TO_RESTORE.equals(e.getName())) continue;
            this.myLayoutToRestoreLater = new DesktopLayout();
            this.myLayoutToRestoreLater.readExternal(e);
        }
    }

    public void setDefaultState(@NotNull ToolWindowImpl toolWindow, @Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type2, @Nullable Rectangle floatingBounds) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setDefaultState"));
        }
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        if (floatingBounds != null) {
            info.setFloatingBounds(floatingBounds);
        }
        if (anchor != null) {
            toolWindow.setAnchor(anchor, null);
        }
        if (type2 != null) {
            toolWindow.setType(type2, null);
        }
    }

    void setDefaultContentUiType(@NotNull ToolWindowImpl toolWindow, @NotNull ToolWindowContentUiType type2) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setDefaultContentUiType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setDefaultContentUiType"));
        }
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        toolWindow.setContentUiType(type2, null);
    }

    void stretchWidth(@NotNull ToolWindowImpl toolWindow, int value2) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "stretchWidth"));
        }
        this.myToolWindowsPane.stretchWidth(toolWindow, value2);
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isMaximized"));
        }
        return this.myToolWindowsPane.isMaximized(wnd);
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setMaximized"));
        }
        if (wnd.getType() == ToolWindowType.FLOATING && wnd instanceof ToolWindowImpl) {
            MaximizeActiveDialogAction.doMaximize(this.getFloatingDecorator(((ToolWindowImpl)wnd).getId()));
            return;
        }
        if (wnd.getType() == ToolWindowType.WINDOWED && wnd instanceof ToolWindowImpl) {
            Frame frame;
            WindowedDecorator decorator = this.getWindowedDecorator(((ToolWindowImpl)wnd).getId());
            Frame frame2 = frame = decorator != null && decorator.getFrame() instanceof Frame ? (Frame)decorator.getFrame() : null;
            if (frame != null) {
                int state = frame.getState();
                if (state == 0) {
                    frame.setState(6);
                } else if (state == 6) {
                    frame.setState(0);
                }
            }
            return;
        }
        this.myToolWindowsPane.setMaximized(wnd, maximized);
    }

    void stretchHeight(ToolWindowImpl toolWindow, int value2) {
        this.myToolWindowsPane.stretchHeight(toolWindow, value2);
    }

    @NotNull
    private static Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane = frame.getRootPane();
        Rectangle bounds = rootPane.getBounds();
        bounds.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getRootBounds"));
        }
        return rectangle;
    }

    private void updateComponentTreeUI() {
        WindowInfoImpl[] infos;
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            IJSwingUtilities.updateComponentTreeUI(this.getInternalDecorator(info.getId()));
        }
    }

    @NotNull
    public ActionCallback requestDefaultFocus(final boolean forced) {
        ActionCallback actionCallback = ToolWindowManagerImpl.getFocusManagerImpl(this.myProject).requestFocus(new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                ActionCallback actionCallback = ToolWindowManagerImpl.this.processDefaultFocusRequest(forced);
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$9", "run"));
                }
                return actionCallback;
            }
        }, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestDefaultFocus"));
        }
        return actionCallback;
    }

    private void focusToolWindowByDefault(@Nullable String idToIgnore) {
        String toFocus = null;
        for (String each : this.myActiveStack.getStack()) {
            if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
            toFocus = each;
            break;
        }
        if (toFocus == null) {
            for (String each : this.myActiveStack.getPersistentStack()) {
                if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
                toFocus = each;
                break;
            }
        }
        if (toFocus != null && !ApplicationManager.getApplication().isDisposeInProgress() && !ApplicationManager.getApplication().isDisposed()) {
            this.activateToolWindow(toFocus, false, true);
        }
    }

    private ActionCallback processDefaultFocusRequest(boolean forced) {
        if (ModalityState.NON_MODAL.equals(ModalityState.current())) {
            String activeId = this.getActiveToolWindowId();
            if (this.isEditorComponentActive() || activeId == null || this.getToolWindow(activeId) == null) {
                this.activateEditorComponent(forced, true);
            } else {
                this.activateToolWindow(activeId, forced, true);
            }
            return ActionCallback.DONE;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow != null) {
            JComponent toFocus;
            JRootPane root = null;
            if (activeWindow instanceof JDialog) {
                root = ((JDialog)activeWindow).getRootPane();
            } else if (activeWindow instanceof JFrame) {
                root = ((JFrame)activeWindow).getRootPane();
            }
            if (root != null && (toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(root)) != null) {
                if (DialogWrapper.findInstance((Component)toFocus) != null) {
                    return ActionCallback.DONE;
                }
                return IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, forced);
            }
        }
        return ActionCallback.REJECTED;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(command, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "doWhenFocusSettlesDown"));
        }
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(runnable2);
    }

    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "dispatch"));
        }
        return IdeFocusManager.getInstance((Project)this.myProject).dispatch(e);
    }

    @NotNull
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        Expirable expirable = IdeFocusManager.getInstance((Project)this.myProject).getTimestamp(trackOnlyForcedCommands);
        if (expirable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getTimestamp"));
        }
        return expirable;
    }

    void setShowStripeButton(@NotNull String id, boolean visibleOnPanel) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setShowStripeButton"));
        }
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (visibleOnPanel == info.isShowStripeButton()) {
            return;
        }
        info.setShowStripeButton(visibleOnPanel);
        ToolWindowManagerImpl.triggerUsage("StripeButton[" + id + "]." + (visibleOnPanel ? "shown" : "hidden"));
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    boolean isShowStripeButton(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isShowStripeButton"));
        }
        WindowInfoImpl info = this.getInfo(id);
        return info == null || info.isShowStripeButton();
    }

    private static void triggerUsage(@NotNull String feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "triggerUsage"));
        }
        UsageTrigger.trigger(ConvertUsagesUtil.escapeDescriptorName(feature));
    }

    public static class InitToolWindowsActivity
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$InitToolWindowsActivity", "runActivity"));
            }
            ToolWindowManagerEx ex = ToolWindowManagerEx.getInstanceEx(project2);
            if (ex instanceof ToolWindowManagerImpl) {
                ToolWindowManagerImpl manager = (ToolWindowManagerImpl)ex;
                ArrayList list2 = new ArrayList();
                manager.registerToolWindowsFromBeans(list2);
                manager.initAll(list2);
                EdtInvocationManager.getInstance().invokeLater(() -> {
                    manager.execute(list2);
                    manager.flushCommands();
                });
            }
        }
    }

    private final class MyLafManagerListener
    implements LafManagerListener {
        private MyLafManagerListener() {
        }

        public void lookAndFeelChanged(LafManager source) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyUIManagerPropertyChangeListener
    implements PropertyChangeListener {
        private MyUIManagerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyInternalDecoratorListener
    implements InternalDecoratorListener {
        private MyInternalDecoratorListener() {
        }

        @Override
        public void anchorChanged(@NotNull InternalDecorator source, @NotNull ToolWindowAnchor anchor) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "anchorChanged"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "anchorChanged"));
            }
            ToolWindowManagerImpl.this.setToolWindowAnchor(source.getToolWindow().getId(), anchor);
        }

        @Override
        public void autoHideChanged(@NotNull InternalDecorator source, boolean autoHide) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "autoHideChanged"));
            }
            ToolWindowManagerImpl.this.setToolWindowAutoHide(source.getToolWindow().getId(), autoHide);
        }

        @Override
        public void hidden(@NotNull InternalDecorator source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "hidden"));
            }
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), false);
        }

        @Override
        public void hiddenSide(@NotNull InternalDecorator source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "hiddenSide"));
            }
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), true);
        }

        @Override
        public void contentUiTypeChanges(@NotNull InternalDecorator source, @NotNull ToolWindowContentUiType type2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "contentUiTypeChanges"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "contentUiTypeChanges"));
            }
            ToolWindowManagerImpl.this.setContentUiType(source.getToolWindow().getId(), type2);
        }

        @Override
        public void resized(@NotNull InternalDecorator source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "resized"));
            }
            if (!source.isShowing()) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(source.getToolWindow().getId());
            if (info.isFloating()) {
                Window owner2 = SwingUtilities.getWindowAncestor(source);
                if (owner2 != null) {
                    info.setFloatingBounds(owner2.getBounds());
                }
            } else if (info.isWindowed()) {
                Window frame;
                WindowedDecorator decorator = ToolWindowManagerImpl.this.getWindowedDecorator(info.getId());
                Window window = frame = decorator != null ? decorator.getFrame() : null;
                if (frame == null || !frame.isShowing()) {
                    return;
                }
                info.setFloatingBounds(ToolWindowManagerImpl.getRootBounds((JFrame)frame));
            } else {
                ToolWindowAnchor anchor = info.getAnchor();
                InternalDecorator another = null;
                if (source.getParent() instanceof Splitter) {
                    float sizeInSplit = anchor.isSplitVertically() ? (float)source.getHeight() : (float)source.getWidth();
                    Splitter splitter = (Splitter)source.getParent();
                    if (splitter.getSecondComponent() == source) {
                        sizeInSplit += (float)splitter.getDividerWidth();
                        another = (InternalDecorator)splitter.getFirstComponent();
                    } else {
                        another = (InternalDecorator)splitter.getSecondComponent();
                    }
                    if (anchor.isSplitVertically()) {
                        info.setSideWeight(sizeInSplit / (float)splitter.getHeight());
                    } else {
                        info.setSideWeight(sizeInSplit / (float)splitter.getWidth());
                    }
                }
                float paneWeight = anchor.isHorizontal() ? (float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                info.setWeight(paneWeight);
                if (another != null && anchor.isSplitVertically()) {
                    paneWeight = anchor.isHorizontal() ? (float)another.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)another.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                    another.getWindowInfo().setWeight(paneWeight);
                }
            }
        }

        @Override
        public void activated(@NotNull InternalDecorator source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "activated"));
            }
            ToolWindowManagerImpl.this.activateToolWindow(source.getToolWindow().getId(), true, true);
        }

        @Override
        public void typeChanged(@NotNull InternalDecorator source, @NotNull ToolWindowType type2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "typeChanged"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "typeChanged"));
            }
            ToolWindowManagerImpl.this.setToolWindowType(source.getToolWindow().getId(), type2);
        }

        @Override
        public void sideStatusChanged(@NotNull InternalDecorator source, boolean isSideTool) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "sideStatusChanged"));
            }
            ToolWindowManagerImpl.this.setSideTool(source.getToolWindow().getId(), isSideTool);
        }

        @Override
        public void visibleStripeButtonChanged(@NotNull InternalDecorator source, boolean visible) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "visibleStripeButtonChanged"));
            }
            ToolWindowManagerImpl.this.setShowStripeButton(source.getToolWindow().getId(), visible);
        }
    }

    private final class MyToolWindowPropertyChangeListener
    implements PropertyChangeListener {
        private MyToolWindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StripeButton button;
            ToolWindowImpl toolWindow = (ToolWindowImpl)e.getSource();
            if ("available".equals(e.getPropertyName())) {
                WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(toolWindow.getId());
                if (!toolWindow.isAvailable() && info.isVisible()) {
                    ToolWindowManagerImpl.this.hideToolWindow(toolWindow.getId(), false);
                }
            }
            if ((button = (StripeButton)ToolWindowManagerImpl.this.myId2StripeButton.get(toolWindow.getId())) != null) {
                button.updatePresentation();
            }
            ActivateToolWindowAction.updateToolWindowActionPresentation(toolWindow);
        }
    }

    private final class ToolWindowFocusWatcher
    extends FocusWatcher {
        private final String myId;
        private final ToolWindowImpl myToolWindow;

        private ToolWindowFocusWatcher(ToolWindowImpl toolWindow) {
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$ToolWindowFocusWatcher", "<init>"));
            }
            this.myId = toolWindow.getId();
            this.install(toolWindow.getComponent());
            this.myToolWindow = toolWindow;
        }

        public void deinstall() {
            this.deinstall(this.myToolWindow.getComponent());
        }

        protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
            return ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() == 0 && comp != null;
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() > 0 || component == null) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(this.myId);
            if (!info.isActive()) {
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new EdtRunnable(){

                    public void runEdt() {
                        WindowInfoImpl windowInfo = ToolWindowManagerImpl.this.myLayout.getInfo(ToolWindowFocusWatcher.this.myId, true);
                        if (windowInfo == null || !windowInfo.isVisible()) {
                            return;
                        }
                        ToolWindowManagerImpl.this.activateToolWindow(ToolWindowFocusWatcher.this.myId, false, false);
                    }
                });
            }
        }
    }

    private final class EditorComponentFocusWatcher
    extends FocusWatcher {
        private EditorComponentFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() > 0 || component == null) {
                return;
            }
            final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            final Component owner2 = mgr.getFocusOwner();
            if (owner2 instanceof EditorComponentImpl && cause instanceof FocusEvent) {
                JFrame frame = WindowManager.getInstance().getFrame(ToolWindowManagerImpl.this.myProject);
                Component oppositeComponent = ((FocusEvent)cause).getOppositeComponent();
                if (oppositeComponent != null && UIUtil.getWindow((Component)oppositeComponent) != frame) {
                    return;
                }
            }
            IdeFocusManager.getInstance((Project)ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                public void run() {
                    if (mgr.getFocusOwner() == owner2) {
                        ToolWindowManagerImpl.this.activateEditorComponent(false);
                    }
                }
            });
        }
    }

    private final class RemoveWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private RemoveWindowedDecoratorCmd(WindowInfoImpl info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveWindowedDecoratorCmd", "<init>"));
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = ToolWindowManagerImpl.this.getWindowedDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2WindowedDecorator.remove(info.getId());
            Window frame = this.myWindowedDecorator.getFrame();
            if (!frame.isShowing()) {
                return;
            }
            Rectangle bounds = ToolWindowManagerImpl.getRootBounds((JFrame)frame);
            info.setFloatingBounds(bounds);
        }

        @Override
        public void run() {
            try {
                Disposer.dispose((Disposable)this.myWindowedDecorator);
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            Condition condition2 = ApplicationManager.getApplication().getDisposed();
            if (condition2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveWindowedDecoratorCmd", "getExpireCondition"));
            }
            return condition2;
        }
    }

    private final class AddWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private AddWindowedDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            if (decorator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddWindowedDecoratorCmd", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddWindowedDecoratorCmd", "<init>"));
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = new WindowedDecorator(ToolWindowManagerImpl.this.myProject, info.copy(), decorator);
            Window window = this.myWindowedDecorator.getFrame();
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                window.setBounds(bounds);
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                window.setSize(size);
                window.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
            ToolWindowManagerImpl.this.myId2WindowedDecorator.put(info.getId(), this.myWindowedDecorator);
            this.myWindowedDecorator.addDisposable(() -> {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddWindowedDecoratorCmd", "lambda$new$0"));
                }
                if (ToolWindowManagerImpl.this.myId2WindowedDecorator.get(info.getId()) != null) {
                    ToolWindowManagerImpl.this.hideToolWindow(info.getId(), false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myWindowedDecorator.show(false);
                Window window = this.myWindowedDecorator.getFrame();
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Rectangle rootPaneBounds = rootPane.getBounds();
                Point point = rootPane.getLocationOnScreen();
                Rectangle windowBounds = window.getBounds();
                window.setLocation(2 * windowBounds.x - point.x, 2 * windowBounds.y - point.y);
                window.setSize(2 * windowBounds.width - rootPaneBounds.width, 2 * windowBounds.height - rootPaneBounds.height);
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private RemoveFloatingDecoratorCmd(WindowInfoImpl info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveFloatingDecoratorCmd", "<init>"));
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = ToolWindowManagerImpl.this.getFloatingDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2FloatingDecorator.remove(info.getId());
            info.setFloatingBounds(this.myFloatingDecorator.getBounds());
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.dispose();
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            Condition condition2 = ApplicationManager.getApplication().getDisposed();
            if (condition2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$RemoveFloatingDecoratorCmd", "getExpireCondition"));
            }
            return condition2;
        }
    }

    private final class AddFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private AddFloatingDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            if (decorator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddFloatingDecoratorCmd", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$AddFloatingDecoratorCmd", "<init>"));
            }
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = new FloatingDecorator(ToolWindowManagerImpl.this.myFrame, info.copy(), decorator);
            ToolWindowManagerImpl.this.myId2FloatingDecorator.put(info.getId(), this.myFloatingDecorator);
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                this.myFloatingDecorator.setBounds(bounds);
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                this.myFloatingDecorator.setSize(size);
                this.myFloatingDecorator.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.show();
            }
            finally {
                this.finish();
            }
        }
    }

    private static class BalloonHyperlinkListener
    implements HyperlinkListener {
        private Balloon myBalloon;
        private final HyperlinkListener myListener;

        BalloonHyperlinkListener(HyperlinkListener listener2) {
            this.myListener = listener2;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (this.myBalloon != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myBalloon.hide();
            }
            if (this.myListener != null) {
                this.myListener.hyperlinkUpdate(e);
            }
        }
    }

    private static enum KeyState {
        waiting,
        pressed,
        released,
        hold;

    }
}

