/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.ProjectFrameBoundsKt;
import java.awt.Rectangle;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WindowInfoImpl
implements Cloneable,
JDOMExternalizable,
WindowInfo {
    @NonNls
    static final String TAG = "window_info";
    static final float DEFAULT_WEIGHT = 0.33f;
    private static final float DEFAULT_SIDE_WEIGHT = 0.5f;
    private boolean myActive;
    @NotNull
    private ToolWindowAnchor myAnchor;
    private boolean myAutoHide;
    private Rectangle myFloatingBounds;
    private String myId;
    private ToolWindowType myInternalType;
    private ToolWindowType myType;
    private boolean myVisible;
    private boolean myShowStripeButton;
    private float myWeight;
    private float mySideWeight;
    private boolean mySplitMode;
    @NotNull
    private ToolWindowContentUiType myContentUiType;
    private int myOrder;
    @NonNls
    private static final String ID_ATTR = "id";
    @NonNls
    private static final String ACTIVE_ATTR = "active";
    @NonNls
    private static final String ANCHOR_ATTR = "anchor";
    @NonNls
    private static final String AUTOHIDE_ATTR = "auto_hide";
    @NonNls
    private static final String INTERNAL_TYPE_ATTR = "internal_type";
    @NonNls
    private static final String TYPE_ATTR = "type";
    @NonNls
    private static final String VISIBLE_ATTR = "visible";
    @NonNls
    private static final String WEIGHT_ATTR = "weight";
    @NonNls
    private static final String SIDE_WEIGHT_ATTR = "sideWeight";
    @NonNls
    private static final String ORDER_ATTR = "order";
    @NonNls
    private static final String SIDE_TOOL_ATTR = "side_tool";
    @NonNls
    private static final String CONTENT_UI_ATTR = "content_ui";
    @NonNls
    private static final String SHOW_STRIPE_BUTTON = "show_stripe_button";
    private boolean myWasRead;

    WindowInfoImpl(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "<init>"));
        }
        this.myAnchor = ToolWindowAnchor.LEFT;
        this.myShowStripeButton = true;
        this.myWeight = 0.33f;
        this.mySideWeight = 0.5f;
        this.myContentUiType = ToolWindowContentUiType.TABBED;
        this.myOrder = -1;
        this.myId = id;
        this.setType(ToolWindowType.DOCKED);
    }

    @NotNull
    public WindowInfoImpl copy() {
        WindowInfoImpl windowInfoImpl;
        try {
            WindowInfoImpl info = (WindowInfoImpl)this.clone();
            if (this.myFloatingBounds != null) {
                info.myFloatingBounds = (Rectangle)this.myFloatingBounds.clone();
            }
            windowInfoImpl = info;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (windowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "copy"));
        }
        return windowInfoImpl;
    }

    void copyFrom(@NotNull WindowInfoImpl info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/WindowInfoImpl", "copyFrom"));
        }
        this.myActive = info.myActive;
        this.myAnchor = info.myAnchor;
        this.myAutoHide = info.myAutoHide;
        this.myFloatingBounds = info.myFloatingBounds == null ? null : (Rectangle)info.myFloatingBounds.clone();
        this.myId = info.myId;
        this.setTypeAndCheck(info.myType);
        this.myInternalType = info.myInternalType;
        this.myVisible = info.myVisible;
        this.myWeight = info.myWeight;
        this.mySideWeight = info.mySideWeight;
        this.myOrder = info.myOrder;
        this.mySplitMode = info.mySplitMode;
        this.myContentUiType = info.myContentUiType;
    }

    @NotNull
    public ToolWindowAnchor getAnchor() {
        ToolWindowAnchor toolWindowAnchor = this.myAnchor;
        if (toolWindowAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getAnchor"));
        }
        return toolWindowAnchor;
    }

    @NotNull
    public ToolWindowContentUiType getContentUiType() {
        ToolWindowContentUiType toolWindowContentUiType = this.myContentUiType;
        if (toolWindowContentUiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getContentUiType"));
        }
        return toolWindowContentUiType;
    }

    void setContentUiType(@NotNull ToolWindowContentUiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TYPE_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setContentUiType"));
        }
        this.myContentUiType = type2;
    }

    public Rectangle getFloatingBounds() {
        return this.myFloatingBounds != null ? new Rectangle(this.myFloatingBounds) : null;
    }

    @NotNull
    String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getId"));
        }
        return string;
    }

    @NotNull
    ToolWindowType getInternalType() {
        ToolWindowType toolWindowType = this.myInternalType;
        if (toolWindowType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowInfoImpl", "getInternalType"));
        }
        return toolWindowType;
    }

    public ToolWindowType getType() {
        return this.myType;
    }

    float getWeight() {
        return this.myWeight;
    }

    float getSideWeight() {
        return this.mySideWeight;
    }

    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int order) {
        this.myOrder = order;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public boolean isDocked() {
        return ToolWindowType.DOCKED == this.myType;
    }

    public boolean isFloating() {
        return ToolWindowType.FLOATING == this.myType;
    }

    public boolean isWindowed() {
        return ToolWindowType.WINDOWED == this.myType;
    }

    public boolean isSliding() {
        return ToolWindowType.SLIDING == this.myType;
    }

    boolean isVisible() {
        return this.myVisible;
    }

    public boolean isShowStripeButton() {
        return this.myShowStripeButton;
    }

    void setShowStripeButton(boolean showStripeButton) {
        this.myShowStripeButton = showStripeButton;
    }

    public boolean isSplit() {
        return this.mySplitMode;
    }

    public void setSplit(boolean sideTool) {
        this.mySplitMode = sideTool;
    }

    public void readExternal(Element element) {
        this.myId = element.getAttributeValue(ID_ATTR);
        this.myWasRead = true;
        this.myActive = Boolean.parseBoolean(element.getAttributeValue(ACTIVE_ATTR)) && WindowInfoImpl.canActivateOnStart(this.myId);
        try {
            this.myAnchor = ToolWindowAnchor.fromText((String)element.getAttributeValue(ANCHOR_ATTR));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.myAutoHide = Boolean.parseBoolean(element.getAttributeValue(AUTOHIDE_ATTR));
        try {
            this.myInternalType = ToolWindowType.valueOf((String)element.getAttributeValue(INTERNAL_TYPE_ATTR));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.setTypeAndCheck(ToolWindowType.valueOf((String)element.getAttributeValue(TYPE_ATTR)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean bl = this.myVisible = Boolean.parseBoolean(element.getAttributeValue(VISIBLE_ATTR)) && WindowInfoImpl.canActivateOnStart(this.myId);
        if (element.getAttributeValue(SHOW_STRIPE_BUTTON) != null) {
            this.myShowStripeButton = Boolean.parseBoolean(element.getAttributeValue(SHOW_STRIPE_BUTTON));
        }
        try {
            this.myWeight = Float.parseFloat(element.getAttributeValue(WEIGHT_ATTR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            String value2 = element.getAttributeValue(SIDE_WEIGHT_ATTR);
            if (value2 != null) {
                this.mySideWeight = Float.parseFloat(value2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.myOrder = Integer.parseInt(element.getAttributeValue(ORDER_ATTR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myFloatingBounds = ProjectFrameBoundsKt.deserializeBounds(element);
        this.mySplitMode = Boolean.parseBoolean(element.getAttributeValue(SIDE_TOOL_ATTR));
        this.myContentUiType = ToolWindowContentUiType.getInstance((String)element.getAttributeValue(CONTENT_UI_ATTR));
    }

    private static boolean canActivateOnStart(String id) {
        for (ToolWindowEP ep : (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions()) {
            if (!id.equals(ep.id)) continue;
            ToolWindowFactory factory = ep.getToolWindowFactory();
            return !factory.isDoNotActivateOnStart();
        }
        return true;
    }

    void setAnchor(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ANCHOR_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setAnchor"));
        }
        this.myAnchor = anchor;
    }

    void setActive(boolean active) {
        this.myActive = active;
    }

    void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
    }

    void setFloatingBounds(Rectangle floatingBounds) {
        this.myFloatingBounds = floatingBounds;
    }

    void setType(@NotNull ToolWindowType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TYPE_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setType"));
        }
        if (ToolWindowType.DOCKED == type2 || ToolWindowType.SLIDING == type2) {
            this.myInternalType = type2;
        }
        this.setTypeAndCheck(type2);
    }

    private void setTypeAndCheck(@NotNull ToolWindowType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TYPE_ATTR, "com/intellij/openapi/wm/impl/WindowInfoImpl", "setTypeAndCheck"));
        }
        this.myType = ToolWindowId.PREVIEW == this.myId && type2 == ToolWindowType.DOCKED ? ToolWindowType.SLIDING : type2;
    }

    void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    void setWeight(float weight) {
        this.myWeight = Math.max(0.0f, Math.min(1.0f, weight));
    }

    void setSideWeight(float weight) {
        this.mySideWeight = Math.max(0.0f, Math.min(1.0f, weight));
    }

    public void writeExternal(Element element) {
        element.setAttribute(ID_ATTR, this.myId);
        element.setAttribute(ACTIVE_ATTR, Boolean.toString(this.myActive));
        element.setAttribute(ANCHOR_ATTR, this.myAnchor.toString());
        element.setAttribute(AUTOHIDE_ATTR, Boolean.toString(this.myAutoHide));
        element.setAttribute(INTERNAL_TYPE_ATTR, this.myInternalType.toString());
        element.setAttribute(TYPE_ATTR, this.myType.toString());
        element.setAttribute(VISIBLE_ATTR, Boolean.toString(this.myVisible));
        element.setAttribute(SHOW_STRIPE_BUTTON, Boolean.toString(this.myShowStripeButton));
        element.setAttribute(WEIGHT_ATTR, Float.toString(this.myWeight));
        element.setAttribute(SIDE_WEIGHT_ATTR, Float.toString(this.mySideWeight));
        element.setAttribute(ORDER_ATTR, Integer.toString(this.myOrder));
        element.setAttribute(SIDE_TOOL_ATTR, Boolean.toString(this.mySplitMode));
        element.setAttribute(CONTENT_UI_ATTR, this.myContentUiType.getName());
        if (this.myFloatingBounds != null) {
            ProjectFrameBoundsKt.serializeBounds(this.myFloatingBounds, element);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WindowInfoImpl)) {
            return false;
        }
        WindowInfoImpl info = (WindowInfoImpl)obj;
        return this.myActive == info.myActive && this.myAnchor == info.myAnchor && this.myId.equals(info.myId) && this.myAutoHide == info.myAutoHide && Comparing.equal((Object)this.myFloatingBounds, (Object)info.myFloatingBounds) && this.myInternalType == info.myInternalType && this.myType == info.myType && this.myVisible == info.myVisible && this.myShowStripeButton == info.myShowStripeButton && this.myWeight == info.myWeight && this.mySideWeight == info.mySideWeight && this.myOrder == info.myOrder && this.mySplitMode == info.mySplitMode && this.myContentUiType == info.myContentUiType;
    }

    public int hashCode() {
        return this.myAnchor.hashCode() + this.myId.hashCode() + this.myType.hashCode() + this.myOrder;
    }

    public String toString() {
        return this.getClass().getName() + "[myId=" + this.myId + "; myVisible=" + this.myVisible + "; myShowStripeButton=" + this.myShowStripeButton + "; myActive=" + this.myActive + "; myAnchor=" + this.myAnchor + "; myOrder=" + this.myOrder + "; myAutoHide=" + this.myAutoHide + "; myWeight=" + this.myWeight + "; mySideWeight=" + this.mySideWeight + "; myType=" + this.myType + "; myInternalType=" + this.myInternalType + "; myFloatingBounds=" + this.myFloatingBounds + "; mySplitMode=" + this.mySplitMode + "; myContentUiType=" + this.myContentUiType.getName() + ']';
    }

    boolean wasRead() {
        return this.myWasRead;
    }
}

