/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.AWTUtilitiesWrapper;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameBoundsKt;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.WindowUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WindowManager", defaultStateAsResource=true, storages={@Storage(value="window.manager.xml", roamingType=RoamingType.DISABLED)})
public final class WindowManagerImpl
extends WindowManagerEx
implements NamedComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.WindowManagerImpl");
    @NonNls
    public static final String FULL_SCREEN = "ide.frame.full.screen";
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    private Boolean myAlphaModeSupported = null;
    private final EventDispatcher<WindowManagerListener> myEventDispatcher = EventDispatcher.create(WindowManagerListener.class);
    private final CommandProcessor myCommandProcessor;
    private final WindowWatcher myWindowWatcher;
    private final DesktopLayout myLayout;
    private final HashMap<Project, IdeFrameImpl> myProjectToFrame;
    private final HashMap<Project, Set<JDialog>> myDialogsToDispose;
    @NotNull
    final FrameInfo myDefaultFrameInfo = new FrameInfo();
    private final WindowAdapter myActivationListener;
    private final DataManager myDataManager;
    private final ActionManagerEx myActionManager;

    public WindowManagerImpl(DataManager dataManager, ActionManagerEx actionManager) {
        Application application;
        this.myDataManager = dataManager;
        this.myActionManager = actionManager;
        if (this.myDataManager instanceof DataManagerImpl) {
            ((DataManagerImpl)this.myDataManager).setWindowManager(this);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode()) {
            Disposer.register((Disposable)application, (Disposable)new Disposable(){

                public void dispose() {
                    WindowManagerImpl.this.disposeRootFrame();
                }
            });
        }
        this.myCommandProcessor = new CommandProcessor();
        this.myWindowWatcher = new WindowWatcher();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, this.myWindowWatcher);
        this.myLayout = new DesktopLayout();
        this.myProjectToFrame = new HashMap();
        this.myDialogsToDispose = new HashMap();
        this.myActivationListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window activeWindow = e.getWindow();
                if (activeWindow instanceof IdeFrameImpl) {
                    WindowManagerImpl.this.proceedDialogDisposalQueue(((IdeFrameImpl)activeWindow).getProject());
                }
            }
        };
        if (UIUtil.hasLeakingAppleListeners()) {
            UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event.getID() == 300 && ((ContainerEvent)event).getChild() instanceof JViewport) {
                        UIUtil.removeLeakingAppleListeners();
                    }
                }
            }, (long)2L, (Disposable)application);
        }
    }

    @NotNull
    public IdeFrameImpl[] getAllProjectFrames() {
        Collection<IdeFrameImpl> ideFrames = this.myProjectToFrame.values();
        IdeFrameImpl[] ideFrameImplArray = ideFrames.toArray(new IdeFrameImpl[ideFrames.size()]);
        if (ideFrameImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getAllProjectFrames"));
        }
        return ideFrameImplArray;
    }

    public JFrame findVisibleFrame() {
        IdeFrameImpl[] frames = this.getAllProjectFrames();
        return frames.length > 0 ? frames[0] : (JFrame)WelcomeFrame.getInstance();
    }

    public void addListener(WindowManagerListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(WindowManagerListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public final Rectangle getScreenBounds() {
        return ScreenUtil.getAllScreensRectangle();
    }

    @Override
    public Rectangle getScreenBounds(@NotNull Project project2) {
        GraphicsDevice[] devices;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getScreenBounds"));
        }
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point onScreen = this.getFrame(project2).getLocationOnScreen();
        for (GraphicsDevice device : devices = environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(onScreen)) continue;
            return bounds;
        }
        return null;
    }

    public final boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    public final boolean isInsideScreenBounds(int x, int y) {
        return ScreenUtil.getAllScreensShape().contains(x, y);
    }

    public final boolean isAlphaModeSupported() {
        if (this.myAlphaModeSupported == null) {
            this.myAlphaModeSupported = WindowManagerImpl.calcAlphaModelSupported();
        }
        return this.myAlphaModeSupported;
    }

    private static boolean calcAlphaModelSupported() {
        if (AWTUtilitiesWrapper.isTranslucencyAPISupported()) {
            return AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT);
        }
        try {
            return WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public final void setAlphaModeRatio(Window window, float ratio) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be in [0..1] range. ratio=" + ratio);
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImpl.setAlphaMode(window, ratio);
    }

    private static void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfo.isMacOSLeopard) {
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.TRANSLUCENT)) {
                AWTUtilitiesWrapper.setWindowOpacity(window, 1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowMask(Window window, @Nullable Shape mask) {
        try {
            if (AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.PERPIXEL_TRANSPARENT)) {
                AWTUtilitiesWrapper.setWindowShape(window, mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowShadow(Window window, WindowManagerEx.WindowShadowMode mode) {
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode == WindowManagerEx.WindowShadowMode.DISABLED ? Boolean.FALSE : Boolean.TRUE);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(Window window) {
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImpl.setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    public final boolean isAlphaModeEnabled(Window window) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        return this.isAlphaModeSupported();
    }

    public final void setAlphaModeEnabled(Window window, boolean state) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
    }

    @Override
    public void hideDialog(JDialog dialog2, Project project2) {
        if (project2 == null) {
            dialog2.dispose();
        } else {
            IdeFrameImpl frame = this.getFrame(project2);
            if (frame.isActive()) {
                dialog2.dispose();
            } else {
                this.queueForDisposal(dialog2, project2);
                dialog2.setVisible(false);
            }
        }
    }

    @Override
    public void adjustContainerWindow(Component c, Dimension oldSize, Dimension newSize) {
        JBPopup popup;
        if (c == null) {
            return;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow && (popup = (JBPopup)((JWindow)wnd).getRootPane().getClientProperty("JBPopup")) != null && oldSize.height < newSize.height) {
            Dimension size = popup.getSize();
            size.height += newSize.height - oldSize.height;
            popup.setSize(size);
            popup.moveToFitScreen();
        }
    }

    public final void doNotSuggestAsParent(Window window) {
        this.myWindowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public final void dispatchComponentEvent(ComponentEvent e) {
        this.myWindowWatcher.dispatchComponentEvent(e);
    }

    @Nullable
    public final Window suggestParentWindow(@Nullable Project project2) {
        return this.myWindowWatcher.suggestParentWindow(project2);
    }

    public final StatusBar getStatusBar(Project project2) {
        IdeFrameImpl frame = this.myProjectToFrame.get(project2);
        return frame == null ? null : frame.getStatusBar();
    }

    public StatusBar getStatusBar(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getStatusBar"));
        }
        return this.getStatusBar(c, null);
    }

    public StatusBar getStatusBar(@NotNull Component c, @Nullable Project project2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getStatusBar"));
        }
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return ((IdeFrame)parent).getStatusBar().findChild(c);
        }
        IdeFrame frame = this.findFrameFor(project2);
        if (frame != null) {
            return frame.getStatusBar().findChild(c);
        }
        assert (false) : "Cannot find status bar for " + c;
        return null;
    }

    @Override
    public IdeFrame findFrameFor(@Nullable Project project2) {
        IdeFrame frame = null;
        if (project2 != null) {
            Object object = frame = project2.isDefault() ? WelcomeFrame.getInstance() : this.getFrame(project2);
            if (frame == null) {
                frame = this.myProjectToFrame.get(null);
            }
        } else {
            for (Container eachParent = this.getMostRecentFocusedWindow(); eachParent != null; eachParent = eachParent.getParent()) {
                if (!(eachParent instanceof IdeFrame)) continue;
                frame = (IdeFrame)eachParent;
                break;
            }
            if (frame == null) {
                frame = WindowManagerImpl.tryToFindTheOnlyFrame();
            }
        }
        return frame;
    }

    private static IdeFrame tryToFindTheOnlyFrame() {
        Frame[] all;
        IdeFrame candidate = null;
        for (Frame each : all = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            if (candidate == null) {
                candidate = (IdeFrame)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    @Override
    public final IdeFrameImpl getFrame(@Nullable Project project2) {
        return this.myProjectToFrame.get(project2);
    }

    public IdeFrame getIdeFrame(@Nullable Project project2) {
        Frame[] frames;
        if (project2 != null) {
            return this.getFrame(project2);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component parent = UIUtil.findUltimateParent((Component)window);
        if (parent instanceof IdeFrame) {
            return (IdeFrame)parent;
        }
        for (Frame each : frames = Frame.getFrames()) {
            if (!(each instanceof IdeFrame)) continue;
            return (IdeFrame)each;
        }
        return null;
    }

    public void showFrame() {
        IdeFrameImpl frame = new IdeFrameImpl(ApplicationInfoEx.getInstanceEx(), this.myActionManager, this.myDataManager, ApplicationManager.getApplication());
        this.myProjectToFrame.put(null, frame);
        Rectangle frameBounds = this.myDefaultFrameInfo.getBounds();
        if (frameBounds == null || !ScreenUtil.isVisible((Rectangle)frameBounds)) {
            frameBounds = ScreenUtil.getMainScreenBounds();
            int xOff = frameBounds.width / 8;
            int yOff = frameBounds.height / 8;
            JBInsets.removeFrom((Rectangle)frameBounds, (Insets)new Insets(yOff, xOff, yOff, xOff));
            this.myDefaultFrameInfo.setBounds(frameBounds);
        }
        frame.setBounds(frameBounds);
        frame.setExtendedState(this.myDefaultFrameInfo.getExtendedState());
        frame.setVisible(true);
        this.addFrameStateListener(frame);
    }

    @Override
    public final IdeFrameImpl allocateFrame(Project project2) {
        Rectangle bounds;
        FrameInfo frameInfo;
        boolean addComponentListener;
        LOG.assertTrue(!this.myProjectToFrame.containsKey(project2));
        IdeFrameImpl frame = this.myProjectToFrame.remove(null);
        if (frame == null) {
            frame = new IdeFrameImpl(ApplicationInfoEx.getInstanceEx(), this.myActionManager, this.myDataManager, ApplicationManager.getApplication());
        }
        boolean bl = addComponentListener = (frameInfo = ProjectFrameBounds.getInstance(project2).getRawFrameInfo()) == null;
        if (frameInfo != null && frameInfo.getBounds() != null) {
            this.myDefaultFrameInfo.copyFrom(frameInfo);
            Rectangle rawBounds = frameInfo.getBounds();
            this.myDefaultFrameInfo.setBounds(FrameBoundsConverter.convertFromDeviceSpace(rawBounds));
        }
        if ((bounds = this.myDefaultFrameInfo.getBounds()) != null) {
            frame.setBounds(bounds);
        }
        frame.setExtendedState(this.myDefaultFrameInfo.getExtendedState());
        frame.setProject(project2);
        this.myProjectToFrame.put(project2, frame);
        frame.setVisible(true);
        frame.addWindowListener(this.myActivationListener);
        if (addComponentListener) {
            if (RecentProjectsManagerBase.getInstanceEx().isBatchOpening()) {
                frame.toBack();
            }
            this.addFrameStateListener(frame);
        }
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).frameCreated((IdeFrame)frame);
        return frame;
    }

    private void addFrameStateListener(final @NotNull IdeFrameImpl frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FRAME_ELEMENT, "com/intellij/openapi/wm/impl/WindowManagerImpl", "addFrameStateListener"));
        }
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/WindowManagerImpl$4", "componentMoved"));
                }
                WindowManagerImpl.this.updateFrameBounds(frame);
            }
        });
    }

    private void proceedDialogDisposalQueue(Project project2) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project2);
        if (dialogs == null) {
            return;
        }
        for (JDialog dialog2 : dialogs) {
            dialog2.dispose();
        }
        this.myDialogsToDispose.put(project2, null);
    }

    private void queueForDisposal(JDialog dialog2, Project project2) {
        Set<JDialog> dialogs = this.myDialogsToDispose.get(project2);
        if (dialogs == null) {
            dialogs = new HashSet<JDialog>();
            this.myDialogsToDispose.put(project2, dialogs);
        }
        dialogs.add(dialog2);
    }

    @Override
    public final void releaseFrame(IdeFrameImpl frame) {
        ((WindowManagerListener)this.myEventDispatcher.getMulticaster()).beforeFrameReleased((IdeFrame)frame);
        Project project2 = frame.getProject();
        LOG.assertTrue(project2 != null);
        frame.removeWindowListener(this.myActivationListener);
        this.proceedDialogDisposalQueue(project2);
        frame.setProject(null);
        frame.setTitle(null);
        frame.setFileTitle(null, null);
        this.myProjectToFrame.remove(project2);
        if (this.myProjectToFrame.isEmpty()) {
            this.myProjectToFrame.put(null, frame);
        } else {
            Disposer.dispose((Disposable)frame.getStatusBar());
            frame.dispose();
        }
    }

    public final void disposeRootFrame() {
        IdeFrameImpl rootFrame;
        if (this.myProjectToFrame.size() == 1 && (rootFrame = this.myProjectToFrame.remove(null)) != null) {
            rootFrame.dispose();
        }
    }

    @Override
    public final Window getMostRecentFocusedWindow() {
        return this.myWindowWatcher.getFocusedWindow();
    }

    @Override
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getFocusedComponent"));
        }
        return this.myWindowWatcher.getFocusedComponent(window);
    }

    @Override
    @Nullable
    public final Component getFocusedComponent(@Nullable Project project2) {
        return this.myWindowWatcher.getFocusedComponent(project2);
    }

    @Override
    @NotNull
    public final CommandProcessor getCommandProcessor() {
        CommandProcessor commandProcessor = this.myCommandProcessor;
        if (commandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getCommandProcessor"));
        }
        return commandProcessor;
    }

    public void loadState(Element state) {
        Element desktopElement;
        Element frameElement = state.getChild(FRAME_ELEMENT);
        if (frameElement != null) {
            int frameExtendedState = StringUtil.parseInt((String)frameElement.getAttributeValue(EXTENDED_STATE_ATTR), (int)0);
            if ((frameExtendedState & 1) > 0) {
                frameExtendedState = 0;
            }
            this.myDefaultFrameInfo.setBounds(WindowManagerImpl.loadFrameBounds(frameElement));
            this.myDefaultFrameInfo.setExtendedState(frameExtendedState);
        }
        if ((desktopElement = state.getChild("layout")) != null) {
            this.myLayout.readExternal(desktopElement);
        }
    }

    @Nullable
    private static Rectangle loadFrameBounds(@NotNull Element frameElement) {
        if (frameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameElement", "com/intellij/openapi/wm/impl/WindowManagerImpl", "loadFrameBounds"));
        }
        Rectangle bounds = ProjectFrameBoundsKt.deserializeBounds(frameElement);
        return bounds == null ? null : FrameBoundsConverter.convertFromDeviceSpace(bounds);
    }

    @Nullable
    public Element getState() {
        Element frameState = this.getFrameState();
        if (frameState == null) {
            return null;
        }
        Element state = new Element("state");
        state.addContent(frameState);
        Element layoutElement = this.myLayout.writeExternal("layout");
        if (layoutElement != null) {
            state.addContent(layoutElement);
        }
        return state;
    }

    @Nullable
    private Element getFrameState() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        Project project2 = projects[0];
        FrameInfo frameInfo = ProjectFrameBoundsKt.getFrameInfoInDeviceSpace(this, project2);
        if (frameInfo == null) {
            return null;
        }
        Element frameElement = new Element(FRAME_ELEMENT);
        Rectangle rectangle = frameInfo.getBounds();
        if (rectangle != null) {
            ProjectFrameBoundsKt.serializeBounds(rectangle, frameElement);
        }
        if (frameInfo.getExtendedState() != 0) {
            frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(frameInfo.getExtendedState()));
        }
        return frameElement;
    }

    int updateFrameBounds(@NotNull IdeFrameImpl frame) {
        boolean usePreviousBounds;
        ComponentPeer peer;
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FRAME_ELEMENT, "com/intellij/openapi/wm/impl/WindowManagerImpl", "updateFrameBounds"));
        }
        int extendedState = frame.getExtendedState();
        if (SystemInfo.isMacOSLion && (peer = frame.getPeer()) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isMaximized = FrameState.isMaximized(extendedState) || this.isFullScreenSupportedInCurrentOS() && frame.isInFullScreen();
        Rectangle frameBounds = this.myDefaultFrameInfo.getBounds();
        boolean bl = usePreviousBounds = isMaximized && frameBounds != null && frame.getBounds().contains(new Point((int)frameBounds.getCenterX(), (int)frameBounds.getCenterY()));
        if (!usePreviousBounds) {
            this.myDefaultFrameInfo.setBounds(frame.getBounds());
        }
        return extendedState;
    }

    @Override
    public final DesktopLayout getLayout() {
        return this.myLayout;
    }

    @Override
    public final void setLayout(DesktopLayout layout) {
        this.myLayout.copyFrom(layout);
    }

    @NotNull
    public final String getComponentName() {
        if ("WindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/WindowManagerImpl", "getComponentName"));
        }
        return "WindowManager";
    }

    public WindowWatcher getWindowWatcher() {
        return this.myWindowWatcher;
    }

    public boolean isFullScreenSupportedInCurrentOS() {
        return SystemInfo.isMacOSLion || SystemInfo.isWindows || SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported();
    }

    public static boolean isFloatingMenuBarSupported() {
        return !SystemInfo.isMac && WindowManagerImpl.getInstance().isFullScreenSupportedInCurrentOS();
    }

    static {
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable t) {
            LOG.info("jawt failed to load", t);
        }
    }

    static class FrameBoundsConverter {
        FrameBoundsConverter() {
        }

        public static Rectangle convertFromDeviceSpace(@NotNull Rectangle bounds) {
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "convertFromDeviceSpace"));
            }
            Rectangle b = bounds.getBounds();
            if (!FrameBoundsConverter.shouldConvert()) {
                return b;
            }
            try {
                for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    Rectangle devBounds = gd.getDefaultConfiguration().getBounds();
                    FrameBoundsConverter.scaleUp(devBounds, gd.getDefaultConfiguration());
                    Rectangle2D.Float devBounds2D = new Rectangle2D.Float(devBounds.x, devBounds.y, devBounds.width, devBounds.height);
                    Point2D.Float center2d = new Point2D.Float(b.x + b.width / 2, b.y + b.height / 2);
                    if (!devBounds2D.contains(center2d)) continue;
                    FrameBoundsConverter.scaleDown(b, gd.getDefaultConfiguration());
                    break;
                }
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            return b;
        }

        public static Rectangle convertToDeviceSpace(GraphicsConfiguration gc, @NotNull Rectangle bounds) {
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "convertToDeviceSpace"));
            }
            Rectangle b = bounds.getBounds();
            if (!FrameBoundsConverter.shouldConvert()) {
                return b;
            }
            try {
                FrameBoundsConverter.scaleUp(b, gc);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            return b;
        }

        private static boolean shouldConvert() {
            if (SystemInfo.isLinux || SystemInfo.isMac) {
                return false;
            }
            return UIUtil.isJreHiDPIEnabled();
        }

        private static void scaleUp(@NotNull Rectangle bounds, @NotNull GraphicsConfiguration gc) {
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scaleUp"));
            }
            if (gc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scaleUp"));
            }
            FrameBoundsConverter.scale(bounds, gc.getBounds(), JBUI.sysScale((GraphicsConfiguration)gc));
        }

        private static void scaleDown(@NotNull Rectangle bounds, @NotNull GraphicsConfiguration gc) {
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scaleDown"));
            }
            if (gc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scaleDown"));
            }
            float scale = JBUI.sysScale((GraphicsConfiguration)gc);
            assert (scale != 0.0f);
            FrameBoundsConverter.scale(bounds, gc.getBounds(), 1.0f / scale);
        }

        private static void scale(@NotNull Rectangle bounds, @NotNull Rectangle deviceBounds, float scale) {
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scale"));
            }
            if (deviceBounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceBounds", "com/intellij/openapi/wm/impl/WindowManagerImpl$FrameBoundsConverter", "scale"));
            }
            int x = (int)Math.floor((float)deviceBounds.x + (float)(bounds.x - deviceBounds.x) * scale);
            int y = (int)Math.floor((float)deviceBounds.y + (float)(bounds.y - deviceBounds.y) * scale);
            bounds.setBounds(x, y, (int)Math.ceil((float)bounds.width * scale), (int)Math.ceil((float)bounds.height * scale));
        }
    }
}

