/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiFile;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleNode
extends PackageDependenciesNode
implements NavigatableWithText {
    @NotNull
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;

    public ModuleNode(@NotNull Module module2, @Nullable ModuleGrouper moduleGrouper) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/packageDependencies/ui/ModuleNode", "<init>"));
        }
        super(module2.getProject());
        this.myModule = module2;
        this.myModuleGrouper = moduleGrouper;
    }

    @Override
    public void fillFiles(Set<PsiFile> set2, boolean recursively) {
        super.fillFiles(set2, recursively);
        int count = this.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i2);
            child.fillFiles(set2, true);
        }
    }

    @Override
    public boolean canNavigate() {
        return !this.myModule.isDisposed();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean focus) {
        ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
    }

    @Override
    public Icon getIcon() {
        return this.myModule.isDisposed() ? super.getIcon() : ModuleType.get((Module)this.myModule).getIcon();
    }

    @Override
    public String toString() {
        return this.myModuleGrouper != null ? this.myModuleGrouper.getShortenedName(this.myModule) : this.myModule.getName();
    }

    public String getModuleName() {
        return this.myModule.getName();
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/ModuleNode", "getModule"));
        }
        return module2;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleNode)) {
            return false;
        }
        ModuleNode moduleNode = (ModuleNode)o;
        return Comparing.equal((Object)this.myModule, (Object)moduleNode.myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @Override
    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }
}

