/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ArtifactBySourceFileFinderImpl
extends ArtifactBySourceFileFinder {
    private CachedValue<MultiValuesMap<VirtualFile, Artifact>> myFile2Artifacts;
    private final Project myProject;

    public ArtifactBySourceFileFinderImpl(Project project2) {
        this.myProject = project2;
    }

    public CachedValue<MultiValuesMap<VirtualFile, Artifact>> getFileToArtifactsMap() {
        if (this.myFile2Artifacts == null) {
            this.myFile2Artifacts = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                MultiValuesMap<VirtualFile, Artifact> result2 = this.computeFileToArtifactsMap();
                ArrayList<ModificationTracker> trackers = new ArrayList<ModificationTracker>();
                trackers.add(ArtifactManager.getInstance((Project)this.myProject).getModificationTracker());
                for (ComplexPackagingElementType type2 : PackagingElementFactory.getInstance().getComplexElementTypes()) {
                    ContainerUtil.addIfNotNull(trackers, (Object)type2.getAllSubstitutionsModificationTracker(this.myProject));
                }
                return CachedValueProvider.Result.create(result2, (Object[])trackers.toArray(new ModificationTracker[trackers.size()]));
            }, false);
        }
        return this.myFile2Artifacts;
    }

    private MultiValuesMap<VirtualFile, Artifact> computeFileToArtifactsMap() {
        final MultiValuesMap result2 = new MultiValuesMap();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        for (final Artifact artifact : artifactManager.getArtifacts()) {
            final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$1", "process"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$1", "process"));
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null) {
                            result2.put((Object)root, (Object)artifact);
                        }
                    } else if (element instanceof ModuleOutputPackagingElement) {
                        for (VirtualFile sourceRoot : ((ModuleOutputPackagingElement)element).getSourceRoots(context)) {
                            result2.put((Object)sourceRoot, (Object)artifact);
                        }
                    }
                    return true;
                }
            }, context, true);
        }
        return result2;
    }

    @Override
    public Collection<? extends Artifact> findArtifacts(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl", "findArtifacts"));
        }
        MultiValuesMap map2 = (MultiValuesMap)this.getFileToArtifactsMap().getValue();
        if (map2.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = null;
        for (VirtualFile file2 = sourceFile; file2 != null; file2 = file2.getParent()) {
            Collection artifacts = map2.get((Object)file2);
            if (artifacts == null) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.addAll(artifacts);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }
}

