/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryElementType
extends PackagingElementType<ExtractedDirectoryPackagingElement> {
    ExtractedDirectoryElementType() {
        super("extracted-dir", "Extracted Directory");
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.ExtractedFolder;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "canCreate"));
        }
        return true;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "chooseAndCreate"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, true, false, true, true){

            public boolean isFileSelectable(VirtualFile file2) {
                if (file2.isInLocalFileSystem() && file2.isDirectory()) {
                    return false;
                }
                return super.isFileSelectable(file2);
            }
        };
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)context.getProject(), null);
        ArrayList<PackagingElement> list2 = new ArrayList<PackagingElement>();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (VirtualFile file2 : files) {
            list2.add(factory.createExtractedDirectory(file2));
        }
        ArrayList<PackagingElement> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "chooseAndCreate"));
        }
        return arrayList;
    }

    @NotNull
    public ExtractedDirectoryPackagingElement createEmpty(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "createEmpty"));
        }
        ExtractedDirectoryPackagingElement extractedDirectoryPackagingElement = new ExtractedDirectoryPackagingElement();
        if (extractedDirectoryPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ExtractedDirectoryElementType", "createEmpty"));
        }
        return extractedDirectoryPackagingElement;
    }
}

