/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.SeverityState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRenderer
extends ComboBoxTableRenderer<SeverityState> {
    private final Runnable myOnClose;
    private Icon myDisabledIcon;

    public SeverityRenderer(SeverityState[] values, @Nullable Runnable onClose) {
        super((Object[])values);
        this.myOnClose = onClose;
        this.myDisabledIcon = HighlightDisplayLevel.createIconByMask((Color)UIUtil.getLabelDisabledForeground());
    }

    public static SeverityRenderer create(InspectionProfileImpl inspectionProfile, @Nullable Runnable onClose) {
        List<HighlightSeverity> severities = LevelChooserAction.getSeverities(inspectionProfile.getProfileManager().getOwnSeverityRegistrar());
        return new SeverityRenderer((SeverityState[])ContainerUtil.map2Array(severities, (Object[])new SeverityState[severities.size()], severity -> new SeverityState((HighlightSeverity)severity, true, false)), onClose);
    }

    public static Icon getIcon(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/profile/codeInspection/ui/table/SeverityRenderer", "getIcon"));
        }
        Icon icon = level.getIcon();
        return icon instanceof HighlightDisplayLevel.ColoredIcon ? new ColorIcon(icon.getIconWidth(), ((HighlightDisplayLevel.ColoredIcon)icon).getColor()) : icon;
    }

    protected void customizeComponent(SeverityState value2, JTable table, boolean isSelected) {
        super.customizeComponent((Object)value2, table, isSelected);
        this.setPaintArrow(value2.isEnabledForEditing());
        this.setEnabled(!value2.isDisabled());
        this.setDisabledIcon(this.myDisabledIcon);
    }

    protected String getTextFor(@NotNull SeverityState value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/profile/codeInspection/ui/table/SeverityRenderer", "getTextFor"));
        }
        return SingleInspectionProfilePanel.renderSeverity(value2.getSeverity());
    }

    protected Icon getIconFor(@NotNull SeverityState value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/profile/codeInspection/ui/table/SeverityRenderer", "getIconFor"));
        }
        return SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)value2.getSeverity()));
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    public void onClosed(LightweightWindowEvent event) {
        super.onClosed(event);
        if (this.myOnClose != null) {
            this.myOnClose.run();
        }
    }
}

