/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.CommentInstruction;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.SimpleInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import org.jetbrains.annotations.NotNull;

class CompositeInstructionClientVisitor
extends InstructionClientVisitor<Object[]> {
    private final InstructionClientVisitor[] myVisitors;

    public CompositeInstructionClientVisitor(InstructionClientVisitor[] visitors) {
        this.myVisitors = visitors;
    }

    @Override
    @NotNull
    public Object[] getResult() {
        Object[] result2 = new Object[this.myVisitors.length];
        for (int i = 0; i < this.myVisitors.length; ++i) {
            InstructionClientVisitor visitor = this.myVisitors[i];
            result2[i] = visitor.getResult();
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/CompositeInstructionClientVisitor", "getResult"));
        }
        return result2;
    }

    @Override
    public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitEmptyInstruction(EmptyInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitEmptyInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCommentInstruction(CommentInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitCommentInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitReadVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitWriteVariableInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitSimpleInstruction(SimpleInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitSimpleInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalBranchingInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitConditionalThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitThrowToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitGoToInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitCallInstruction(instruction, offset, nextOffset);
        }
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
        for (InstructionClientVisitor visitor : this.myVisitors) {
            visitor.visitReturnInstruction(instruction, offset, nextOffset);
        }
    }
}

