/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    @Override
    public boolean replaceDefaultStrategy() {
        return false;
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text2, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        CharSequence charSequence = whiteSpaceText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        return charSequence;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        assert (startElement.getTextRange().contains(startOffset)) : String.format("Element: %s, range: %s, offset: %d", startElement, startElement.getTextRange(), startOffset);
        StringBuilder buffer = new StringBuilder();
        PsiElement current = startElement;
        while (current != null && current.getTextRange().getStartOffset() < endOffset) {
            TextRange range = current.getTextRange();
            String text2 = current.getText();
            if (!StringUtil.isEmpty((String)text2)) {
                int start;
                int n = start = startOffset > range.getStartOffset() ? startOffset - range.getStartOffset() : 0;
                if (start < text2.length()) {
                    int end;
                    int n2 = end = endOffset < range.getEndOffset() ? text2.length() - (range.getEndOffset() - endOffset) : text2.length();
                    if (end > start) {
                        if (start == 0 && end == text2.length()) {
                            buffer.append(text2);
                        } else {
                            buffer.append(text2.substring(start, end));
                        }
                    }
                }
            }
            current = AbstractWhiteSpaceFormattingStrategy.next(current);
        }
        return this.adjustWhiteSpaceIfNecessary(whiteSpaceText, buffer, 0, endOffset - startOffset, codeStyleSettings, null);
    }

    @Nullable
    private static PsiElement next(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "next"));
        }
        for (PsiElement anchor = element; anchor != null; anchor = anchor.getParent()) {
            PsiElement result2 = element.getNextSibling();
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "containsWhitespacesOnly"));
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePrev", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        if (whiteSpaceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceElement", "com/intellij/psi/formatter/AbstractWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        return false;
    }
}

