/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.FormattingModelWithShiftIndentInsideDocumentRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentBasedFormattingModel
implements FormattingModelEx {
    private final Block myRootBlock;
    private final FormattingDocumentModel myDocumentModel;
    @Nullable
    private final FormattingModel myOriginalFormattingModel;
    @NotNull
    private final Document myDocument;
    private final Project myProject;
    private final CodeStyleSettings mySettings;
    private final FileType myFileType;
    private final PsiFile myFile;

    @Deprecated
    public DocumentBasedFormattingModel(Block rootBlock, @NotNull Document document, Project project2, CodeStyleSettings settings, FileType fileType, PsiFile file2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "<init>"));
        }
        this.myRootBlock = rootBlock;
        this.myDocument = document;
        this.myProject = project2;
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myFile = file2;
        this.myDocumentModel = new FormattingDocumentModelImpl(document, file2);
        this.myOriginalFormattingModel = null;
    }

    public DocumentBasedFormattingModel(Block rootBlock, Project project2, CodeStyleSettings settings, FileType fileType, PsiFile file2) {
        this.myRootBlock = rootBlock;
        this.myProject = project2;
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myFile = file2;
        this.myDocumentModel = FormattingDocumentModelImpl.createOn(file2);
        this.myDocument = this.myDocumentModel.getDocument();
        this.myOriginalFormattingModel = null;
    }

    public DocumentBasedFormattingModel(@NotNull FormattingModel originalModel, @NotNull Document document, Project project2, CodeStyleSettings settings, FileType fileType, PsiFile file2) {
        if (originalModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalModel", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "<init>"));
        }
        this.myOriginalFormattingModel = originalModel;
        this.myRootBlock = originalModel.getRootBlock();
        this.myDocument = document;
        this.myProject = project2;
        this.mySettings = settings;
        this.myFileType = fileType;
        this.myFile = file2;
        this.myDocumentModel = new FormattingDocumentModelImpl(document, file2);
    }

    @NotNull
    public Block getRootBlock() {
        Block block = this.myRootBlock;
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "getRootBlock"));
        }
        return block;
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        FormattingDocumentModel formattingDocumentModel = this.myDocumentModel;
        if (formattingDocumentModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "getDocumentModel"));
        }
        return formattingDocumentModel;
    }

    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        return this.replaceWhiteSpace(textRange, null, whiteSpace);
    }

    /*
     * Unable to fully structure code
     */
    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        block10: {
            block9: {
                if (this.myOriginalFormattingModel instanceof FormattingModelWithShiftIndentInsideDocumentRange) {
                    whiteSpace = ((FormattingModelWithShiftIndentInsideDocumentRange)this.myOriginalFormattingModel).adjustWhiteSpaceInsideDocument(nodeAfter, whiteSpace);
                }
                marker = "<![CDATA[";
                if (this.removesPattern(textRange, whiteSpace, "<![CDATA[")) ** GOTO lbl-1000
                marker = "<!--[";
                if (this.removesPattern(textRange, whiteSpace, "<!--[")) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = removesStartMarker = false;
                }
                if (v0) break block9;
                marker = "]]>";
                if (this.removesPattern(textRange, whiteSpace, "]]>")) break block9;
                marker = "]-->";
                if (!this.removesPattern(textRange, whiteSpace, "]-->")) break block10;
            }
            newWs = null;
            if (removesStartMarker) {
                at = CharArrayUtil.indexOf((CharSequence)this.myDocument.getCharsSequence(), (CharSequence)marker, (int)textRange.getStartOffset(), (int)(textRange.getEndOffset() + 1));
                ws = this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset()).toString();
                newWs = DocumentBasedFormattingModel.mergeWsWithCdataMarker(whiteSpace, ws, at - textRange.getStartOffset());
                v1 = newWs != null ? newWs : whiteSpace;
                marker = "]]>";
                if (this.removesPattern(textRange, v1, "]]>") && newWs != null && (i = newWs.lastIndexOf(10)) > 0) {
                    cdataStart = newWs.indexOf("<![CDATA[");
                    i2 = newWs.lastIndexOf(10, cdataStart);
                    cdataIndent = i2 != -1 ? newWs.substring(i2 + 1, cdataStart) : "";
                    newWs = newWs.substring(0, i) + cdataIndent + marker + newWs.substring(i);
                }
            }
            if (newWs == null) {
                return textRange;
            }
            whiteSpace = newWs;
        }
        whiteSpaceToUse = this.getDocumentModel().adjustWhiteSpaceIfNecessary((CharSequence)whiteSpace, textRange.getStartOffset(), textRange.getEndOffset(), nodeAfter, false);
        this.myDocument.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), whiteSpaceToUse);
        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + whiteSpaceToUse.length());
    }

    private boolean removesPattern(TextRange textRange, String whiteSpace, String pattern) {
        return CharArrayUtil.indexOf((CharSequence)this.myDocument.getCharsSequence(), (CharSequence)pattern, (int)textRange.getStartOffset(), (int)(textRange.getEndOffset() + 1)) >= 0 && CharArrayUtil.indexOf((CharSequence)whiteSpace, (CharSequence)pattern, (int)0) < 0;
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange range, int indent) {
        TextRange newRange;
        if (this.myOriginalFormattingModel instanceof FormattingModelWithShiftIndentInsideDocumentRange && (newRange = ((FormattingModelWithShiftIndentInsideDocumentRange)this.myOriginalFormattingModel).shiftIndentInsideDocumentRange(this.myDocument, node, range, indent)) != null) {
            return newRange;
        }
        int newLength = this.shiftIndentInside(range, indent);
        return new TextRange(range.getStartOffset(), range.getStartOffset() + newLength);
    }

    public void commitChanges() {
        CodeEditUtil.allowToMarkNodesForPostponedFormatting(false);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        }
        finally {
            CodeEditUtil.allowToMarkNodesForPostponedFormatting(true);
        }
    }

    private int shiftIndentInside(TextRange elementRange, int shift) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder afterWhiteSpace = new StringBuilder();
        int whiteSpaceLength = 0;
        boolean insideWhiteSpace = true;
        int line = 0;
        block5: for (int i2 = elementRange.getStartOffset(); i2 < elementRange.getEndOffset(); ++i2) {
            char c = this.myDocument.getCharsSequence().charAt(i2);
            switch (c) {
                case '\n': {
                    if (line > 0) {
                        this.createWhiteSpace(whiteSpaceLength + shift, buffer);
                    } else {
                        this.createWhiteSpace(whiteSpaceLength, buffer);
                    }
                    buffer.append(afterWhiteSpace.toString());
                    insideWhiteSpace = true;
                    whiteSpaceLength = 0;
                    afterWhiteSpace = new StringBuilder();
                    buffer.append(c);
                    ++line;
                    continue block5;
                }
                case ' ': {
                    if (insideWhiteSpace) {
                        ++whiteSpaceLength;
                        continue block5;
                    }
                    afterWhiteSpace.append(c);
                    continue block5;
                }
                case '\t': {
                    if (insideWhiteSpace) {
                        whiteSpaceLength += this.getIndentOptions().TAB_SIZE;
                        continue block5;
                    }
                    afterWhiteSpace.append(c);
                    continue block5;
                }
                default: {
                    insideWhiteSpace = false;
                    afterWhiteSpace.append(c);
                }
            }
        }
        if (line > 0 && afterWhiteSpace.length() > 0) {
            this.createWhiteSpace(whiteSpaceLength + shift, buffer);
            buffer.append(afterWhiteSpace.toString());
        }
        this.myDocument.replaceString(elementRange.getStartOffset(), elementRange.getEndOffset(), (CharSequence)buffer.toString());
        return buffer.length();
    }

    private void createWhiteSpace(int whiteSpaceLength, StringBuilder buffer) {
        if (whiteSpaceLength < 0) {
            return;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
        if (indentOptions.USE_TAB_CHARACTER) {
            int tabs = whiteSpaceLength / indentOptions.TAB_SIZE;
            int spaces = whiteSpaceLength - tabs * indentOptions.TAB_SIZE;
            StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabs);
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
        } else {
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)whiteSpaceLength);
        }
    }

    private CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.mySettings.getIndentOptions(this.myFileType);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/DocumentBasedFormattingModel", "getDocument"));
        }
        return document;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    @Nullable
    public static String mergeWsWithCdataMarker(String whiteSpace, String s, int cdataPos) {
        int firstCrInGeneratedWs = whiteSpace.indexOf(10);
        int secondCrInGeneratedWs = firstCrInGeneratedWs != -1 ? whiteSpace.indexOf(10, firstCrInGeneratedWs + 1) : -1;
        int firstCrInPreviousWs = s.indexOf(10);
        int secondCrInPreviousWs = firstCrInPreviousWs != -1 ? s.indexOf(10, firstCrInPreviousWs + 1) : -1;
        boolean knowHowToModifyCData = false;
        if (secondCrInPreviousWs != -1 && secondCrInGeneratedWs != -1 && cdataPos > firstCrInPreviousWs && cdataPos < secondCrInPreviousWs) {
            whiteSpace = whiteSpace.substring(0, secondCrInGeneratedWs) + s.substring(firstCrInPreviousWs + 1, secondCrInPreviousWs) + whiteSpace.substring(secondCrInGeneratedWs);
            knowHowToModifyCData = true;
        }
        if (!knowHowToModifyCData) {
            whiteSpace = null;
        }
        return whiteSpace;
    }
}

