/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaBlock;
import com.intellij.psi.formatter.java.JavaSpacePropertyProcessor;
import com.intellij.psi.formatter.java.LeafBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticCodeBlock
implements Block,
JavaBlock {
    private final List<Block> mySubBlocks;
    private final Alignment myAlignment;
    private final Indent myIndentContent;
    private final CommonCodeStyleSettings mySettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myWrap;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.newXmlFormatter.java.SyntheticCodeBlock");
    private final TextRange myTextRange;
    private ChildAttributes myChildAttributes;
    private boolean myIsIncomplete;

    public SyntheticCodeBlock(List<Block> subBlocks, Alignment alignment, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, Indent indent, Wrap wrap) {
        this.myJavaSettings = javaSettings;
        this.myIndentContent = indent;
        if (subBlocks.isEmpty()) {
            LOG.assertTrue(false);
        }
        this.mySubBlocks = new ArrayList<Block>(subBlocks);
        this.myAlignment = alignment;
        this.mySettings = settings;
        this.myWrap = wrap;
        this.myTextRange = new TextRange(this.mySubBlocks.get(0).getTextRange().getStartOffset(), this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticCodeBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list2 = this.mySubBlocks;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticCodeBlock", "getSubBlocks"));
        }
        return list2;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndentContent;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/formatter/java/SyntheticCodeBlock", "getSpacing"));
        }
        return JavaSpacePropertyProcessor.getSpacing(AbstractJavaBlock.getTreeNode(child2), this.mySettings, this.myJavaSettings);
    }

    public String toString() {
        PsiFile file2;
        PsiElement psi;
        ASTNode treeNode = null;
        Block child = this.mySubBlocks.get(0);
        while (treeNode == null) {
            if (child instanceof AbstractBlock) {
                treeNode = ((AbstractBlock)child).getNode();
                continue;
            }
            if (!(child instanceof SyntheticCodeBlock)) break;
            child = ((SyntheticCodeBlock)child).mySubBlocks.get(0);
        }
        TextRange textRange = this.getTextRange();
        if (treeNode != null && (psi = treeNode.getPsi()) != null && (file2 = psi.getContainingFile()) != null) {
            return file2.getText().subSequence(textRange.getStartOffset(), textRange.getEndOffset()) + " " + textRange;
        }
        return this.getClass().getName() + ": " + textRange;
    }

    @Override
    public ASTNode getFirstTreeNode() {
        ASTNode result2 = AbstractJavaBlock.getTreeNode(this.mySubBlocks.get(0));
        assert (result2 != null);
        return result2;
    }

    public void setChildAttributes(ChildAttributes childAttributes) {
        this.myChildAttributes = childAttributes;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myChildAttributes != null) {
            ChildAttributes childAttributes = this.myChildAttributes;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticCodeBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        Alignment alignment = null;
        if (this.mySubBlocks.size() > newChildIndex) {
            Block block = this.mySubBlocks.get(newChildIndex);
            alignment = block.getAlignment();
        } else if (this.mySubBlocks.size() == newChildIndex && SyntheticCodeBlock.isRParenth(this.getRightMostBlock())) {
            alignment = this.getDotAlignment();
        }
        ChildAttributes childAttributes = new ChildAttributes(this.getIndent(), alignment);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SyntheticCodeBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    private static boolean isRParenth(Block sibling) {
        if (sibling instanceof LeafBlock) {
            ASTNode node = ((LeafBlock)sibling).getNode();
            return node != null && node.getElementType() == JavaTokenType.RPARENTH;
        }
        return false;
    }

    @Nullable
    private Alignment getDotAlignment() {
        Block block;
        if (this.mySubBlocks.size() > 1 && SyntheticCodeBlock.isDotFirst(block = this.mySubBlocks.get(1))) {
            return block.getAlignment();
        }
        return null;
    }

    private static boolean isDotFirst(Block block) {
        Block current = block;
        while (!current.getSubBlocks().isEmpty()) {
            current = (Block)block.getSubBlocks().get(0);
        }
        ASTNode node = current instanceof LeafBlock ? ((LeafBlock)current).getNode() : null;
        return node != null && node.getElementType() == JavaTokenType.DOT;
    }

    @Nullable
    private Block getRightMostBlock() {
        Block rightMost = null;
        List subBlocks = this.getSubBlocks();
        while (!subBlocks.isEmpty()) {
            int lastIndex = subBlocks.size() - 1;
            rightMost = subBlocks.get(lastIndex);
            subBlocks = rightMost.getSubBlocks();
        }
        return rightMost;
    }

    public boolean isIncomplete() {
        if (this.myIsIncomplete) {
            return true;
        }
        return this.getSubBlocks().get(this.getSubBlocks().size() - 1).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIsIncomplete(boolean isIncomplete) {
        this.myIsIncomplete = isIncomplete;
    }
}

