/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlBlock
extends AbstractBlock {
    protected XmlFormattingPolicy myXmlFormattingPolicy;
    protected final XmlInjectedLanguageBlockBuilder myInjectedBlockBuilder;
    private final boolean myPreserveSpace;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.AbstractXmlBlock");

    protected AbstractXmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy) {
        this(node, wrap, alignment, policy, false);
    }

    protected AbstractXmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, boolean preserveSpace) {
        super(node, wrap, alignment);
        this.myXmlFormattingPolicy = policy;
        if (node.getTreeParent() == null) {
            this.myXmlFormattingPolicy.setRootBlock(node, (Block)this);
        }
        this.myInjectedBlockBuilder = new XmlInjectedLanguageBlockBuilder(this.myXmlFormattingPolicy);
        this.myPreserveSpace = AbstractXmlBlock.shouldPreserveSpace(node, preserveSpace);
    }

    private static boolean shouldPreserveSpace(ASTNode node, boolean defaultValue) {
        XmlAttribute spaceAttr;
        XmlTag tag;
        if (node.getPsi() instanceof XmlTag && (tag = (XmlTag)node.getPsi()) != null && (spaceAttr = tag.getAttribute("xml:space")) != null) {
            String value2 = spaceAttr.getValue();
            if ("preserve".equals(value2)) {
                return true;
            }
            if ("default".equals(value2)) {
                return false;
            }
        }
        return defaultValue;
    }

    public boolean isPreserveSpace() {
        return this.myPreserveSpace;
    }

    public static WrapType getWrapType(int type2) {
        if (type2 == 0) {
            return WrapType.NONE;
        }
        if (type2 == 2) {
            return WrapType.ALWAYS;
        }
        if (type2 == 1) {
            return WrapType.NORMAL;
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }

    protected Alignment chooseAlignment(ASTNode child, Alignment attrAlignment, Alignment textAlignment) {
        if (this.myNode.getElementType() == XmlElementType.XML_TEXT) {
            return this.getAlignment();
        }
        IElementType elementType = child.getElementType();
        if (elementType == XmlElementType.XML_ATTRIBUTE && this.myXmlFormattingPolicy.getShouldAlignAttributes()) {
            return attrAlignment;
        }
        if (elementType == XmlElementType.XML_TEXT && this.myXmlFormattingPolicy.getShouldAlignText()) {
            return textAlignment;
        }
        return null;
    }

    private Wrap getTagEndWrapping(XmlTag parent) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagEnd(parent), (boolean)true);
    }

    protected Wrap chooseWrap(ASTNode child, Wrap tagBeginWrap, Wrap attrWrap, Wrap textWrap) {
        if (this.myNode.getElementType() == XmlElementType.XML_TEXT) {
            return textWrap;
        }
        IElementType elementType = child.getElementType();
        if (elementType == XmlElementType.XML_ATTRIBUTE) {
            return attrWrap;
        }
        if (elementType == XmlTokenType.XML_START_TAG_START) {
            return tagBeginWrap;
        }
        if (elementType == XmlTokenType.XML_END_TAG_START) {
            XmlTag tag;
            PsiElement parent = SourceTreeToPsiMap.treeElementToPsi(child.getTreeParent());
            if (parent instanceof XmlTag && this.canWrapTagEnd(tag = (XmlTag)parent)) {
                return this.getTagEndWrapping(tag);
            }
            return null;
        }
        if (elementType == XmlElementType.XML_TEXT || elementType == XmlTokenType.XML_DATA_CHARACTERS) {
            return textWrap;
        }
        return null;
    }

    protected boolean canWrapTagEnd(XmlTag tag) {
        return tag.getSubTags().length > 0;
    }

    protected XmlTag getTag() {
        return AbstractXmlBlock.getTag(this.myNode);
    }

    protected static XmlTag getTag(ASTNode node) {
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        if (element instanceof XmlTag) {
            return (XmlTag)element;
        }
        return null;
    }

    protected Wrap createTagBeginWrapping(XmlTag tag) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag), (boolean)true);
    }

    @Nullable
    protected ASTNode processChild(List<Block> result2, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        PsiElement childPsi;
        Language childLanguage;
        Language myLanguage = this.myNode.getPsi().getLanguage();
        if (this.useMyFormatter(myLanguage, childLanguage = (childPsi = child.getPsi()).getLanguage(), childPsi)) {
            XmlTag tag = this.getAnotherTreeTag(child);
            if (tag != null && this.containsTag((PsiElement)tag) && this.doesNotIntersectSubTagsWith((PsiElement)tag)) {
                ASTNode currentChild = this.createAnotherTreeNode(result2, child, (PsiElement)tag, indent, wrap, alignment);
                if (currentChild == null) {
                    return null;
                }
                while (currentChild != null && currentChild.getTreeParent() != this.myNode && currentChild.getTreeParent() != child.getTreeParent()) {
                    if ((currentChild = this.processAllChildrenFrom(result2, currentChild, wrap, alignment, indent)) != null && (currentChild.getTreeParent() == this.myNode || currentChild.getTreeParent() == child.getTreeParent())) {
                        return currentChild;
                    }
                    if (currentChild == null) continue;
                    currentChild = currentChild.getTreeParent();
                }
                return currentChild;
            }
            this.processSimpleChild(child, indent, result2, wrap, alignment);
            return child;
        }
        if (!this.isBuildIndentsOnly()) {
            this.myInjectedBlockBuilder.addInjectedLanguageBlockWrapper(result2, child, indent, 0, null);
        }
        return child;
    }

    protected boolean doesNotIntersectSubTagsWith(PsiElement tag) {
        XmlTag[] subTags;
        TextRange tagRange = tag.getTextRange();
        for (XmlTag subTag : subTags = this.getSubTags()) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < tagRange.getStartOffset()) continue;
            if (subTagRange.getStartOffset() > tagRange.getEndOffset()) {
                return true;
            }
            if (tagRange.getStartOffset() > subTagRange.getStartOffset() && tagRange.getEndOffset() < subTagRange.getEndOffset()) {
                return false;
            }
            if (tagRange.getEndOffset() <= subTagRange.getStartOffset() || tagRange.getEndOffset() >= subTagRange.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    private XmlTag[] getSubTags() {
        if (this.myNode instanceof XmlTag) {
            return ((XmlTag)this.myNode.getPsi()).getSubTags();
        }
        if (this.myNode.getPsi() instanceof XmlElement) {
            return AbstractXmlBlock.collectSubTags((XmlElement)this.myNode.getPsi());
        }
        return XmlTag.EMPTY;
    }

    private static XmlTag[] collectSubTags(XmlElement node) {
        final ArrayList result2 = new ArrayList();
        node.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/formatter/xml/AbstractXmlBlock$1", "execute"));
                }
                if (element instanceof XmlTag) {
                    result2.add((XmlTag)element);
                }
                return true;
            }
        }, (PsiElement)node);
        return result2.toArray(new XmlTag[result2.size()]);
    }

    protected boolean containsTag(PsiElement tag) {
        ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myNode);
        ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(this.myNode);
        if (closingTagStart == null && startTagStart == null) {
            return tag.getTextRange().getEndOffset() <= this.myNode.getTextRange().getEndOffset();
        }
        if (closingTagStart == null) {
            return false;
        }
        return tag.getTextRange().getEndOffset() <= closingTagStart.getTextRange().getEndOffset();
    }

    private ASTNode processAllChildrenFrom(List<Block> result2, @NotNull ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/xml/AbstractXmlBlock", "processAllChildrenFrom"));
        }
        ASTNode resultNode = child;
        ASTNode currentChild = child.getTreeNext();
        while (currentChild != null && currentChild.getElementType() != XmlTokenType.XML_END_TAG_START) {
            if (!AbstractXmlBlock.containsWhiteSpacesOnly(currentChild)) {
                resultNode = currentChild = this.processChild(result2, currentChild, wrap, alignment, indent);
            }
            if (currentChild == null) continue;
            currentChild = currentChild.getTreeNext();
        }
        return resultNode;
    }

    protected void processSimpleChild(ASTNode child, Indent indent, List<Block> result2, Wrap wrap, Alignment alignment) {
        if (this.isXmlTag(child)) {
            result2.add((Block)this.createTagBlock(child, indent != null ? indent : Indent.getNoneIndent(), wrap, alignment));
        } else if (child.getElementType() == XmlElementType.XML_DOCTYPE) {
            result2.add((Block)new XmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null, this.isPreserveSpace()){

                @Override
                protected Wrap getDefaultWrap(ASTNode node) {
                    IElementType type2 = node.getElementType();
                    return type2 == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? Wrap.createWrap((WrapType)2.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false) : null;
                }
            });
        } else {
            result2.add((Block)this.createSimpleChild(child, indent, wrap, alignment));
        }
    }

    protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new XmlBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, null, this.isPreserveSpace());
    }

    protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        return new XmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
    }

    @Nullable
    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return null;
    }

    @Nullable
    protected ASTNode createAnotherTreeNode(List<Block> result2, ASTNode child, PsiElement tag, Indent indent, Wrap wrap, Alignment alignment) {
        return null;
    }

    @Nullable
    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        return null;
    }

    protected XmlFormattingPolicy createPolicyFor() {
        return this.myXmlFormattingPolicy;
    }

    @Nullable
    protected XmlTag getAnotherTreeTag(ASTNode child) {
        return null;
    }

    protected boolean isXmlTag(ASTNode child) {
        return this.isXmlTag(child.getPsi());
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag;
    }

    protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
        if (myLanguage == childLanguage || childLanguage == StdFileTypes.HTML.getLanguage() || childLanguage == StdFileTypes.XHTML.getLanguage() || childLanguage == StdFileTypes.XML.getLanguage()) {
            return true;
        }
        FormattingModelBuilder childFormatter = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(childLanguage);
        return childFormatter == null || childFormatter instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)childFormatter).dontFormatMyModel();
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        return false;
    }

    public abstract boolean insertLineBreakBeforeTag();

    public int getBlankLinesBeforeTag() {
        return this.insertLineBreakBeforeTag() ? 1 : 0;
    }

    public abstract boolean removeLineBreakBeforeTag();

    protected Spacing createDefaultSpace(boolean forceKeepLineBreaks, boolean inText) {
        boolean shouldKeepLineBreaks = this.getShouldKeepLineBreaks(inText, forceKeepLineBreaks);
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)shouldKeepLineBreaks, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean getShouldKeepLineBreaks(boolean inText, boolean forceKeepLineBreaks) {
        if (forceKeepLineBreaks) {
            return true;
        }
        if (inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText()) {
            return true;
        }
        return !inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaks();
    }

    public abstract boolean isTextElement();

    protected void createJspTextNode(List<Block> localResult, ASTNode child, Indent indent) {
    }

    @Nullable
    protected static ASTNode findChildAfter(@NotNull ASTNode child, int endOffset) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/xml/AbstractXmlBlock", "findChildAfter"));
        }
        FileElement fileNode = TreeUtil.getFileElement((TreeElement)child);
        LeafElement leaf = ((TreeElement)fileNode).findLeafElementAt(endOffset);
        if (leaf != null && leaf.getStartOffset() == endOffset && endOffset > 0) {
            return ((TreeElement)fileNode).findLeafElementAt(endOffset - 1);
        }
        return leaf;
    }

    public boolean isLeaf() {
        return AbstractXmlBlock.isComment(this.myNode) || this.myNode.getElementType() == TokenType.WHITE_SPACE || this.myNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
    }

    protected boolean buildInjectedPsiBlocks(List<Block> result2, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        if (this.isBuildIndentsOnly()) {
            return false;
        }
        if (this.myInjectedBlockBuilder.addInjectedBlocks(result2, child, wrap, alignment, indent)) {
            return true;
        }
        PsiFile containingFile = child.getPsi().getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            Language templateLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
            PsiElement at = fileViewProvider.findElementAt(child.getStartOffset(), templateLanguage);
            if (at instanceof XmlToken) {
                at = at.getParent();
            }
            if (at instanceof PsiComment && at.getTextRange().equals((Object)child.getTextRange()) && at.getNode() != child) {
                return this.buildInjectedPsiBlocks(result2, at.getNode(), wrap, alignment, indent);
            }
        }
        return false;
    }

    public boolean isCDATAStart() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_START;
    }

    public boolean isCDATAEnd() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_END;
    }

    public static boolean containsWhiteSpacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/xml/AbstractXmlBlock", "containsWhiteSpacesOnly"));
        }
        PsiElement psiElement = node.getPsi();
        if (psiElement instanceof PsiWhiteSpace) {
            return true;
        }
        Language nodeLang = psiElement.getLanguage();
        if (!nodeLang.isKindOf((Language)XMLLanguage.INSTANCE) || AbstractXmlBlock.isTextOnlyNode(node) || node.getElementType() == XmlElementType.XML_PROLOG) {
            WhiteSpaceFormattingStrategy strategy = WhiteSpaceFormattingStrategyFactory.getStrategy(nodeLang);
            int length = node.getTextLength();
            return strategy.check(node.getChars(), 0, length) >= length;
        }
        return false;
    }

    private static boolean isTextOnlyNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/formatter/xml/AbstractXmlBlock", "isTextOnlyNode"));
        }
        if (node.getPsi() instanceof XmlText) {
            return true;
        }
        ASTNode firstChild = node.getFirstChildNode();
        ASTNode lastChild = node.getLastChildNode();
        return firstChild != null && firstChild == lastChild && firstChild.getPsi() instanceof XmlText;
    }
}

