/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ConstantExpressionVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = ObjectUtils.NULL;
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = () -> {
        ConcurrentMap value2 = ContainerUtil.createConcurrentSoftMap();
        return CachedValueProvider.Result.create((Object)value2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, @NotNull Project project2, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "<init>"));
        }
        this.myMapFactory = auxEvaluator == null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            public ConcurrentMap<PsiElement, Object> create() {
                Key key2 = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager((Project)JavaConstantExpressionEvaluator.this.myProject).getCachedValue((UserDataHolder)JavaConstantExpressionEvaluator.this.myProject, key2, PROVIDER, false);
            }
        } : () -> auxEvaluator.getCacheMap(throwExceptionOnOverflow);
        this.myProject = project2;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "elementFinished"));
        }
        Object value2 = this.getCached(element);
        if (value2 == null) {
            Object result2 = this.myConstantExpressionVisitor.handle(element);
            this.cache(element, result2);
        } else {
            this.myConstantExpressionVisitor.store(element, value2 == NO_VALUE ? null : value2);
        }
    }

    public void visitElement(PsiElement element) {
        Object value2 = this.getCached(element);
        if (value2 == null) {
            super.visitElement(element);
        } else {
            this.myConstantExpressionVisitor.store(element, value2 == NO_VALUE ? null : value2);
        }
    }

    private Object getCached(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "getCached"));
        }
        return this.map().get(element);
    }

    private Object cache(@NotNull PsiElement element, @Nullable Object value2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "cache"));
        }
        value2 = ConcurrencyUtil.cacheOrGet(this.map(), (Object)element, (Object)(value2 == null ? NO_VALUE : value2));
        if (value2 == NO_VALUE) {
            value2 = null;
        }
        return value2;
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.myMapFactory.create();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaConstantExpressionEvaluator", "map"));
        }
        return concurrentMap;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)expression2).getValue();
        }
        JavaConstantExpressionEvaluator evaluator = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression2.getProject(), auxEvaluator);
        if (expression2 instanceof PsiCompiledElement) {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiExpression operand2 = ((PsiPrefixExpression)expression2).getOperand();
                if (operand2 == null) {
                    return null;
                }
                Object value2 = evaluator.myConstantExpressionVisitor.handle((PsiElement)operand2);
                evaluator.myConstantExpressionVisitor.store((PsiElement)operand2, value2);
            }
            return evaluator.myConstantExpressionVisitor.handle((PsiElement)expression2);
        }
        expression2.accept((PsiElementVisitor)evaluator);
        Object cached = evaluator.getCached((PsiElement)expression2);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, null, throwExceptionOnOverflow);
    }
}

