/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.Locale;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRegExpHost
implements RegExpLanguageHost {
    protected static final EnumSet<RegExpGroup.Type> SUPPORTED_NAMED_GROUP_TYPES = EnumSet.of(RegExpGroup.Type.NAMED_GROUP);
    private final DefaultRegExpPropertiesProvider myPropertiesProvider;
    private final String[][] myPropertyNames = new String[][]{{"Cn", "Unassigned"}, {"Lu", "Uppercase letter"}, {"Ll", "Lowercase letter"}, {"Lt", "Titlecase letter"}, {"Lm", "Modifier letter"}, {"Lo", "Other letter"}, {"Mn", "Non spacing mark"}, {"Me", "Enclosing mark"}, {"Mc", "Combining spacing mark"}, {"Nd", "Decimal digit number"}, {"Nl", "Letter number"}, {"No", "Other number"}, {"Zs", "Space separator"}, {"Zl", "Line separator"}, {"Zp", "Paragraph separator"}, {"Cc", "Control"}, {"Cf", "Format"}, {"Co", "Private use"}, {"Cs", "Surrogate"}, {"Pd", "Dash punctuation"}, {"Ps", "Start punctuation"}, {"Pe", "End punctuation"}, {"Pc", "Connector punctuation"}, {"Po", "Other punctuation"}, {"Sm", "Math symbol"}, {"Sc", "Currency symbol"}, {"Sk", "Modifier symbol"}, {"So", "Other symbol"}, {"Pi", "Initial quote punctuation"}, {"Pf", "Final quote punctuation"}, {"L", "Letter"}, {"M", "Mark"}, {"N", "Number"}, {"Z", "Separator"}, {"C", "Control"}, {"P", "Punctuation"}, {"S", "Symbol"}, {"LC", "Letter"}, {"LD", "Letter or digit"}, {"L1", "Latin-1"}, {"all", "All"}, {"ASCII", "Ascii"}, {"Alnum", "Alphanumeric characters"}, {"Alpha", "Alphabetic characters"}, {"Blank", "Space and tab characters"}, {"Cntrl", "Control characters"}, {"Digit", "Numeric characters"}, {"Graph", "Printable and visible"}, {"Lower", "Lowercase Alphabetic"}, {"Print", "Printable characters"}, {"Punct", "Punctuation characters"}, {"Space", "Space characters"}, {"Upper", "Uppercase alphabetic"}, {"XDigit", "Hexadecimal digits"}, {"javaLowerCase"}, {"javaUpperCase"}, {"javaTitleCase"}, {"javaAlphabetic"}, {"javaIdeographic"}, {"javaDigit"}, {"javaDefined"}, {"javaLetter"}, {"javaLetterOrDigit"}, {"javaJavaIdentifierStart"}, {"javaJavaIdentifierPart"}, {"javaUnicodeIdentifierStart"}, {"javaUnicodeIdentifierPart"}, {"javaIdentifierIgnorable"}, {"javaSpaceChar"}, {"javaWhitespace"}, {"javaISOControl"}, {"javaMirrored"}};

    public JavaRegExpHost() {
        this.myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();
    }

    @Override
    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        switch (flag) {
            case 'd': 
            case 'i': 
            case 'm': 
            case 's': 
            case 'u': 
            case 'x': {
                return true;
            }
            case 'U': {
                return JavaRegExpHost.hasAtLeastJdkVersion(context, JavaSdkVersion.JDK_1_7);
            }
        }
        return false;
    }

    @Override
    public boolean characterNeedsEscaping(char c) {
        return false;
    }

    @Override
    public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return JavaRegExpHost.hasAtLeastJdkVersion(namedCharacter, JavaSdkVersion.JDK_1_9);
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.getType() == RegExpGroup.Type.NAMED_GROUP && JavaRegExpHost.hasAtLeastJdkVersion(group, JavaSdkVersion.JDK_1_7);
    }

    @Override
    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isNamedGroupRef() && JavaRegExpHost.hasAtLeastJdkVersion(ref, JavaSdkVersion.JDK_1_7);
    }

    @Override
    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        if (!JavaRegExpHost.hasAtLeastJdkVersion(context, JavaSdkVersion.JDK_1_7)) {
            EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getSupportedNamedGroupTypes"));
            }
            return enumSet;
        }
        EnumSet<RegExpGroup.Type> enumSet = SUPPORTED_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getSupportedNamedGroupTypes"));
        }
        return enumSet;
    }

    @Override
    public boolean isValidGroupName(String name2, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/JavaRegExpHost", "isValidGroupName"));
        }
        int length = name2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = name2.charAt(i2);
            if (AsciiUtil.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return regExpChar.getUnescapedText().charAt(1) == 'x' && JavaRegExpHost.hasAtLeastJdkVersion(regExpChar, JavaSdkVersion.JDK_1_7);
    }

    @Override
    public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return JavaRegExpHost.hasAtLeastJdkVersion(boundary, JavaSdkVersion.JDK_1_9);
            }
        }
        return true;
    }

    @Override
    public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        switch (simpleClass.getKind()) {
            case UNICODE_LINEBREAK: 
            case HORIZONTAL_SPACE: 
            case NON_HORIZONTAL_SPACE: 
            case NON_VERTICAL_SPACE: {
                return JavaRegExpHost.hasAtLeastJdkVersion(simpleClass, JavaSdkVersion.JDK_1_8);
            }
            case VERTICAL_SPACE: {
                return true;
            }
            case UNICODE_GRAPHEME: {
                return JavaRegExpHost.hasAtLeastJdkVersion(simpleClass, JavaSdkVersion.JDK_1_9);
            }
            case XML_NAME_START: 
            case NON_XML_NAME_START: 
            case XML_NAME_PART: 
            case NON_XML_NAME_PART: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return false;
    }

    private static boolean hasAtLeastJdkVersion(PsiElement element, JavaSdkVersion version) {
        return JavaRegExpHost.getJavaVersion(element).isAtLeast(version);
    }

    @NotNull
    private static JavaSdkVersion getJavaVersion(PsiElement element) {
        JavaSdkVersion version;
        Sdk sdk;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module2 != null && (sdk = ModuleRootManager.getInstance((Module)module2).getSdk()) != null && sdk.getSdkType() instanceof JavaSdk && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getJavaVersion"));
            }
            return javaSdkVersion;
        }
        JavaSdkVersion javaSdkVersion = JavaSdkVersion.JDK_1_9;
        if (javaSdkVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getJavaVersion"));
        }
        return javaSdkVersion;
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidCategory"));
        }
        if (category.startsWith("In")) {
            return this.isValidUnicodeBlock(category);
        }
        if (category.startsWith("Is")) {
            if (this.isValidProperty(category = category.substring(2))) {
                return true;
            }
            switch (category = category.toUpperCase(Locale.ENGLISH)) {
                case "WHITESPACE": 
                case "HEXDIGIT": 
                case "NONCHARACTERCODEPOINT": 
                case "JOINCONTROL": 
                case "ALPHABETIC": 
                case "LETTER": 
                case "IDEOGRAPHIC": 
                case "LOWERCASE": 
                case "UPPERCASE": 
                case "TITLECASE": 
                case "WHITE_SPACE": 
                case "CONTROL": 
                case "PUNCTUATION": 
                case "HEX_DIGIT": 
                case "ASSIGNED": 
                case "NONCHARACTER_CODE_POINT": 
                case "DIGIT": 
                case "ALNUM": 
                case "BLANK": 
                case "GRAPH": 
                case "PRINT": 
                case "WORD": 
                case "JOIN_CONTROL": {
                    return true;
                }
            }
            return this.isValidUnicodeScript(category);
        }
        return this.isValidProperty(category);
    }

    private boolean isValidProperty(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidProperty"));
        }
        for (String[] name2 : this.myPropertyNames) {
            if (!name2[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidUnicodeBlock(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidUnicodeBlock"));
        }
        try {
            return Character.UnicodeBlock.forName(category.substring(2)) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidUnicodeScript(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/psi/impl/JavaRegExpHost", "isValidUnicodeScript"));
        }
        try {
            return Character.UnicodeScript.forName(category) != null;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    @Override
    public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return UnicodeCharacterNames.getCodePoint(namedCharacter.getName()) >= 0;
    }

    @Override
    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookbehindGroup", "com/intellij/psi/impl/JavaRegExpHost", "supportsLookbehind"));
        }
        return RegExpLanguageHost.Lookbehind.FINITE_REPETITION;
    }

    @Override
    public Integer getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/psi/impl/JavaRegExpHost", "getQuantifierValue"));
        }
        try {
            return Integer.valueOf(number.getText());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String[][] getAllKnownProperties() {
        if (this.myPropertyNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getAllKnownProperties"));
        }
        return this.myPropertyNames;
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name2) {
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            return null;
        }
        for (String[] stringArray : this.myPropertyNames) {
            if (!stringArray[0].equals(name2)) continue;
            return stringArray.length > 1 ? stringArray[1] : stringArray[0];
        }
        return null;
    }

    @Override
    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaRegExpHost", "getKnownCharacterClasses"));
        }
        return stringArray;
    }
}

