/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean bl) {
        void eventSystemEnabled;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text2, modificationStamp, (boolean)eventSystemEnabled, true);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name2, language, text2, true, true);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name2, language, text2, eventSystemEnabled, markAsCopy, false);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return this.createFileFromText(name2, language, text2, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text2, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, language, text2);
        if (original != null) {
            virtualFile.setOriginalFile(original);
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        }
        return this.trySetupPsiForFile(virtualFile, language, eventSystemEnabled, markAsCopy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2, long modificationStamp, boolean eventSystemEnabled, boolean bl) {
        void markAsCopy;
        Language language;
        PsiFile file2;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, fileType, text2, modificationStamp);
        if (fileType instanceof LanguageFileType && (file2 = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), (VirtualFile)virtualFile, this.myManager.getProject()), eventSystemEnabled, (boolean)markAsCopy)) != null) {
            PsiFile psiFile = file2;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiPlainTextFileImpl;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProvider viewProvider;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiFileFactoryImpl", "trySetupPsiForFile"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "trySetupPsiForFile"));
        }
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text2, long modificationStamp, boolean physical, boolean bl) {
        void markAsCopy;
        PsiFile psiFile;
        FileViewProvider viewProvider;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (targetLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLanguage", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name2, fileType, text2, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
            }
            return psiFile2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiPlainTextFileImpl;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text2, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull String text2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        FileType type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name2);
        if (type2.isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name2 + ", file type " + type2);
        }
        PsiFile psiFile = this.createFileFromText(name2, type2, (CharSequence)text2);
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        return psiFile;
    }

    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        Object text2 = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, (CharSequence)text2);
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/PsiFileFactoryImpl", "createFileFromText"));
        }
        PsiFile file2 = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true);
        if (file2 != null) {
            file2.putUserData(ORIGINAL_FILE, (Object)original);
        }
        return file2;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text2, @NotNull Language language, @NotNull IElementType type2, @Nullable PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/PsiFileFactoryImpl", "createElementFromText"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/PsiFileFactoryImpl", "createElementFromText"));
        }
        if (text2 == null) {
            return null;
        }
        DummyHolder result2 = DummyHolderFactory.createHolder(this.myManager, language, context);
        FileElement holder = result2.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project2 = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project2);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project2, (ASTNode)holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project2).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated((PsiElement)result2);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }
}

