/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScopedClassHierarchy {
    private static final TObjectHashingStrategy<PsiClass> CLASS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            return StringUtil.notNullize((String)object.getQualifiedName()).hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            String qname1 = o1.getQualifiedName();
            if (qname1 != null) {
                return qname1.equals(o2.getQualifiedName());
            }
            return o1.getManager().areElementsEquivalent((PsiElement)o1, (PsiElement)o2);
        }
    };
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"ScopedClassHierarchy");
    private final PsiClass myPlaceClass;
    private final GlobalSearchScope myResolveScope;
    private volatile Map<PsiClass, PsiClassType.ClassResolveResult> mySupersWithSubstitutors;
    private volatile List<PsiClassType.ClassResolveResult> myImmediateSupersWithCapturing;
    private final Map<LanguageLevel, Map<PsiClass, PsiSubstitutor>> myAllSupersWithCapturing = ConcurrentFactoryMap.createConcurrentMap(this::calcAllMemberSupers);

    ScopedClassHierarchy(PsiClass psiClass, GlobalSearchScope resolveScope) {
        this.myPlaceClass = psiClass;
        this.myResolveScope = resolveScope;
    }

    void visitType(@NotNull PsiClassType type2, Map<PsiClass, PsiClassType.ClassResolveResult> map2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/ScopedClassHierarchy", "visitType"));
        }
        PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null || InheritanceImplUtil.hasObjectQualifiedName(psiClass) || map2.containsKey(psiClass)) {
            return;
        }
        map2.put(psiClass, resolveResult);
        for (PsiType superType : ScopedClassHierarchy.getSuperTypes(psiClass)) {
            Object object = superType = type2.isRaw() && superType instanceof PsiClassType ? ((PsiClassType)superType).rawType() : resolveResult.getSubstitutor().substitute(superType);
            if (!((superType = PsiClassImplUtil.correctType(superType, this.myResolveScope)) instanceof PsiClassType)) continue;
            this.visitType((PsiClassType)superType, map2);
        }
    }

    @NotNull
    private static List<PsiType> getSuperTypes(PsiClass psiClass) {
        ArrayList superTypes = ContainerUtil.newArrayList();
        if (psiClass instanceof PsiAnonymousClass) {
            ContainerUtil.addIfNotNull((Collection)superTypes, (Object)((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        Collections.addAll(superTypes, psiClass.getExtendsListTypes());
        Collections.addAll(superTypes, psiClass.getImplementsListTypes());
        ArrayList arrayList = superTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperTypes"));
        }
        return arrayList;
    }

    @NotNull
    static ScopedClassHierarchy getHierarchy(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        ScopedClassHierarchy scopedClassHierarchy = (ScopedClassHierarchy)((Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/ScopedClassHierarchy", "lambda$getHierarchy$1"));
            }
            ConcurrentFactoryMap result2 = ConcurrentFactoryMap.createConcurrentMap(resolveScope1 -> {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/ScopedClassHierarchy", "lambda$null$0"));
                }
                return new ScopedClassHierarchy(psiClass, (GlobalSearchScope)resolveScope1);
            });
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        })).get(resolveScope);
        if (scopedClassHierarchy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "getHierarchy"));
        }
        return scopedClassHierarchy;
    }

    @Nullable
    static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiClass superClass) {
        PsiClassType.ClassResolveResult resolveResult;
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperClassSubstitutor"));
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(derivedClass, scope);
        THashMap map2 = hierarchy.mySupersWithSubstitutors;
        if (map2 == null) {
            map2 = ContainerUtil.newTroveMap(CLASS_HASHING_STRATEGY);
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            hierarchy.visitType(JavaPsiFacade.getElementFactory((Project)derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), (Map<PsiClass, PsiClassType.ClassResolveResult>)map2);
            if (stamp.mayCacheNow()) {
                hierarchy.mySupersWithSubstitutors = map2;
            }
        }
        if ((resolveResult = (PsiClassType.ClassResolveResult)map2.get(superClass)) == null) {
            return null;
        }
        PsiClass cachedClass = (PsiClass)ObjectUtils.assertNotNull((Object)resolveResult.getElement());
        PsiSubstitutor cachedSubstitutor = resolveResult.getSubstitutor();
        return cachedClass == superClass ? cachedSubstitutor : ScopedClassHierarchy.mirrorSubstitutor(superClass, cachedClass, cachedSubstitutor);
    }

    @NotNull
    private static PsiSubstitutor mirrorSubstitutor(@NotNull PsiClass from, @NotNull PsiClass to, @NotNull PsiSubstitutor substitutor) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        Iterator baseParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)to);
        Iterator candidateParams = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)from);
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        while (baseParams.hasNext()) {
            if (!candidateParams.hasNext()) {
                PsiSubstitutor psiSubstitutor = JavaClassSupersImpl.createRawSubstitutor(to);
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
                }
                return psiSubstitutor;
            }
            answer = answer.put((PsiTypeParameter)baseParams.next(), substitutor.substitute((PsiTypeParameter)candidateParams.next()));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "mirrorSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    List<PsiClassType.ClassResolveResult> getImmediateSupersWithCapturing() {
        List list2 = this.myImmediateSupersWithCapturing;
        if (list2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            list2 = (List)ourGuard.doPreventingRecursion((Object)this, true, () -> this.calcImmediateSupersWithCapturing());
            if (list2 == null) {
                List<PsiClassType.ClassResolveResult> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "getImmediateSupersWithCapturing"));
                }
                return list3;
            }
            if (stamp.mayCacheNow()) {
                this.myImmediateSupersWithCapturing = list2;
            }
        }
        List list4 = list2;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "getImmediateSupersWithCapturing"));
        }
        return list4;
    }

    @NotNull
    private List<PsiClassType.ClassResolveResult> calcImmediateSupersWithCapturing() {
        ArrayList list2 = ContainerUtil.newArrayList();
        for (PsiClassType type2 : this.myPlaceClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result2;
            PsiClass superClass;
            PsiClassType corrected = PsiClassImplUtil.correctType(type2, this.myResolveScope);
            if (corrected == null || (superClass = (result2 = ((PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)corrected, (PsiElement)this.myPlaceClass)).resolveGenerics()).getElement()) == null || !PsiSearchScopeUtil.isInScope((GlobalSearchScope)this.myResolveScope, (PsiElement)superClass)) continue;
            list2.add(result2);
        }
        ArrayList arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "calcImmediateSupersWithCapturing"));
        }
        return arrayList;
    }

    @NotNull
    private Map<PsiClass, PsiSubstitutor> calcAllMemberSupers(LanguageLevel level) {
        THashMap map2 = ContainerUtil.newTroveMap();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myPlaceClass.getProject());
        new PairProcessor<PsiClass, PsiSubstitutor>((Map)map2, factory, level){
            final /* synthetic */ Map val$map;
            final /* synthetic */ PsiElementFactory val$factory;
            final /* synthetic */ LanguageLevel val$level;
            {
                this.val$map = map2;
                this.val$factory = psiElementFactory;
                this.val$level = languageLevel;
            }

            public boolean process(PsiClass eachClass, PsiSubstitutor eachSubstitutor) {
                if (!this.val$map.containsKey(eachClass)) {
                    this.val$map.put(eachClass, eachSubstitutor);
                    PsiClassImplUtil.processSuperTypes(eachClass, eachSubstitutor, this.val$factory, this.val$level, ScopedClassHierarchy.this.myResolveScope, this);
                }
                return true;
            }
        }.process(this.myPlaceClass, PsiSubstitutor.EMPTY);
        THashMap tHashMap = map2;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ScopedClassHierarchy", "calcAllMemberSupers"));
        }
        return tHashMap;
    }

    @Nullable
    PsiSubstitutor getSuperMembersSubstitutor(@NotNull PsiClass superClass, @NotNull LanguageLevel level) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperMembersSubstitutor"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/psi/impl/ScopedClassHierarchy", "getSuperMembersSubstitutor"));
        }
        return this.myAllSupersWithCapturing.get(level).get(superClass);
    }
}

