/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.JvmCommonIntentionActionsFactory;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@ApiStatus.Experimental
public class CreateBeanPropertyFixes {
    public static LocalQuickFix[] createFixes(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/beanProperties/CreateBeanPropertyFixes", "createFixes"));
        }
        return IntentionWrapper.wrapToQuickFixes((IntentionAction[])CreateBeanPropertyFixes.createActions(propertyName, psiClass, type2, createSetter), (PsiFile)psiClass.getContainingFile());
    }

    public static IntentionAction[] createActions(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        JvmCommonIntentionActionsFactory factory;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/beanProperties/CreateBeanPropertyFixes", "createActions"));
        }
        if (psiClass instanceof PsiCompiledElement) {
            return IntentionAction.EMPTY_ARRAY;
        }
        if (type2 == null) {
            Project project2 = psiClass.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass aClass = facade.findClass("java.lang.String", GlobalSearchScope.allScope((Project)project2));
            if (aClass == null) {
                return IntentionAction.EMPTY_ARRAY;
            }
            type2 = facade.getElementFactory().createType(aClass);
        }
        if ((factory = JvmCommonIntentionActionsFactory.forLanguage((Language)psiClass.getLanguage())) == null) {
            return IntentionAction.EMPTY_ARRAY;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)psiClass, UClass.class);
        if (uClass == null) {
            return IntentionAction.EMPTY_ARRAY;
        }
        return (IntentionAction[])ArrayUtil.toObjectArray((Collection)factory.createAddBeanPropertyActions(uClass, propertyName, "public", type2, createSetter, !createSetter), IntentionAction.class);
    }
}

