/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private final Project myProject;
    private final PsiManager myPsiManager;

    public IndexTodoCacheManagerImpl(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getFilesWithTodoItems"));
            }
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashSet allFiles = new HashSet();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
            Collection files = fileBasedIndex.getContainingFiles(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
            ApplicationManager.getApplication().runReadAction(() -> {
                for (VirtualFile file2 : files) {
                    PsiFile psiFile;
                    if (!projectFileIndex.isInContent(file2) || (psiFile = this.myPsiManager.findFile(file2)) == null) continue;
                    allFiles.add(psiFile);
                }
            });
        }
        PsiFile[] psiFileArray = allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getFilesWithTodoItems"));
        }
        return psiFileArray;
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (patternProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternProvider", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        return Arrays.stream(patternProvider.getIndexPatterns()).mapToInt(indexPattern -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "lambda$getTodoCount$1"));
            }
            return this.fetchCount(fileBasedIndex, file2, (IndexPattern)indexPattern);
        }).sum();
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "getTodoCount"));
        }
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        return this.fetchCount(FileBasedIndex.getInstance(), file2, pattern);
    }

    private int fetchCount(@NotNull FileBasedIndex fileBasedIndex, @NotNull VirtualFile file2, @NotNull IndexPattern indexPattern) {
        if (fileBasedIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBasedIndex", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        if (indexPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexPattern", "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl", "fetchCount"));
        }
        int[] count = new int[]{0};
        fileBasedIndex.processValues(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), file2, (file1, value2) -> {
            count[0] = count[0] + value2;
            return true;
        }, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file2));
        return count[0];
    }
}

