/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludeFileIconLayerProvider
implements IconLayerProvider {
    @Nullable
    public Icon getLayerIcon(@NotNull Iconable element, boolean isLocked) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/ExcludeFileIconLayerProvider", "getLayerIcon"));
        }
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)((PsiFile)element).getProject());
            if (virtualFile != null && index.isExcluded(virtualFile) && !index.isExcluded(virtualFile.getParent())) {
                return AllIcons.Nodes.ExcludedFromCompile;
            }
        }
        return null;
    }

    @NotNull
    public String getLayerDescription() {
        String string = CodeInsightBundle.message((String)"node.excluded.flag.tooltip", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/ExcludeFileIconLayerProvider", "getLayerDescription"));
        }
        return string;
    }
}

