/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectKt;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiVFSListener
implements VirtualFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.PsiVFSListener");
    private final FileTypeManager myFileTypeManager;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManagerImpl myManager;
    private final FileManagerImpl myFileManager;
    private final Project myProject;
    private boolean myReportedUnloadedPsiChange;
    private static final AtomicBoolean ourGlobalListenerInstalled = new AtomicBoolean(false);

    private static void installGlobalListener() {
        if (ourGlobalListenerInstalled.compareAndSet(false, true)) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void before(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/file/impl/PsiVFSListener$1", "before"));
                    }
                    for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                        PsiVFSListener listener2 = (PsiVFSListener)project2.getComponent(PsiVFSListener.class);
                        assert (listener2 != null);
                        new BulkVirtualFileListenerAdapter((VirtualFileListener)listener2).before(events);
                    }
                }

                public void after(@NotNull List<? extends VFileEvent> events) {
                    Project[] projects;
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/file/impl/PsiVFSListener$1", "after"));
                    }
                    for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
                        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project2);
                        if (!(updater instanceof PushedFilePropertiesUpdaterImpl)) continue;
                        ((PushedFilePropertiesUpdaterImpl)updater).processAfterVfsChanges(events);
                    }
                    for (Project project2 : projects) {
                        PsiVFSListener listener2 = (PsiVFSListener)project2.getComponent(PsiVFSListener.class);
                        assert (listener2 != null);
                        listener2.myReportedUnloadedPsiChange = false;
                        new BulkVirtualFileListenerAdapter((VirtualFileListener)listener2).after(events);
                        listener2.myReportedUnloadedPsiChange = false;
                    }
                }
            });
        }
    }

    public PsiVFSListener(Project project2) {
        PsiVFSListener.installGlobalListener();
        this.myProject = project2;
        this.myFileTypeManager = FileTypeManager.getInstance();
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project2);
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project2);
        this.myFileManager = (FileManagerImpl)this.myManager.getFileManager();
        StartupManager.getInstance((Project)project2).registerPreStartupActivity(() -> {
            MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
            connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

                public void fileTypesChanged(@NotNull FileTypeEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/file/impl/PsiVFSListener$2", "fileTypesChanged"));
                    }
                    PsiVFSListener.this.myFileManager.processFileTypesChanged();
                }
            });
            connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerAdapter());
            this.myFileManager.markInitialized();
        });
    }

    @Nullable
    private PsiDirectory getCachedDirectory(VirtualFile parent) {
        return parent == null ? null : this.myFileManager.getCachedDirectory(parent);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "fileCopied"));
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "fileCreated"));
        }
        final VirtualFile vFile = event.getFile();
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                VirtualFile parent = vFile.getParent();
                PsiDirectory parentDir = PsiVFSListener.this.getCachedDirectory(parent);
                if (parentDir == null) {
                    PsiVFSListener.this.handleVfsChangeWithoutPsi(vFile);
                    return;
                }
                if (!vFile.isDirectory()) {
                    PsiFile psiFile = PsiVFSListener.this.myFileManager.findFile(vFile);
                    if (psiFile != null && psiFile.getProject() == PsiVFSListener.this.myManager.getProject()) {
                        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                        treeEvent.setParent((PsiElement)parentDir);
                        PsiVFSListener.this.myManager.beforeChildAddition(treeEvent);
                        treeEvent.setChild((PsiElement)psiFile);
                        PsiVFSListener.this.myManager.childAdded(treeEvent);
                    }
                } else {
                    PsiDirectory psiDir = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                    if (psiDir != null && psiDir.getProject() == PsiVFSListener.this.myManager.getProject()) {
                        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                        treeEvent.setParent((PsiElement)parentDir);
                        PsiVFSListener.this.myManager.beforeChildAddition(treeEvent);
                        treeEvent.setChild((PsiElement)psiDir);
                        PsiVFSListener.this.myManager.childAdded(treeEvent);
                    }
                }
            }
        });
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "beforeFileDeletion"));
        }
        final VirtualFile vFile = event.getFile();
        VirtualFile parent = vFile.getParent();
        final PsiDirectory parentDir = this.getCachedDirectory(parent);
        if (parentDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                if (!vFile.isDirectory()) {
                    PsiFile psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFile(vFile);
                    if (psiFile != null) {
                        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                        treeEvent.setParent((PsiElement)parentDir);
                        treeEvent.setChild((PsiElement)psiFile);
                        PsiVFSListener.this.myManager.beforeChildRemoval(treeEvent);
                    }
                } else {
                    PsiDirectory psiDir = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                    if (psiDir != null) {
                        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                        treeEvent.setParent((PsiElement)parentDir);
                        treeEvent.setChild((PsiElement)psiDir);
                        PsiVFSListener.this.myManager.beforeChildRemoval(treeEvent);
                    }
                }
            }
        });
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "fileDeleted"));
        }
        VirtualFile vFile = event.getFile();
        VirtualFile parent = event.getParent();
        final PsiDirectory parentDir = this.getCachedDirectory(parent);
        final PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
        if (psiFile != null) {
            this.clearViewProvider(vFile, "PSI fileDeleted");
            if (parentDir != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                        treeEvent.setParent((PsiElement)parentDir);
                        treeEvent.setChild((PsiElement)psiFile);
                        PsiVFSListener.this.myManager.childRemoved(treeEvent);
                    }
                });
            } else if (parent != null) {
                this.handleVfsChangeWithoutPsi(parent);
            }
        } else {
            final PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
            if (psiDir != null) {
                this.myFileManager.removeInvalidFilesAndDirs(false);
                if (parentDir != null) {
                    ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                        @Override
                        public void run() {
                            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                            treeEvent.setParent((PsiElement)parentDir);
                            treeEvent.setChild((PsiElement)psiDir);
                            PsiVFSListener.this.myManager.childRemoved(treeEvent);
                        }
                    });
                }
            } else if (parent != null) {
                this.handleVfsChangeWithoutPsi(parent);
            }
        }
    }

    private void clearViewProvider(@NotNull VirtualFile vFile, @NotNull String why) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/PsiVFSListener", "clearViewProvider"));
        }
        if (why == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "why", "com/intellij/psi/impl/file/impl/PsiVFSListener", "clearViewProvider"));
        }
        DebugUtil.startPsiModification(why);
        try {
            this.myFileManager.setViewProvider(vFile, null);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public void beforePropertyChange(final @NotNull VirtualFilePropertyEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "beforePropertyChange"));
        }
        final VirtualFile vFile = event.getFile();
        final String propertyName = event.getPropertyName();
        FileViewProvider viewProvider = this.myFileManager.findCachedViewProvider(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = viewProvider != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (parent != null && parentDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                if ("name".equals(propertyName)) {
                    String newName = (String)event.getNewValue();
                    if (parentDir == null) {
                        return;
                    }
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                        if (psiDir != null) {
                            if (!PsiVFSListener.this.myFileTypeManager.isFileIgnored(newName)) {
                                treeEvent.setChild((PsiElement)psiDir);
                                treeEvent.setPropertyName("directoryName");
                                treeEvent.setOldValue(vFile.getName());
                                treeEvent.setNewValue(newName);
                                PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
                            } else {
                                treeEvent.setChild((PsiElement)psiDir);
                                PsiVFSListener.this.myManager.beforeChildRemoval(treeEvent);
                            }
                        } else if (!(Registry.is((String)"ide.hide.excluded.files") && PsiVFSListener.this.isExcludeRoot(vFile) || PsiVFSListener.this.myFileTypeManager.isFileIgnored(newName))) {
                            PsiVFSListener.this.myManager.beforeChildAddition(treeEvent);
                        }
                    } else {
                        FileViewProvider viewProvider = PsiVFSListener.this.myFileManager.findViewProvider(vFile);
                        PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
                        PsiFile psiFile1 = PsiVFSListener.this.createFileCopyWithNewName(vFile, newName);
                        if (psiFile != null) {
                            if (psiFile1 == null) {
                                treeEvent.setChild((PsiElement)psiFile);
                                PsiVFSListener.this.myManager.beforeChildRemoval(treeEvent);
                            } else if (!psiFile1.getClass().equals(psiFile.getClass())) {
                                treeEvent.setOldChild((PsiElement)psiFile);
                                PsiVFSListener.this.myManager.beforeChildReplacement(treeEvent);
                            } else {
                                treeEvent.setChild((PsiElement)psiFile);
                                treeEvent.setPropertyName("fileName");
                                treeEvent.setOldValue(vFile.getName());
                                treeEvent.setNewValue(newName);
                                PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
                            }
                        } else if (psiFile1 != null) {
                            PsiVFSListener.this.myManager.beforeChildAddition(treeEvent);
                        }
                    }
                } else if ("writable".equals(propertyName)) {
                    PsiFile psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFileInner(vFile);
                    if (psiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)psiFile);
                    treeEvent.setPropertyName("writable");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
                }
            }
        });
    }

    private boolean isExcludeRoot(VirtualFile file2) {
        VirtualFile[] excludeRoots;
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            return false;
        }
        Module module2 = this.myProjectRootManager.getFileIndex().getModuleForFile(parent);
        if (module2 == null) {
            return false;
        }
        for (VirtualFile root : excludeRoots = ModuleRootManager.getInstance((Module)module2).getExcludeRoots()) {
            if (!root.equals(file2)) continue;
            return true;
        }
        return false;
    }

    public void propertyChanged(final @NotNull VirtualFilePropertyEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "propertyChanged"));
        }
        final String propertyName = event.getPropertyName();
        final VirtualFile vFile = event.getFile();
        final FileViewProvider oldFileViewProvider = this.myFileManager.findCachedViewProvider(vFile);
        final PsiFile oldPsiFile = oldFileViewProvider instanceof SingleRootFileViewProvider ? ((SingleRootFileViewProvider)oldFileViewProvider).getCachedPsi(oldFileViewProvider.getBaseLanguage()) : null;
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = oldPsiFile != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (oldFileViewProvider != null && "FileContentUtilCore.saveOrReload".equals(event.getRequestor())) {
            this.myFileManager.forceReload(vFile);
            return;
        }
        if (parentDir == null) {
            boolean fire;
            boolean bl = fire = "name".equals(propertyName) && vFile.isDirectory();
            if (fire) {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                boolean bl2 = fire = psiDir != null;
            }
            if (!fire && !"writable".equals(propertyName)) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                if ("name".equals(propertyName)) {
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = PsiVFSListener.this.myFileManager.getCachedDirectory(vFile);
                        if (psiDir != null) {
                            if (PsiVFSListener.this.myFileTypeManager.isFileIgnored(vFile)) {
                                PsiVFSListener.this.myFileManager.removeFilesAndDirsRecursively(vFile);
                                treeEvent.setChild((PsiElement)psiDir);
                                PsiVFSListener.this.myManager.childRemoved(treeEvent);
                            } else {
                                treeEvent.setElement((PsiElement)psiDir);
                                treeEvent.setPropertyName("directoryName");
                                treeEvent.setOldValue(event.getOldValue());
                                treeEvent.setNewValue(event.getNewValue());
                                PsiVFSListener.this.myManager.propertyChanged(treeEvent);
                            }
                        } else {
                            PsiDirectory psiDir1 = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                            if (psiDir1 != null) {
                                treeEvent.setChild((PsiElement)psiDir1);
                                PsiVFSListener.this.myManager.childAdded(treeEvent);
                            }
                        }
                    } else {
                        FileViewProvider fileViewProvider = PsiVFSListener.this.myFileManager.createFileViewProvider(vFile, true);
                        PsiFile newPsiFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
                        if (oldPsiFile != null) {
                            if (newPsiFile == null) {
                                PsiVFSListener.this.clearViewProvider(vFile, "PSI renamed");
                                treeEvent.setChild((PsiElement)oldPsiFile);
                                PsiVFSListener.this.myManager.childRemoved(treeEvent);
                            } else if (!FileManagerImpl.areViewProvidersEquivalent(fileViewProvider, oldFileViewProvider)) {
                                PsiVFSListener.this.myFileManager.setViewProvider(vFile, fileViewProvider);
                                treeEvent.setOldChild((PsiElement)oldPsiFile);
                                treeEvent.setNewChild((PsiElement)newPsiFile);
                                PsiVFSListener.this.myManager.childReplaced(treeEvent);
                            } else {
                                FileManagerImpl.clearPsiCaches(oldFileViewProvider);
                                treeEvent.setElement((PsiElement)oldPsiFile);
                                treeEvent.setPropertyName("fileName");
                                treeEvent.setOldValue(event.getOldValue());
                                treeEvent.setNewValue(event.getNewValue());
                                PsiVFSListener.this.myManager.propertyChanged(treeEvent);
                            }
                        } else if (newPsiFile != null) {
                            PsiVFSListener.this.myFileManager.setViewProvider(vFile, fileViewProvider);
                            if (parentDir != null) {
                                treeEvent.setChild((PsiElement)newPsiFile);
                                PsiVFSListener.this.myManager.childAdded(treeEvent);
                            }
                        }
                    }
                } else if ("writable".equals(propertyName)) {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("writable");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    PsiVFSListener.this.myManager.propertyChanged(treeEvent);
                } else if ("encoding".equals(propertyName)) {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("encoding");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    PsiVFSListener.this.myManager.propertyChanged(treeEvent);
                }
            }
        });
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "beforeFileMovement"));
        }
        final VirtualFile vFile = event.getFile();
        final PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        final PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null) {
            return;
        }
        if (this.myFileTypeManager.isFileIgnored(vFile)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                boolean isExcluded;
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                boolean bl = isExcluded = vFile.isDirectory() && Registry.is((String)"ide.hide.excluded.files") && PsiVFSListener.this.myProjectRootManager.getFileIndex().isExcluded(vFile);
                if (oldParentDir != null && !isExcluded) {
                    if (newParentDir != null) {
                        treeEvent.setOldParent((PsiElement)oldParentDir);
                        treeEvent.setNewParent((PsiElement)newParentDir);
                        if (vFile.isDirectory()) {
                            PsiDirectory psiDir = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                            treeEvent.setChild((PsiElement)psiDir);
                        } else {
                            PsiFile psiFile = PsiVFSListener.this.myFileManager.findFile(vFile);
                            treeEvent.setChild((PsiElement)psiFile);
                        }
                        PsiVFSListener.this.myManager.beforeChildMovement(treeEvent);
                    } else {
                        treeEvent.setParent((PsiElement)oldParentDir);
                        if (vFile.isDirectory()) {
                            PsiDirectory psiDir = PsiVFSListener.this.myFileManager.findDirectory(vFile);
                            treeEvent.setChild((PsiElement)psiDir);
                        } else {
                            PsiFile psiFile = PsiVFSListener.this.myFileManager.findFile(vFile);
                            treeEvent.setChild((PsiElement)psiFile);
                        }
                        PsiVFSListener.this.myManager.beforeChildRemoval(treeEvent);
                    }
                } else {
                    LOG.assertTrue(newParentDir != null);
                    treeEvent.setParent((PsiElement)newParentDir);
                    PsiVFSListener.this.myManager.beforeChildAddition(treeEvent);
                }
            }
        });
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        PsiDirectory newElement;
        FileViewProvider newViewProvider;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/file/impl/PsiVFSListener", "fileMoved"));
        }
        VirtualFile vFile = event.getFile();
        PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null) {
            return;
        }
        PsiDirectory oldElement = vFile.isDirectory() ? this.myFileManager.getCachedDirectory(vFile) : this.myFileManager.getCachedPsiFileInner(vFile);
        this.myFileManager.removeInvalidFilesAndDirs(true);
        if (!vFile.isDirectory()) {
            newViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
            newElement = newViewProvider.getPsi(this.myFileManager.findViewProvider(vFile).getBaseLanguage());
        } else {
            newElement = this.myFileManager.findDirectory(vFile);
            newViewProvider = null;
        }
        if (oldElement == null && newElement == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction((PsiElement)oldElement, vFile, newViewProvider, newParentDir, (PsiElement)newElement, oldParentDir){
            final /* synthetic */ PsiElement val$oldElement;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ FileViewProvider val$newViewProvider;
            final /* synthetic */ PsiDirectory val$newParentDir;
            final /* synthetic */ PsiElement val$newElement;
            final /* synthetic */ PsiDirectory val$oldParentDir;
            {
                this.val$oldElement = psiElement;
                this.val$vFile = virtualFile;
                this.val$newViewProvider = fileViewProvider;
                this.val$newParentDir = psiDirectory;
                this.val$newElement = psiElement2;
                this.val$oldParentDir = psiDirectory2;
            }

            @Override
            public void run() {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                if (this.val$oldElement == null) {
                    PsiVFSListener.this.myFileManager.setViewProvider(this.val$vFile, this.val$newViewProvider);
                    treeEvent.setParent((PsiElement)this.val$newParentDir);
                    treeEvent.setChild(this.val$newElement);
                    PsiVFSListener.this.myManager.childAdded(treeEvent);
                } else if (this.val$newElement == null) {
                    PsiVFSListener.this.clearViewProvider(this.val$vFile, "PSI moved");
                    treeEvent.setParent((PsiElement)this.val$oldParentDir);
                    treeEvent.setChild(this.val$oldElement);
                    PsiVFSListener.this.myManager.childRemoved(treeEvent);
                } else if (this.val$newElement instanceof PsiDirectory || FileManagerImpl.areViewProvidersEquivalent(this.val$newViewProvider, ((PsiFile)this.val$oldElement).getViewProvider())) {
                    treeEvent.setOldParent((PsiElement)this.val$oldParentDir);
                    treeEvent.setNewParent((PsiElement)this.val$newParentDir);
                    treeEvent.setChild(this.val$oldElement);
                    PsiVFSListener.this.myManager.childMoved(treeEvent);
                } else {
                    PsiVFSListener.this.myFileManager.setViewProvider(this.val$vFile, this.val$newViewProvider);
                    PsiTreeChangeEventImpl treeRemoveEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                    treeRemoveEvent.setParent((PsiElement)this.val$oldParentDir);
                    treeRemoveEvent.setChild(this.val$oldElement);
                    PsiVFSListener.this.myManager.childRemoved(treeRemoveEvent);
                    PsiTreeChangeEventImpl treeAddEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                    treeAddEvent.setParent((PsiElement)this.val$newParentDir);
                    treeAddEvent.setChild(this.val$newElement);
                    PsiVFSListener.this.myManager.childAdded(treeAddEvent);
                }
            }
        });
    }

    @Nullable
    private PsiFile createFileCopyWithNewName(VirtualFile vFile, String name2) {
        FileTypeManager instance = FileTypeManager.getInstance();
        if (instance.isFileIgnored(name2)) {
            return null;
        }
        FileType fileTypeByFileName = instance.getFileTypeByFileName(name2);
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(name2, fileTypeByFileName, document != null ? document.getCharsSequence() : "", vFile.getModificationStamp(), true, false);
    }

    private void handleVfsChangeWithoutPsi(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/PsiVFSListener", "handleVfsChangeWithoutPsi"));
        }
        if (!this.myReportedUnloadedPsiChange && this.isInRootModel(vFile)) {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
            this.myFileManager.firePropertyChangedForUnloadedPsi(event, vFile);
            this.myReportedUnloadedPsiChange = true;
        }
    }

    private boolean isInRootModel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/PsiVFSListener", "isInRootModel"));
        }
        if (ProjectKt.getStateStore(this.myProject).isProjectFile(file2)) {
            return false;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        return index.isInContent(file2) || index.isInLibraryClasses(file2) || index.isInLibrarySource(file2);
    }

    private class MyFileDocumentManagerAdapter
    extends FileDocumentManagerAdapter {
        private MyFileDocumentManagerAdapter() {
        }

        public void fileWithNoDocumentChanged(final @NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerAdapter", "fileWithNoDocumentChanged"));
            }
            final PsiFile psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFileInner(file2);
            if (psiFile != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        if (FileDocumentManagerImpl.recomputeFileTypeIfNecessary(file2)) {
                            PsiVFSListener.this.myFileManager.forceReload(file2);
                        } else {
                            PsiVFSListener.this.myFileManager.reloadFromDisk(psiFile, true);
                        }
                    }
                });
            } else {
                PsiVFSListener.this.handleVfsChangeWithoutPsi(file2);
            }
        }

        public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerAdapter", "fileContentReloaded"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerAdapter", "fileContentReloaded"));
            }
            final PsiFile psiFile = PsiVFSListener.this.myFileManager.getCachedPsiFileInner(file2);
            if (!file2.isValid() || psiFile == null || !FileUtilRt.isTooLarge((long)file2.getLength()) || psiFile instanceof PsiLargeFile) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    PsiVFSListener.this.myFileManager.reloadFromDisk(psiFile, true);
                }
            });
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private VirtualFile[] myOldContentRoots;
        private volatile int depthCounter;

        private MyModuleRootListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
            if (!PsiVFSListener.this.myFileManager.isInitialized()) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    MyModuleRootListener.this.depthCounter++;
                    if (MyModuleRootListener.this.depthCounter > 1) {
                        return;
                    }
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                    treeEvent.setPropertyName("roots");
                    VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                    LOG.assertTrue(MyModuleRootListener.this.myOldContentRoots == null);
                    MyModuleRootListener.access$1202(MyModuleRootListener.this, contentRoots);
                    treeEvent.setOldValue(contentRoots);
                    PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
                }
            });
        }

        public void rootsChanged(ModuleRootEvent event) {
            PsiVFSListener.this.myFileManager.dispatchPendingEvents();
            if (!PsiVFSListener.this.myFileManager.isInitialized()) {
                return;
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                @Override
                public void run() {
                    MyModuleRootListener.this.depthCounter--;
                    assert (MyModuleRootListener.this.depthCounter >= 0) : MyModuleRootListener.access$1100(MyModuleRootListener.this);
                    if (MyModuleRootListener.this.depthCounter > 0) {
                        return;
                    }
                    PsiVFSListener.this.myFileManager.removeInvalidFilesAndDirs(true);
                    PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                    treeEvent.setPropertyName("roots");
                    VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                    treeEvent.setNewValue(contentRoots);
                    LOG.assertTrue(MyModuleRootListener.this.myOldContentRoots != null);
                    treeEvent.setOldValue(MyModuleRootListener.this.myOldContentRoots);
                    MyModuleRootListener.access$1202(MyModuleRootListener.this, null);
                    PsiVFSListener.this.myManager.propertyChanged(treeEvent);
                }
            });
        }

        static /* synthetic */ VirtualFile[] access$1202(MyModuleRootListener x0, VirtualFile[] x1) {
            x0.myOldContentRoots = x1;
            return x1;
        }
    }
}

