/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileIncludeManagerImpl
extends FileIncludeManager {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final PsiFileFactory myPsiFileFactory;
    private final CachedValuesManager myCachedValuesManager;
    private final IncludeCacheHolder myIncludedHolder = new IncludeCacheHolder("compile time includes", "runtime includes"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
            THashSet files = new THashSet();
            FileIncludeManagerImpl.this.processIncludes(file2, (Processor<FileIncludeInfo>)((Processor)arg_0 -> this.lambda$computeFiles$0(compileTimeOnly, file2, (Set)files, arg_0)));
            return VfsUtilCore.toVirtualFileArray((Collection)files);
        }

        private /* synthetic */ boolean lambda$computeFiles$0(boolean compileTimeOnly, PsiFile file2, Set files, FileIncludeInfo info) {
            PsiFileSystemItem item;
            if (compileTimeOnly != info.runtimeOnly && (item = FileIncludeManagerImpl.this.resolveFileInclude(info, file2)) != null) {
                ContainerUtil.addIfNotNull((Collection)files, (Object)item.getVirtualFile());
            }
            return true;
        }
    };
    private final Map<String, FileIncludeProvider> myProviderMap;
    private final IncludeCacheHolder myIncludingHolder = new IncludeCacheHolder("compile time contexts", "runtime contexts"){

        @Override
        protected VirtualFile[] computeFiles(PsiFile context, boolean compileTimeOnly) {
            THashSet files = new THashSet();
            FileIncludeManagerImpl.this.processIncludingFiles(context, (Processor<Pair<VirtualFile, FileIncludeInfo>>)((Processor)arg_0 -> 2.lambda$computeFiles$0((Set)files, arg_0)));
            return VfsUtilCore.toVirtualFileArray((Collection)files);
        }

        private static /* synthetic */ boolean lambda$computeFiles$0(Set files, Pair virtualFileFileIncludeInfoPair) {
            files.add(virtualFileFileIncludeInfoPair.first);
            return true;
        }
    };

    public void processIncludes(PsiFile file2, Processor<FileIncludeInfo> processor2) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        List<FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludes(file2.getVirtualFile(), scope);
        for (FileIncludeInfoImpl info : infoList) {
            if (processor2.process((Object)info)) continue;
            return;
        }
    }

    public void processIncludingFiles(PsiFile context, Processor<Pair<VirtualFile, FileIncludeInfo>> processor2) {
        VirtualFile contextFile = (context = context.getOriginalFile()).getVirtualFile();
        if (contextFile == null) {
            return;
        }
        MultiMap<VirtualFile, FileIncludeInfoImpl> infoList = FileIncludeIndex.getIncludingFileCandidates(context.getName(), GlobalSearchScope.allScope((Project)this.myProject));
        for (VirtualFile candidate : infoList.keySet()) {
            PsiFile psiFile = this.myPsiManager.findFile(candidate);
            if (psiFile == null || context.equals(psiFile)) continue;
            for (FileIncludeInfo info : infoList.get((Object)candidate)) {
                PsiFileSystemItem item = this.resolveFileInclude(info, psiFile);
                if (item == null || !contextFile.equals(item.getVirtualFile()) || processor2.process((Object)Pair.create((Object)candidate, (Object)info))) continue;
                return;
            }
        }
    }

    public FileIncludeManagerImpl(Project project2, PsiManager psiManager, PsiFileFactory psiFileFactory, CachedValuesManager cachedValuesManager) {
        this.myProject = project2;
        this.myPsiManager = psiManager;
        this.myPsiFileFactory = psiFileFactory;
        FileIncludeProvider[] providers2 = (FileIncludeProvider[])Extensions.getExtensions(FileIncludeProvider.EP_NAME);
        this.myProviderMap = new HashMap(providers2.length);
        for (FileIncludeProvider provider : providers2) {
            FileIncludeProvider old = this.myProviderMap.put(provider.getId(), provider);
            assert (old == null);
        }
        this.myCachedValuesManager = cachedValuesManager;
    }

    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "getIncludedFiles"));
        }
        return this.getIncludedFiles(file2, compileTimeOnly, false);
    }

    public VirtualFile[] getIncludedFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "getIncludedFiles"));
        }
        if (file2 instanceof VirtualFileWithId) {
            return this.myIncludedHolder.getAllFiles(file2, compileTimeOnly, recursively);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public VirtualFile[] getIncludingFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "getIncludingFiles"));
        }
        return this.myIncludingHolder.getAllFiles(file2, compileTimeOnly, false);
    }

    public PsiFileSystemItem resolveFileInclude(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "resolveFileInclude"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "resolveFileInclude"));
        }
        return this.doResolve(info, context);
    }

    @Nullable
    private PsiFileSystemItem doResolve(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "doResolve"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/include/FileIncludeManagerImpl", "doResolve"));
        }
        if (info instanceof FileIncludeInfoImpl) {
            PsiFileSystemItem resolvedByProvider;
            String id = ((FileIncludeInfoImpl)info).providerId;
            FileIncludeProvider provider = id == null ? null : this.myProviderMap.get(id);
            PsiFileSystemItem psiFileSystemItem = resolvedByProvider = provider == null ? null : provider.resolveIncludedFile(info, context);
            if (resolvedByProvider != null) {
                return resolvedByProvider;
            }
        }
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)info.path);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile){

            @Override
            protected boolean useIncludingFileAsContext() {
                return false;
            }
        }.resolve();
    }

    private static abstract class IncludedFilesProvider
    implements ParameterizedCachedValueProvider<VirtualFile[], PsiFile> {
        private final boolean myRuntimeOnly;

        public IncludedFilesProvider(boolean runtimeOnly) {
            this.myRuntimeOnly = runtimeOnly;
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);

        public CachedValueProvider.Result<VirtualFile[]> compute(PsiFile psiFile) {
            VirtualFile[] value2 = this.computeFiles(psiFile, this.myRuntimeOnly);
            ArrayList<VirtualFile> deps = new ArrayList<VirtualFile>(Arrays.asList(value2));
            deps.add((VirtualFile)psiFile);
            deps.add((VirtualFile)VirtualFileManager.getInstance());
            return CachedValueProvider.Result.create((Object)value2, deps);
        }
    }

    private abstract class IncludeCacheHolder {
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> COMPILE_TIME_KEY;
        private final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> RUNTIME_KEY;
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> COMPILE_TIME_PROVIDER = new IncludedFilesProvider(true){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };
        private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> RUNTIME_PROVIDER = new IncludedFilesProvider(false){

            @Override
            protected VirtualFile[] computeFiles(PsiFile file2, boolean compileTimeOnly) {
                return IncludeCacheHolder.this.computeFiles(file2, compileTimeOnly);
            }
        };

        private IncludeCacheHolder(String compileTimeKey, String runtimeKey) {
            this.COMPILE_TIME_KEY = Key.create((String)compileTimeKey);
            this.RUNTIME_KEY = Key.create((String)runtimeKey);
        }

        @NotNull
        private VirtualFile[] getAllFiles(@NotNull VirtualFile file2, boolean compileTimeOnly, boolean recursively) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder", "getAllFiles"));
            }
            if (recursively) {
                HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
                this.getAllFilesRecursively(file2, compileTimeOnly, result2);
                VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
                if (virtualFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder", "getAllFiles"));
                }
                return virtualFileArray;
            }
            VirtualFile[] virtualFileArray = this.getFiles(file2, compileTimeOnly);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder", "getAllFiles"));
            }
            return virtualFileArray;
        }

        private void getAllFilesRecursively(@NotNull VirtualFile file2, boolean compileTimeOnly, Set<VirtualFile> result2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder", "getAllFilesRecursively"));
            }
            if (!result2.add(file2)) {
                return;
            }
            VirtualFile[] includes = this.getFiles(file2, compileTimeOnly);
            if (includes.length != 0) {
                for (VirtualFile include : includes) {
                    this.getAllFilesRecursively(include, compileTimeOnly, result2);
                }
            }
        }

        private VirtualFile[] getFiles(@NotNull VirtualFile file2, boolean compileTimeOnly) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeManagerImpl$IncludeCacheHolder", "getFiles"));
            }
            PsiFile psiFile = FileIncludeManagerImpl.this.myPsiManager.findFile(file2);
            if (psiFile == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            if (compileTimeOnly) {
                return (VirtualFile[])FileIncludeManagerImpl.this.myCachedValuesManager.getParameterizedCachedValue((UserDataHolder)psiFile, this.COMPILE_TIME_KEY, this.COMPILE_TIME_PROVIDER, false, (Object)psiFile);
            }
            return (VirtualFile[])FileIncludeManagerImpl.this.myCachedValuesManager.getParameterizedCachedValue((UserDataHolder)psiFile, this.RUNTIME_KEY, this.RUNTIME_PROVIDER, false, (Object)psiFile);
        }

        protected abstract VirtualFile[] computeFiles(PsiFile var1, boolean var2);
    }
}

