/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiEnumConstantImpl;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFieldStubElementType
extends JavaStubElementType<PsiFieldStub, PsiField> {
    private static final int INITIALIZER_LENGTH_LIMIT = 1000;

    public JavaFieldStubElementType(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "<init>"));
        }
        super(id);
    }

    public PsiField createPsi(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createField(stub);
    }

    @Override
    public PsiField createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "createPsi"));
        }
        if (node instanceof EnumConstantElement) {
            return new PsiEnumConstantImpl(node);
        }
        return new PsiFieldImpl(node);
    }

    public PsiFieldStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String name2 = null;
        String initializer = null;
        boolean expectingInit = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaTokenType.IDENTIFIER) {
                name2 = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type2 == JavaTokenType.EQ) {
                expectingInit = true;
                continue;
            }
            if (!expectingInit || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2) || type2 == JavaTokenType.SEMICOLON) continue;
            initializer = JavaFieldStubElementType.encodeInitializer(tree, child);
            break;
        }
        boolean isEnumConst = node.getTokenType() == JavaElementType.ENUM_CONSTANT;
        byte flags = PsiFieldStubImpl.packFlags(isEnumConst, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiFieldStubImpl(parentStub, name2, typeInfo, initializer, flags);
    }

    private static String encodeInitializer(LighterAST tree, LighterASTNode initializer) {
        IElementType type2 = initializer.getTokenType();
        if (type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            return ";INITIALIZER_NOT_STORED;";
        }
        if (initializer.getEndOffset() - initializer.getStartOffset() > 1000) {
            return ";INITIALIZER_TOO_LONG;";
        }
        return LightTreeUtil.toFilteredString(tree, initializer, null);
    }

    public void serialize(@NotNull PsiFieldStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeName(stub.getInitializerText());
        dataStream.writeByte((int)((PsiFieldStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "deserialize"));
        }
        StringRef name2 = dataStream.readName();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        StringRef initializerText = dataStream.readName();
        byte flags = dataStream.readByte();
        PsiFieldStubImpl psiFieldStubImpl = new PsiFieldStubImpl(parentStub, StringRef.toString((StringRef)name2), type2, StringRef.toString((StringRef)initializerText), flags);
        if (psiFieldStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "deserialize"));
        }
        return psiFieldStubImpl;
    }

    public void indexStub(@NotNull PsiFieldStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "indexStub"));
        }
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JavaStubIndexKeys.FIELDS, (Object)name2);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name2);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)stub.getType(false).getShortTypeText());
            }
        }
    }

    public String getId(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaFieldStubElementType", "getId"));
        }
        String name2 = stub.getName();
        return name2 != null ? name2 : super.getId((StubElement)stub);
    }
}

