/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.SourceStubPsiFactory;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.annotations.NotNull;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private final String myPackageName;
    private final LanguageLevel myLanguageLevel;
    private final boolean myCompiled;
    private StubPsiFactory myFactory;

    public PsiJavaFileStubImpl(String packageName, boolean compiled) {
        this(null, packageName, null, compiled);
    }

    public PsiJavaFileStubImpl(PsiJavaFile file2, String packageName, LanguageLevel languageLevel, boolean compiled) {
        super(file2);
        this.myPackageName = packageName;
        this.myLanguageLevel = languageLevel;
        this.myCompiled = compiled;
        this.myFactory = compiled ? ClsStubPsiFactory.INSTANCE : SourceStubPsiFactory.INSTANCE;
    }

    @Override
    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = JavaStubElementTypes.JAVA_FILE;
        if (iStubFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl", "getType"));
        }
        return iStubFileElementType;
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = (PsiClass[])this.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaModule getModule() {
        StubElement moduleStub = this.findChildStubByType((IStubElementType)JavaStubElementTypes.MODULE);
        return moduleStub != null ? (PsiJavaModule)moduleStub.getPsi() : null;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    @Override
    public StubPsiFactory getPsiFactory() {
        return this.myFactory;
    }

    @Override
    public void setPsiFactory(StubPsiFactory factory) {
        this.myFactory = factory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiJavaFileStubImpl stub = (PsiJavaFileStubImpl)o;
        if (this.myCompiled != stub.myCompiled) {
            return false;
        }
        if (this.myPackageName != null ? !this.myPackageName.equals(stub.myPackageName) : stub.myPackageName != null) {
            return false;
        }
        return this.myLanguageLevel == stub.myLanguageLevel;
    }

    public int hashCode() {
        int result2 = this.myPackageName != null ? this.myPackageName.hashCode() : 0;
        result2 = 31 * result2 + (this.myLanguageLevel != null ? this.myLanguageLevel.hashCode() : 0);
        result2 = 31 * result2 + (this.myCompiled ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }
}

