/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaAutoModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.auto.module.name");
    private final FileBasedIndex.InputFilter myFilter = file2 -> file2.isDirectory() && file2.getParent() == null && "jar".equalsIgnoreCase(file2.getExtension());
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> Collections.singletonMap(LightJavaModule.moduleName(data.getFile()), null);

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 1 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getFilesByKey"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getFilesByKey"));
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaAutoModuleNameIndex", "getFilesByKey"));
        }
        return collection;
    }
}

