/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();
    private static final Pattern MULTI_RESOLVE_VERSION = Pattern.compile("/META-INF/versions/([^/]+)/module-info.class");

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    public int getVersion() {
        return super.getVersion() + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        StubIndexKey<String, PsiJavaModule> stubIndexKey = JavaStubIndexKeys.MODULE_NAMES;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public Collection<PsiJavaModule> get(@NotNull String name2, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        Collection<PsiJavaModule> modules = StubIndex.getElements(this.getKey(), (Object)name2, (Project)project2, (GlobalSearchScope)new JavaSourceFilterScope(scope), PsiJavaModule.class);
        if (modules.size() > 1) {
            modules = JavaModuleNameIndex.filterVersions(project2, modules);
        }
        return modules;
    }

    private static Collection<PsiJavaModule> filterVersions(Project project2, Collection<PsiJavaModule> modules) {
        HashMap filter = ContainerUtil.newHashMap();
        HashSet screened = ContainerUtil.newHashSet();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        for (PsiJavaModule module3 : modules) {
            VirtualFile classRoot;
            VirtualFile file2 = module3.getContainingFile().getVirtualFile();
            if (!index.isInLibraryClasses(file2) || (classRoot = index.getClassRootForFile(file2)) == null) continue;
            PsiJavaModule previous = (PsiJavaModule)filter.get(classRoot);
            if (previous == null) {
                filter.put(classRoot, module3);
                continue;
            }
            if (StringUtil.compareVersionNumbers((String)JavaModuleNameIndex.fileVersion(file2), (String)JavaModuleNameIndex.fileVersion(previous.getContainingFile().getVirtualFile())) < 0) {
                filter.put(classRoot, module3);
                screened.add(previous);
                continue;
            }
            screened.add(module3);
        }
        return screened.isEmpty() ? modules : (Collection)modules.stream().filter(module2 -> !screened.contains(module2)).collect(Collectors.toList());
    }

    private static String fileVersion(VirtualFile file2) {
        Matcher matcher = MULTI_RESOLVE_VERSION.matcher(file2.getPath());
        return matcher.find() ? matcher.group(1) : "0";
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }
}

