/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myJarRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule", "<init>"));
        }
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "<init>"));
        }
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());
        this.myJarRoot = jarRoot;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, LightJavaModule.moduleName(jarRoot));
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile = this.myJarRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getRootVirtualFile"));
        }
        return virtualFile;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getRequires"));
        }
        return list2;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = (Iterable)this.myExports.getValue();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getExports"));
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList exports = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myJarRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            public boolean visitFile(@NotNull VirtualFile file2) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
                }
                if (file2.isDirectory() && !LightJavaModule.this.myJarRoot.equals(file2) && (directory = LightJavaModule.this.myManager.findDirectory(file2)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty((PsiDirectory[])new PsiDirectory[]{directory}, (String)packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.myManager, packageName));
                }
                return true;
            }
        });
        return exports;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getOpens"));
        }
        return list2;
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getUses"));
        }
        return list2;
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getProvides"));
        }
        return list2;
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getNameIdentifier"));
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myRefElement.getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightJavaModule", "setName"));
        }
        throw new IncorrectOperationException("Cannot modify automatic module '" + this.getName() + "'");
    }

    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightJavaModule", "hasModifierProperty"));
        }
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)this.myManager.findDirectory(this.myJarRoot), (Object)super.getNavigationElement());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getNavigationElement"));
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myJarRoot.equals(((LightJavaModule)((Object)obj)).myJarRoot) && this.getManager() == ((LightJavaModule)((Object)obj)).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        PsiDirectory directory = manager.findDirectory(jarRoot);
        assert (directory != null) : jarRoot;
        LightJavaModule lightJavaModule = (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule", "lambda$getModule$1"));
            }
            if (jarRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "lambda$getModule$1"));
            }
            LightJavaModule module2 = new LightJavaModule(manager, jarRoot);
            return CachedValueProvider.Result.create((Object)((Object)module2), (Object[])new Object[]{directory});
        }));
        if (lightJavaModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "getModule"));
        }
        return lightJavaModule;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        block25: {
            Throwable throwable;
            InputStream stream;
            block22: {
                String string;
                block23: {
                    block24: {
                        if (jarRoot == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
                        }
                        VirtualFile manifest = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
                        if (manifest == null) break block25;
                        stream = manifest.getInputStream();
                        throwable = null;
                        String claimed = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
                        if (claimed == null) break block22;
                        string = claimed;
                        if (stream == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    stream.close();
                }
                String string2 = string;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
                }
                return string2;
            }
            try {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
                break block25;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (IOException e) {
                Logger.getInstance(LightJavaModule.class).warn((Throwable)e);
            }
        }
        String string = LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
        }
        return string;
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
        }
        Matcher m = Patterns.VERSION.matcher(name2);
        if (m.find()) {
            name2 = name2.substring(0, m.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        String string = name2 = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name2, (char)'.'), (char)'.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule", "moduleName"));
        }
        return string;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        public LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement", "<init>"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement", "<init>"));
            }
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement", "getRole"));
            }
            return role;
        }

        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement", "getModuleReferences"));
            }
            return list2;
        }

        @NotNull
        public List<String> getModuleNames() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement", "getModuleNames"));
            }
            return list2;
        }

        @Override
        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        public LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "<init>"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "<init>"));
            }
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @NotNull
        public String getReferenceText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement", "getReferenceText"));
            }
            return string;
        }

        @Nullable
        public PsiPolyVariantReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }
    }
}

