/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightParameterListWrapper;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LightMethod
extends LightElement
implements PsiMethod {
    @NotNull
    protected final PsiMethod myMethod;
    @NotNull
    protected final PsiClass myContainingClass;
    @NotNull
    protected final PsiSubstitutor mySubstitutor;

    public LightMethod(@NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        this(containingClass.getManager(), method, containingClass, containingClass.getLanguage(), substitutor);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        this(manager, method, containingClass, PsiSubstitutor.EMPTY);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        this(manager, method, containingClass, (Language)JavaLanguage.INSTANCE, substitutor);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        this(manager, method, containingClass, language, PsiSubstitutor.EMPTY);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language, @NotNull PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightMethod", "<init>"));
        }
        super(manager, language);
        this.myMethod = method;
        this.myContainingClass = containingClass;
        this.mySubstitutor = substitutor;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myMethod.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    public PsiDocComment getDocComment() {
        return this.myMethod.getDocComment();
    }

    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethod", "setName"));
        }
        return this.myMethod.setName(name2);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getName"));
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = this.myMethod.getHierarchicalMethodSignature();
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightMethod", "hasModifierProperty"));
        }
        return this.myMethod.hasModifierProperty(name2);
    }

    @Override
    public TextRange getTextRange() {
        return this.myMethod.getTextRange();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myMethod.getModifierList();
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getModifierList"));
        }
        return psiModifierList;
    }

    public PsiType getReturnType() {
        return this.mySubstitutor.substitute(this.myMethod.getReturnType());
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myMethod.getReturnTypeElement();
    }

    @NotNull
    public PsiParameterList getParameterList() {
        LightParameterListWrapper lightParameterListWrapper = this.mySubstitutor == PsiSubstitutor.EMPTY ? this.myMethod.getParameterList() : new LightParameterListWrapper(this.myMethod.getParameterList(), this.mySubstitutor);
        if (lightParameterListWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getParameterList"));
        }
        return lightParameterListWrapper;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myMethod.getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getThrowsList"));
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return this.myMethod.getBody();
    }

    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    public boolean isVarArgs() {
        return this.myMethod.isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/light/LightMethod", "getSignature"));
        }
        MethodSignature methodSignature = this.myMethod.getSignature(substitutor);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getSignature"));
        }
        return methodSignature;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myMethod.getNameIdentifier();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = this.myMethod.findSuperMethods(parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list2 = this.myMethod.findSuperMethodSignaturesIncludingStatic(checkAccess);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list2;
    }

    public PsiMethod findDeepestSuperMethod() {
        return this.myMethod.findDeepestSuperMethod();
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = this.myMethod.findDeepestSuperMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @Override
    public String getText() {
        return this.myMethod.getText();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightMethod", "accept"));
        }
        this.myMethod.accept(visitor);
    }

    @Override
    public PsiElement copy() {
        return new LightMethod(this.myManager, (PsiMethod)this.myMethod.copy(), this.myContainingClass);
    }

    @Override
    public boolean isValid() {
        return this.myContainingClass.isValid();
    }

    @NotNull
    public PsiClass getContainingClass() {
        PsiClass psiClass = this.myContainingClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getContainingClass"));
        }
        return psiClass;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myContainingClass.getContainingFile();
    }

    @Override
    public String toString() {
        return "Light PSI method wrapper:" + this.getName();
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightMethod", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }
}

