/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApproximateResolver {
    @Nullable
    static Set<PsiClass> getPossibleTypes(@NotNull PsiExpression expression2, int maxDepth) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleTypes"));
        }
        if (maxDepth == 0) {
            return null;
        }
        return (expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiTypeCastExpression ? ApproximateResolver.extractClass(expression2.getType()) : (expression2 instanceof PsiMethodCallExpression ? ApproximateResolver.getCallType(expression2, maxDepth) : (expression2 instanceof PsiReferenceExpression ? ApproximateResolver.getNonCallType((PsiReferenceExpression)expression2, maxDepth) : null));
    }

    @Nullable
    private static Set<PsiClass> getCallType(@NotNull PsiExpression expression2, int maxDepth) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/search/ApproximateResolver", "getCallType"));
        }
        PsiReferenceExpression ref = ((PsiMethodCallExpression)expression2).getMethodExpression();
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            return ApproximateResolver.extractClass(expression2.getType());
        }
        Set<PsiClass> qualifierType = ApproximateResolver.getPossibleTypes(qualifier, maxDepth - 1);
        String refName = ref.getReferenceName();
        int argCount = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions().length;
        List<PsiMethod> methods = refName == null || qualifierType == null ? null : ApproximateResolver.getPossibleMethods(qualifierType, refName, argCount);
        return methods == null ? null : ApproximateResolver.getDefiniteSymbolTypes(methods);
    }

    @Nullable
    private static Set<PsiClass> getNonCallType(@NotNull PsiReferenceExpression expression2, int maxDepth) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/search/ApproximateResolver", "getNonCallType"));
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier == null) {
            PsiElement target2 = expression2.resolve();
            return target2 instanceof PsiClass ? Collections.singleton((PsiClass)target2) : ApproximateResolver.extractClass(expression2.getType());
        }
        Set<PsiClass> qualifierType = ApproximateResolver.getPossibleTypes(qualifier, maxDepth - 1);
        String refName = expression2.getReferenceName();
        List<PsiMember> members = refName == null || qualifierType == null ? null : ApproximateResolver.getPossibleNonMethods(qualifierType, refName);
        return members == null ? null : ApproximateResolver.getDefiniteSymbolTypes(members);
    }

    @Nullable
    private static Set<PsiClass> extractClass(PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return psiClass == null || psiClass instanceof PsiTypeParameter ? null : Collections.singleton(psiClass);
    }

    @NotNull
    public static List<PsiMethod> getPossibleMethods(@NotNull Set<PsiClass> symbols, @NotNull String name2, int callArgCount) {
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleMethods"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleMethods"));
        }
        List list2 = JBIterable.from(symbols).flatMap(sym -> {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/ApproximateResolver", "lambda$getPossibleMethods$0"));
            }
            return Arrays.asList(sym.findMethodsByName(name2, true));
        }).filter(m -> ApproximateResolver.canHaveArgCount(m, callArgCount)).toList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleMethods"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiMember> getPossibleNonMethods(@NotNull Set<PsiClass> symbols, @NotNull String name2) {
        if (symbols == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbols", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleNonMethods"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleNonMethods"));
        }
        ArrayList<PsiMember> result2 = new ArrayList<PsiMember>();
        for (PsiClass sym : symbols) {
            ContainerUtil.addIfNotNull(result2, (Object)sym.findFieldByName(name2, true));
            ContainerUtil.addIfNotNull(result2, (Object)sym.findInnerClassByName(name2, true));
        }
        ArrayList<PsiMember> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/ApproximateResolver", "getPossibleNonMethods"));
        }
        return arrayList;
    }

    @Nullable
    public static Set<PsiClass> getDefiniteSymbolTypes(@NotNull List<? extends PsiMember> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/psi/impl/search/ApproximateResolver", "getDefiniteSymbolTypes"));
        }
        HashSet<PsiClass> possibleTypes = new HashSet<PsiClass>();
        for (PsiMember psiMember : candidates) {
            PsiClass typeClass;
            if (psiMember instanceof PsiClass) {
                possibleTypes.add((PsiClass)psiMember);
                continue;
            }
            if (psiMember instanceof PsiMethod && ((PsiMethod)psiMember).isConstructor()) {
                ContainerUtil.addIfNotNull(possibleTypes, (Object)psiMember.getContainingClass());
                continue;
            }
            PsiType type2 = psiMember instanceof PsiField ? ((PsiField)psiMember).getType() : ((PsiMethod)psiMember).getReturnType();
            if (type2 instanceof PsiPrimitiveType) continue;
            if (type2 instanceof PsiArrayType) {
                type2 = PsiType.getJavaLangObject((PsiManager)psiMember.getManager(), (GlobalSearchScope)psiMember.getResolveScope());
            }
            if ((typeClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) == null || typeClass instanceof PsiTypeParameter) {
                return null;
            }
            possibleTypes.add(typeClass);
        }
        return possibleTypes;
    }

    public static boolean canHaveArgCount(PsiMethod method, int argCount) {
        return method.isVarArgs() ? argCount >= method.getParameterList().getParametersCount() - 1 : argCount == method.getParameterList().getParametersCount();
    }
}

