/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "hasModifierProperty"));
        }
        return "abstract".equals(name2) || "public".equals(name2) || super.hasModifierProperty(name2);
    }

    @Override
    protected void dropCached() {
        this.myCachedDefaultValue = null;
    }

    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String text2 = stub.getDefaultValueText();
            if (StringUtil.isEmpty((String)text2)) {
                return null;
            }
            PsiAnnotationMemberValue value2 = (PsiAnnotationMemberValue)SoftReference.dereference(this.myCachedDefaultValue);
            if (value2 != null) {
                return value2;
            }
            value2 = JavaPsiFacade.getElementFactory((Project)this.getProject()).createAnnotationFromText("@Foo(" + text2 + ")", (PsiElement)this).findAttributeValue(null);
            this.myCachedDefaultValue = new SoftReference((Object)value2);
            return value2;
        }
        this.myCachedDefaultValue = null;
        ASTNode node = this.getNode().findChildByRole(248);
        if (node == null) {
            return null;
        }
        return (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationMethod((PsiAnnotationMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

