/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private SchemeDataHolder<? super CodeStyleSchemeImpl> myDataHolder;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;
    private final Object lock;

    CodeStyleSchemeImpl(@NotNull String name2, String parentSchemeName, @NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.lock = new Object();
        this.setName(name2);
        this.myDataHolder = dataHolder;
        this.myIsDefault = "Default".equals(name2);
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name2, boolean isDefault, CodeStyleScheme parentScheme) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "<init>"));
        }
        this.lock = new Object();
        this.setName(name2);
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    @NotNull
    private CodeStyleSettings init(@Nullable CodeStyleScheme parentScheme, @Nullable Element root) {
        CodeStyleSettings settings;
        if (parentScheme == null) {
            settings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            settings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            settings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                settings.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myCodeStyleSettings = settings;
        CodeStyleSettings codeStyleSettings = settings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "init"));
        }
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CodeStyleSettings getCodeStyleSettings() {
        CodeStyleSettings settings = this.myCodeStyleSettings;
        if (settings != null) {
            CodeStyleSettings codeStyleSettings = settings;
            if (codeStyleSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getCodeStyleSettings"));
            }
            return codeStyleSettings;
        }
        Object object = this.lock;
        synchronized (object) {
            SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder = this.myDataHolder;
            if (dataHolder == null) {
                CodeStyleSettings codeStyleSettings = this.myCodeStyleSettings;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (codeStyleSettings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getCodeStyleSettings"));
                }
                return codeStyleSettings;
            }
            this.myDataHolder = null;
            settings = this.init(this.myParentSchemeName == null ? null : CodeStyleSchemesImpl.getSchemeManager().findSchemeByName(this.myParentSchemeName), dataHolder.read());
            dataHolder.updateDigest(this);
            this.myParentSchemeName = null;
        }
        CodeStyleSettings codeStyleSettings = settings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "getCodeStyleSettings"));
        }
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "setCodeStyleSettings"));
        }
        this.myCodeStyleSettings = codeStyleSettings;
        Object object = this.lock;
        synchronized (object) {
            this.myParentSchemeName = null;
            this.myDataHolder = null;
        }
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SchemeState getSchemeState() {
        Object object = this.lock;
        synchronized (object) {
            return this.myDataHolder == null ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Element writeScheme() {
        SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder;
        Object object = this.lock;
        synchronized (object) {
            dataHolder = this.myDataHolder;
        }
        if (dataHolder == null) {
            Element newElement = new Element("code_scheme");
            newElement.setAttribute("name", this.getName());
            this.myCodeStyleSettings.writeExternal(newElement);
            Element element = newElement;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
            }
            return element;
        }
        Element element = dataHolder.read();
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl", "writeScheme"));
        }
        return element;
    }
}

