/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsLoader {
    public CodeStyleSettings loadSettings(@NotNull VirtualFile file2) throws SchemeImportException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        Element rootElement = SchemeImportUtil.loadSchemeDom(file2);
        CodeStyleSettings settings = new CodeStyleSettings();
        this.loadSettings(rootElement, settings);
        return settings;
    }

    protected void loadSettings(@NotNull Element rootElement, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        try {
            settings.readExternal(rootElement);
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e.getMessage()}));
        }
    }
}

