/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ImportsFormatter
extends XmlRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.ImportsFormatter");
    private final FormattingDocumentModelImpl myDocumentModel;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    @NonNls
    private static final String PAGE_DIRECTIVE = "page";
    @NonNls
    private static final String IMPORT_ATT = "import";
    private final PostFormatProcessorHelper myPostProcessor;

    public ImportsFormatter(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/ImportsFormatter", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportsFormatter", "<init>"));
        }
        this.myPostProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
        this.myDocumentModel = FormattingDocumentModelImpl.createOn(file2);
        this.myIndentOptions = settings.getIndentOptionsByFile(file2);
    }

    public void visitXmlTag(XmlTag tag) {
        if (this.checkElementContainsRange((PsiElement)tag)) {
            super.visitXmlTag(tag);
        }
    }

    private static boolean isPageDirectiveTag(XmlTag tag) {
        return PAGE_DIRECTIVE.equals(tag.getName());
    }

    public void visitXmlText(XmlText text2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttributeValue valueElement;
        if (ImportsFormatter.isPageDirectiveTag(attribute.getParent()) && (valueElement = attribute.getValueElement()) != null && this.checkRangeContainsElement((PsiElement)attribute) && ImportsFormatter.isImportAttribute(attribute) && PostFormatProcessorHelper.isMultiline((PsiElement)valueElement)) {
            int oldLength = attribute.getTextLength();
            ASTNode valueToken = ImportsFormatter.findValueToken(valueElement.getNode());
            if (valueToken != null) {
                String newAttributeValue = this.formatImports(valueToken.getStartOffset(), attribute.getValue());
                try {
                    attribute.setValue(newAttributeValue);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    this.updateResultRange(oldLength, attribute.getTextLength());
                }
            }
        }
    }

    private String formatImports(int startOffset, String value2) {
        StringBuffer result2 = new StringBuffer();
        String offset = this.calcOffset(startOffset);
        String[] imports2 = value2.split(",");
        if (imports2.length >= 1) {
            result2.append(imports2[0]);
            for (int i = 1; i < imports2.length; ++i) {
                String anImport = imports2[i];
                result2.append(',');
                result2.append('\n');
                result2.append(offset);
                result2.append(anImport.trim());
            }
        }
        return result2.toString();
    }

    private String calcOffset(int startOffset) {
        int emptyLineEnd;
        StringBuffer result2 = new StringBuffer();
        int lineStartOffset = this.myDocumentModel.getLineStartOffset(this.myDocumentModel.getLineNumber(startOffset));
        CharSequence spaces = this.myDocumentModel.getText(new TextRange(lineStartOffset, emptyLineEnd = CharArrayUtil.shiftForward((CharSequence)this.myDocumentModel.getDocument().getCharsSequence(), (int)lineStartOffset, (String)" \t")));
        if (spaces != null) {
            result2.append(spaces.toString());
        }
        this.appendSpaces(result2, startOffset - emptyLineEnd);
        return result2.toString();
    }

    private void appendSpaces(StringBuffer result2, int count) {
        if (this.myIndentOptions.USE_TAB_CHARACTER && !this.myIndentOptions.SMART_TABS) {
            int tabsCount = count / this.myIndentOptions.TAB_SIZE;
            int spaceCount = count - tabsCount * this.myIndentOptions.TAB_SIZE;
            StringUtil.repeatSymbol((Appendable)result2, (char)'\t', (int)tabsCount);
            StringUtil.repeatSymbol((Appendable)result2, (char)' ', (int)spaceCount);
        } else {
            StringUtil.repeatSymbol((Appendable)result2, (char)' ', (int)count);
        }
    }

    private static ASTNode findValueToken(ASTNode node) {
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) continue;
            return child;
        }
        return null;
    }

    private static boolean isImportAttribute(XmlAttribute attribute) {
        return IMPORT_ATT.equals(attribute.getName());
    }

    protected void updateResultRange(int oldTextLength, int newTextLength) {
        this.myPostProcessor.updateResultRange(oldTextLength, newTextLength);
    }

    protected boolean checkElementContainsRange(PsiElement element) {
        return this.myPostProcessor.isElementPartlyInRange(element);
    }

    protected boolean checkRangeContainsElement(PsiElement element) {
        return this.myPostProcessor.isElementFullyInRange(element);
    }

    public PsiElement process(PsiElement formatted) {
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    public TextRange processText(PsiFile source, TextRange rangeToReformat) {
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        return this.myPostProcessor.getResultTextRange();
    }
}

