/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDClassComment
extends JDParamListOwnerComment {
    private List<String> myAuthorsList;
    private String myVersion;

    public JDClassComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "<init>"));
        }
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        JDTag tag;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "generateSpecial"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "generateSpecial"));
        }
        super.generateSpecial(prefix, sb);
        String continuationPrefix = prefix + this.javadocContinuationIndent();
        if (!JDClassComment.isNull(this.myAuthorsList)) {
            tag = JDTag.AUTHOR;
            for (String author : this.myAuthorsList) {
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(author, prefix + tag.getWithEndWhitespace(), continuationPrefix));
            }
        }
        if (!JDClassComment.isNull(this.myVersion)) {
            tag = JDTag.VERSION;
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myVersion, prefix + tag.getWithEndWhitespace(), continuationPrefix));
        }
    }

    public void addAuthor(@NotNull String author) {
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "addAuthor"));
        }
        if (this.myAuthorsList == null) {
            this.myAuthorsList = ContainerUtilRt.newArrayList();
        }
        this.myAuthorsList.add(author);
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/impl/source/codeStyle/javadoc/JDClassComment", "setVersion"));
        }
        this.myVersion = version;
    }
}

