/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlockerExtension;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlScriptLanguageInjector
implements MultiHostInjector {
    @Nullable
    public static Language getScriptLanguageToInject(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector", "getScriptLanguageToInject"));
        }
        if (!HtmlUtil.isScriptTag(xmlTag)) {
            return null;
        }
        String mimeType = xmlTag.getAttributeValue("type");
        Collection languages = Language.findInstancesByMimeType((String)mimeType);
        return !languages.isEmpty() ? (Language)languages.iterator().next() : Language.ANY;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector", "getLanguagesToInject"));
        }
        if (!(host.isValid() && host instanceof XmlText && HtmlUtil.isHtmlTagContainingFile(host))) {
            return;
        }
        XmlTag scriptTag = ((XmlText)host).getParentTag();
        if (scriptTag == null) {
            return;
        }
        Language language = HtmlScriptLanguageInjector.getScriptLanguageToInject(scriptTag);
        if (language == null || HtmlScriptInjectionBlockerExtension.isInjectionBlocked(scriptTag, language)) {
            return;
        }
        if (LanguageUtil.isInjectableLanguage((Language)language)) {
            registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)0, (int)host.getTextLength())).doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlText>> list2 = Collections.singletonList(XmlText.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/html/HtmlScriptLanguageInjector", "elementsToInjectIn"));
        }
        return list2;
    }
}

