/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

class ExceptionTagInfo
implements JavadocTagInfo {
    private final String myName;

    public ExceptionTagInfo(@NonNls String name2) {
        this.myName = name2;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isInline() {
        return false;
    }

    public boolean isValidInContext(PsiElement element) {
        return element instanceof PsiMethod;
    }

    public String checkTagValue(PsiDocTagValue value2) {
        PsiClassType[] references;
        if (value2 == null) {
            return JavaErrorMessages.message("javadoc.exception.tag.exception.class.expected", new Object[0]);
        }
        PsiElement firstChild = value2.getFirstChild();
        if (firstChild == null) {
            return JavaErrorMessages.message("javadoc.exception.tag.exception.class.expected", new Object[0]);
        }
        PsiElement psiElement = firstChild.getFirstChild();
        if (!(psiElement instanceof PsiJavaCodeReferenceElement)) {
            return JavaErrorMessages.message("javadoc.exception.tag.wrong.tag.value", new Object[0]);
        }
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)psiElement;
        PsiElement element = ref.resolve();
        if (!(element instanceof PsiClass)) {
            return null;
        }
        PsiClass exceptionClass = (PsiClass)element;
        PsiClass throwable = JavaPsiFacade.getInstance((Project)value2.getProject()).findClass("java.lang.Throwable", value2.getResolveScope());
        if (throwable != null && !exceptionClass.equals(throwable) && !exceptionClass.isInheritor(throwable, true)) {
            return JavaErrorMessages.message("javadoc.exception.tag.class.is.not.throwable", exceptionClass.getQualifiedName());
        }
        PsiClass runtimeException = JavaPsiFacade.getInstance((Project)value2.getProject()).findClass("java.lang.RuntimeException", value2.getResolveScope());
        if (runtimeException != null && (exceptionClass.isInheritor(runtimeException, true) || exceptionClass.equals(runtimeException))) {
            return null;
        }
        PsiClass errorException = JavaPsiFacade.getInstance((Project)value2.getProject()).findClass("java.lang.Error", value2.getResolveScope());
        if (errorException != null && (exceptionClass.isInheritor(errorException, true) || exceptionClass.equals(errorException))) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value2, PsiMethod.class);
        if (method == null) {
            return null;
        }
        for (PsiClassType reference : references = method.getThrowsList().getReferencedTypes()) {
            PsiClass psiClass = reference.resolve();
            if (psiClass == null || !exceptionClass.isInheritor(psiClass, true) && !exceptionClass.equals(psiClass)) continue;
            return null;
        }
        return JavaErrorMessages.message("javadoc.exception.tag.exception.is.not.thrown", exceptionClass.getName(), method.getName());
    }

    public PsiReference getReference(PsiDocTagValue value2) {
        return null;
    }
}

