/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParsing {
    private static final int BALANCING_DEPTH_THRESHOLD = 1000;
    protected final PsiBuilder myBuilder;
    private final Stack<String> myTagNamesStack = new Stack();

    public XmlParsing(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    public void parseDocument() {
        PsiBuilder.Marker document = this.mark();
        while (this.isCommentToken(this.token())) {
            this.parseComment();
        }
        this.parseProlog();
        int rootTagCount = 0;
        PsiBuilder.Marker error = null;
        while (!this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlElementType.XML_START_TAG_START) {
                error = XmlParsing.flushError(error);
                this.parseTag(++rootTagCount > 1);
                continue;
            }
            if (this.isCommentToken(tt)) {
                error = XmlParsing.flushError(error);
                this.parseComment();
                continue;
            }
            if (tt == XmlElementType.XML_PI_START) {
                error = XmlParsing.flushError(error);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_REAL_WHITE_SPACE) {
                error = XmlParsing.flushError(error);
                this.advance();
                continue;
            }
            if (error == null) {
                error = this.mark();
            }
            this.advance();
        }
        if (error != null) {
            error.error(XmlErrorMessages.message("top.level.element.is.not.completed", new Object[0]));
        }
        if (rootTagCount == 0) {
            PsiBuilder.Marker rootTag = this.mark();
            error = this.mark();
            error.error(XmlErrorMessages.message("xml.parsing.absent.root.tag", new Object[0]));
            rootTag.done(XmlElementType.XML_TAG);
        }
        document.done(XmlElementType.XML_DOCUMENT);
    }

    @Nullable
    private static PsiBuilder.Marker flushError(PsiBuilder.Marker error) {
        if (error != null) {
            error.error(XmlErrorMessages.message("xml.parsing.unexpected.tokens", new Object[0]));
            error = null;
        }
        return error;
    }

    private void parseDoctype() {
        assert (this.token() == XmlElementType.XML_DOCTYPE_START) : "Doctype start expected";
        PsiBuilder.Marker doctype = this.mark();
        this.advance();
        while (this.token() != XmlElementType.XML_DOCTYPE_END && !this.eof()) {
            this.advance();
        }
        if (this.eof()) {
            this.error(XmlErrorMessages.message("xml.parsing.unexpected.end.of.file", new Object[0]));
        } else {
            this.advance();
        }
        doctype.done(XmlElementType.XML_DOCTYPE);
    }

    protected void parseTag(boolean multipleRootTagError) {
        assert (this.token() == XmlElementType.XML_START_TAG_START) : "Tag start expected";
        PsiBuilder.Marker tag = this.mark();
        String tagName = this.parseTagHeader(multipleRootTagError, tag);
        if (tagName == null) {
            return;
        }
        PsiBuilder.Marker content = this.mark();
        this.parseTagContent();
        if (this.token() == XmlElementType.XML_END_TAG_START) {
            PsiBuilder.Marker footer = this.mark();
            this.advance();
            if (this.token() == XmlElementType.XML_NAME) {
                String endName = this.myBuilder.getTokenText();
                if (!tagName.equals(endName) && this.myTagNamesStack.contains((Object)endName)) {
                    footer.rollbackTo();
                    this.myTagNamesStack.pop();
                    tag.doneBefore(XmlElementType.XML_TAG, content, XmlErrorMessages.message("named.element.is.not.closed", tagName));
                    content.drop();
                    return;
                }
                this.advance();
            }
            footer.drop();
            while (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_START_TAG_START && this.token() != XmlTokenType.XML_END_TAG_START && !this.eof()) {
                this.error(XmlErrorMessages.message("xml.parsing.unexpected.token", new Object[0]));
                this.advance();
            }
            if (this.token() == XmlElementType.XML_TAG_END) {
                this.advance();
            } else {
                this.error(XmlErrorMessages.message("xml.parsing.closing.tag.is.not.done", new Object[0]));
            }
        } else {
            this.error(XmlErrorMessages.message("xml.parsing.unexpected.end.of.file", new Object[0]));
        }
        content.drop();
        this.myTagNamesStack.pop();
        tag.done(XmlElementType.XML_TAG);
    }

    @Nullable
    private String parseTagHeader(boolean multipleRootTagError, PsiBuilder.Marker tag) {
        String tagName;
        if (multipleRootTagError) {
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlErrorMessages.message("xml.parsing.multiple.root.tags", new Object[0]));
        } else {
            this.advance();
        }
        if (this.token() != XmlElementType.XML_NAME || this.myBuilder.rawLookup(-1) == TokenType.WHITE_SPACE) {
            this.error(XmlErrorMessages.message("xml.parsing.tag.name.expected", new Object[0]));
            tagName = "";
        } else {
            tagName = this.myBuilder.getTokenText();
            assert (tagName != null);
            this.advance();
        }
        this.myTagNamesStack.push((Object)tagName);
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlElementType.XML_NAME) {
                this.parseAttribute();
                continue;
            }
            if (tt != XmlElementType.XML_CHAR_ENTITY_REF && tt != XmlElementType.XML_ENTITY_REF_TOKEN) break;
            this.parseReference();
        }
        if (this.token() == XmlElementType.XML_EMPTY_ELEMENT_END) {
            this.advance();
            this.myTagNamesStack.pop();
            tag.done(XmlElementType.XML_TAG);
            return null;
        }
        if (this.token() != XmlElementType.XML_TAG_END) {
            this.error(XmlErrorMessages.message("tag.start.is.not.closed", new Object[0]));
            this.myTagNamesStack.pop();
            tag.done(XmlElementType.XML_TAG);
            return null;
        }
        this.advance();
        if (this.myTagNamesStack.size() > 1000) {
            this.error(XmlErrorMessages.message("way.too.unbalanced", new Object[0]));
            tag.done(XmlElementType.XML_TAG);
            return null;
        }
        return tagName;
    }

    public void parseTagContent() {
        PsiBuilder.Marker xmlText = null;
        while (this.token() != XmlElementType.XML_END_TAG_START && !this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlElementType.XML_START_TAG_START) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseTag(false);
                continue;
            }
            if (tt == XmlElementType.XML_PI_START) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_ENTITY_REF_TOKEN) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlElementType.XML_CHAR_ENTITY_REF) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlElementType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (this.isCommentToken(tt)) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlElementType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlErrorMessages.message("unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                continue;
            }
            if (tt instanceof ICustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = XmlParsing.terminateText(xmlText);
                this.advance();
                continue;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        XmlParsing.terminateText(xmlText);
    }

    protected boolean isCommentToken(IElementType tt) {
        return tt == XmlElementType.XML_COMMENT_START;
    }

    @NotNull
    private PsiBuilder.Marker startText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText == null) {
            xmlText = this.mark();
            assert (xmlText != null);
        }
        PsiBuilder.Marker marker = xmlText;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/xml/XmlParsing", "startText"));
        }
        return marker;
    }

    protected final PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    @Nullable
    private static PsiBuilder.Marker terminateText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText != null) {
            xmlText.done(XmlElementType.XML_TEXT);
            xmlText = null;
        }
        return xmlText;
    }

    private void parseCData() {
        assert (this.token() == XmlElementType.XML_CDATA_START);
        PsiBuilder.Marker cdata = this.mark();
        while (this.token() != XmlElementType.XML_CDATA_END && !this.eof()) {
            this.advance();
        }
        if (!this.eof()) {
            this.advance();
        }
        cdata.done(XmlElementType.XML_CDATA);
    }

    protected void parseComment() {
        IElementType tt;
        PsiBuilder.Marker comment = this.mark();
        this.advance();
        while (true) {
            if ((tt = this.token()) == XmlElementType.XML_COMMENT_CHARACTERS || tt == XmlElementType.XML_CONDITIONAL_COMMENT_START || tt == XmlElementType.XML_CONDITIONAL_COMMENT_START_END || tt == XmlElementType.XML_CONDITIONAL_COMMENT_END_START || tt == XmlElementType.XML_CONDITIONAL_COMMENT_END) {
                this.advance();
                continue;
            }
            if (tt != XmlElementType.XML_BAD_CHARACTER) break;
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlErrorMessages.message("xml.parsing.bad.character", new Object[0]));
        }
        if (tt == XmlElementType.XML_COMMENT_END) {
            this.advance();
        }
        comment.done(XmlElementType.XML_COMMENT);
    }

    private void parseReference() {
        if (this.token() == XmlElementType.XML_CHAR_ENTITY_REF) {
            this.advance();
        } else if (this.token() == XmlElementType.XML_ENTITY_REF_TOKEN) {
            PsiBuilder.Marker ref = this.mark();
            this.advance();
            ref.done(XmlElementType.XML_ENTITY_REF);
        } else assert (false) : "Unexpected token";
    }

    private void parseAttribute() {
        assert (this.token() == XmlElementType.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        this.advance();
        if (this.token() == XmlElementType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
            att.done(XmlElementType.XML_ATTRIBUTE);
        } else {
            this.error(XmlErrorMessages.message("expected.attribute.eq.sign", new Object[0]));
            att.done(XmlElementType.XML_ATTRIBUTE);
        }
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlElementType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlElementType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlElementType.XML_END_TAG_START && tt != XmlElementType.XML_EMPTY_ELEMENT_END && tt != XmlElementType.XML_START_TAG_START) {
                if (tt == XmlElementType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlErrorMessages.message("unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                    continue;
                }
                if (tt == XmlElementType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                this.advance();
            }
            if (this.token() == XmlElementType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlErrorMessages.message("xml.parsing.unclosed.attribute.value", new Object[0]));
            }
        } else {
            this.error(XmlErrorMessages.message("xml.parsing.attribute.value.expected", new Object[0]));
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    private void parseProlog() {
        PsiBuilder.Marker prolog = this.mark();
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlElementType.XML_PI_START) {
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlElementType.XML_DOCTYPE_START) {
                this.parseDoctype();
                continue;
            }
            if (this.isCommentToken(tt)) {
                this.parseComment();
                continue;
            }
            if (tt != XmlElementType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        prolog.done(XmlElementType.XML_PROLOG);
    }

    private void parseProcessingInstruction() {
        assert (this.token() == XmlElementType.XML_PI_START);
        PsiBuilder.Marker pi = this.mark();
        this.advance();
        if (this.token() != XmlElementType.XML_NAME) {
            this.error(XmlErrorMessages.message("xml.parsing.processing.instruction.name.expected", new Object[0]));
        } else {
            this.advance();
        }
        IElementType tokenType = this.token();
        if (tokenType == XmlElementType.XML_TAG_CHARACTERS) {
            while (this.token() == XmlElementType.XML_TAG_CHARACTERS) {
                this.advance();
            }
        } else {
            while (this.token() == XmlElementType.XML_NAME) {
                this.advance();
                if (this.token() == XmlElementType.XML_EQ) {
                    this.advance();
                } else {
                    this.error(XmlErrorMessages.message("expected.attribute.eq.sign", new Object[0]));
                }
                this.parseAttributeValue();
            }
        }
        if (this.token() == XmlElementType.XML_PI_END) {
            this.advance();
        } else {
            this.error(XmlErrorMessages.message("xml.parsing.unterminated.processing.instruction", new Object[0]));
        }
        pi.done(XmlElementType.XML_PROCESSING_INSTRUCTION);
    }

    @Nullable
    protected final IElementType token() {
        return this.myBuilder.getTokenType();
    }

    protected final boolean eof() {
        return this.myBuilder.eof();
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    private void error(String message2) {
        this.myBuilder.error(message2);
    }
}

