/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.reflectiveAccess.JavaLangInvokeHandleSignatureInspection;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangInvokeHandleReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangInvokeHandleReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "<init>"));
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "bindToElement"));
        }
        return element;
    }

    @Nullable
    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            PsiClass psiClass;
            String name2 = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (psiClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
                switch (type2) {
                    case "findGetter": 
                    case "findSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name2, psiClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticGetter": 
                    case "findStaticSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name2, psiClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                    case "findVirtual": {
                        return this.resolveMethod(name2, psiClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isNonStaticMethod));
                    }
                    case "findStatic": {
                        return this.resolveMethod(name2, psiClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isStaticMethod));
                    }
                    case "findVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name2, psiClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name2, psiClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                }
            }
        }
        return null;
    }

    private static PsiElement resolveField(@NotNull String name2, @NotNull PsiClass psiClass, Condition<? super PsiField> filter) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "resolveField"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "resolveField"));
        }
        PsiField field = psiClass.findFieldByName(name2, true);
        return field != null && filter.value((Object)field) ? field : null;
    }

    private PsiElement resolveMethod(@NotNull String name2, @NotNull PsiClass psiClass, Condition<? super PsiMethod> filter) {
        PsiExpression typeExpression;
        JavaReflectionReferenceUtil.ReflectiveSignature expectedSignature;
        PsiExpression[] arguments;
        PsiMethodCallExpression definitionCall;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "resolveMethod"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "resolveMethod"));
        }
        Object[] methods = psiClass.findMethodsByName(name2, true);
        if (methods.length != 0 && (methods = ContainerUtil.filter((Object[])methods, filter).toArray(PsiMethod.EMPTY_ARRAY)).length > 1 && (definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class)) != null && (arguments = definitionCall.getArgumentList().getExpressions()).length > 2 && (expectedSignature = JavaLangInvokeHandleSignatureInspection.composeMethodSignature(typeExpression = ParenthesesUtils.stripParentheses(arguments[2]))) != null) {
            return (PsiElement)ContainerUtil.find((Object[])methods, method -> expectedSignature.equals(JavaReflectionReferenceUtil.getMethodSignature(method)));
        }
        return methods.length != 0 ? methods[0] : null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass;
        String type2;
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String && (type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement)) != null && (psiClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
            switch (type2) {
                case "findGetter": 
                case "findSetter": {
                    Object[] objectArray = this.lookupFields(psiClass, JavaLangInvokeHandleReference::isNonStaticField);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "findStaticGetter": 
                case "findStaticSetter": {
                    Object[] objectArray = this.lookupFields(psiClass, JavaLangInvokeHandleReference::isStaticField);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "findVirtual": {
                    Object[] objectArray = this.lookupMethods(psiClass, JavaLangInvokeHandleReference::isNonStaticMethod);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "findStatic": {
                    Object[] objectArray = this.lookupMethods(psiClass, JavaLangInvokeHandleReference::isStaticMethod);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "findVarHandle": {
                    Object[] objectArray = this.lookupFields(psiClass, JavaLangInvokeHandleReference::isNonStaticField);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "findStaticVarHandle": {
                    Object[] objectArray = this.lookupFields(psiClass, JavaLangInvokeHandleReference::isStaticField);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
                    }
                    return objectArray;
                }
            }
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private Object[] lookupMethods(@NotNull PsiClass psiClass, Predicate<? super PsiMethod> filter) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "lookupMethods"));
        }
        return psiClass.getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(filter).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
    }

    private Object[] lookupFields(@NotNull PsiClass psiClass, Predicate<? super PsiField> filter) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "lookupFields"));
        }
        THashSet uniqueNames = new THashSet();
        return Arrays.stream(psiClass.getAllFields()).filter(arg_0 -> JavaLangInvokeHandleReference.lambda$lookupFields$3(psiClass, (Set)uniqueNames, arg_0)).filter(filter).sorted(Comparator.comparing(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PomNamedTarget::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field).withInsertHandler((InsertHandler)this), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
    }

    private static boolean isNonStaticField(PsiField field) {
        return field != null && !field.hasModifierProperty("static");
    }

    private static boolean isStaticField(PsiField field) {
        return field != null && field.hasModifierProperty("static");
    }

    private static boolean isNonStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && !method.hasModifierProperty("static");
    }

    private static boolean isStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && method.hasModifierProperty("static");
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "handleInsert"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "handleInsert"));
        }
        Object object = item.getObject();
        if (object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            String text2 = ", " + JavaReflectionReferenceUtil.getMethodTypeExpressionText((JavaReflectionReferenceUtil.ReflectiveSignature)object);
            JavaReflectionReferenceUtil.replaceText(context, text2);
        } else if (object instanceof PsiField) {
            PsiField field = (PsiField)object;
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            String text3 = ", " + typeText + ".class";
            JavaReflectionReferenceUtil.replaceText(context, text3);
        }
    }

    private static /* synthetic */ boolean lambda$lookupFields$3(@NotNull PsiClass psiClass, Set uniqueNames, PsiField field) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference", "lambda$lookupFields$3"));
        }
        return field != null && (field.getContainingClass() == psiClass || !field.hasModifierProperty("private")) && field.getName() != null && uniqueNames.add(field.getName());
    }

    static class JavaLangInvokeHandleReferenceProvider
    extends PsiReferenceProvider {
        JavaLangInvokeHandleReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement parent;
            PsiLiteralExpression literal;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider", "getReferencesByElement"));
            }
            if (element instanceof PsiLiteralExpression && (literal = (PsiLiteralExpression)element).getValue() instanceof String && (parent = element.getParent()) instanceof PsiExpressionList) {
                PsiExpression qualifier;
                PsiExpression[] expressions2 = ((PsiExpressionList)parent).getExpressions();
                PsiExpression psiExpression = qualifier = expressions2.length != 0 ? expressions2[0] : null;
                if (qualifier != null) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new JavaLangInvokeHandleReference(literal, qualifier)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangInvokeHandleReference$JavaLangInvokeHandleReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

