/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTextManipulator
extends AbstractElementManipulator<XmlText> {
    public XmlText handleContentChange(@NotNull XmlText text2, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newValue;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "handleContentChange"));
        }
        String value2 = text2.getValue();
        if (range.equals((Object)this.getRangeInElement(text2))) {
            newValue = newContent;
        } else {
            StringBuilder replacement = new StringBuilder(value2);
            replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
            newValue = replacement.toString();
        }
        if (Comparing.equal((String)value2, (String)newValue)) {
            return text2;
        }
        if (!newValue.isEmpty()) {
            text2.setValue(newValue);
        } else {
            text2.deleteChildRange(text2.getFirstChild(), text2.getLastChild());
        }
        return text2;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlText text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "getRangeInElement"));
        }
        TextRange textRange = XmlTextManipulator.getValueRange(text2);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlTextManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        String value2 = xmlText.getValue();
        int i2 = value2.indexOf(value2);
        int start = xmlText.displayToPhysical(i2);
        return value2.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i2 + value2.length() - 1) + 1);
    }
}

