/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.CompositeElement");
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final boolean ASSERT_THREADING = true;
    private static final AtomicFieldUpdater<CompositeElement, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(CompositeElement.class, PsiElement.class);

    public CompositeElement(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/CompositeElement", "<init>"));
        }
        super(type2);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (TreeElement child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "clone"));
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
        }
    }

    @Override
    public void clearCaches() {
        this.assertThreading();
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private void assertThreading() {
        boolean ok;
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || this.isNonPhysicalOrInjected();
        if (!ok) {
            LOG.error("Threading assertion. " + this.getThreadingDiagnostics());
        }
    }

    private String getThreadingDiagnostics() {
        FileElement fileElement = TreeUtil.getFileElement(this);
        PsiFile psiFile = fileElement == null ? null : (PsiFile)fileElement.getPsi();
        return " Under write: " + ApplicationManager.getApplication().isWriteAccessAllowed() + "; Thread.holdsLock(PsiLock.LOCK): " + Thread.holdsLock(PsiLock.LOCK) + "; wrapper: " + this.myWrapper + "; wrapper.isPhysical(): " + (this.myWrapper != null && this.myWrapper.isPhysical()) + "; fileElement: " + fileElement + "; psiFile: " + psiFile + "; psiFile.getViewProvider(): " + (psiFile == null ? null : psiFile.getViewProvider()) + "; psiFile.isPhysical(): " + (psiFile != null && psiFile.isPhysical()) + "; nonPhysicalOrInjected: " + this.isNonPhysicalOrInjected();
    }

    private boolean isNonPhysicalOrInjected() {
        PsiElement wrapper;
        FileElement fileElement = TreeUtil.getFileElement(this);
        if (fileElement == null || fileElement instanceof DummyHolderElement) {
            return true;
        }
        if (fileElement.getTreeParent() != null) {
            return true;
        }
        PsiElement psiElement = wrapper = this instanceof PsiElement ? (PsiElement)this : this.myWrapper;
        if (wrapper == null) {
            return true;
        }
        PsiFile psiFile = wrapper.getContainingFile();
        return psiFile == null || psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element = this;
        if (element.getTreeParent() == null && offset >= element.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element).getLastChildNode();
            int elementTextLength = element.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset;
            if (!fwd) {
                child = lastChild;
                offset = elementTextLength - offset;
            }
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset || !fwd && textLength >= offset) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = fwd ? child.getTreeNext() : child.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    offset = fwd ? offset : textLength - offset;
                    element = child;
                    continue block0;
                }
                offset -= textLength;
                child = fwd ? child.getTreeNext() : child.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(IElementType type2) {
        ASTNode node = this.findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    public ASTNode findChildByType(IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (TreeElement element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    public ASTNode findChildByType(IElementType type2, ASTNode anchor) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, type2);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/CompositeElement", "findChildByType"));
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (TreeElement element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/psi/impl/source/tree/CompositeElement", "findChildByType"));
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, typesSet);
    }

    @NotNull
    public String getText() {
        String string = StringFactory.createShared((char[])this.textToCharArray());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getText"));
        }
        return string;
    }

    @NotNull
    public CharSequence getChars() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChars"));
        }
        return string;
    }

    @Override
    public int getNotCachedLength() {
        final int[] result2 = new int[]{0};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element)) {
                    result2[0] = result2[0] + element.getNotCachedLength();
                }
                super.visitNode(element);
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        int endOffset;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "textToCharArray"));
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text2) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + this.isNonPhysicalOrInjected();
        msg = msg + ";\n buffer=" + text2;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text2, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file2;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file2 = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file2;
                msg = msg + ";\n psi.file.tl=" + file2.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file2.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file2.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                PsiElement fileLeaf = file2.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    public boolean textContains(char c) {
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/CompositeElement", "textMatches"));
        }
        final int[] curOffset = new int[]{start};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, (Object)child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result2[count++] = child;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildren"));
        }
        return result2;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@Nullable TokenSet filter, ArrayFactory<T> constructor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
            }
            return result2;
        }
        int idx = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, (Object)child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        return result2;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@NotNull IElementType type2, ArrayFactory<T> constructor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(type2);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
            }
            return result2;
        }
        int idx = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, (Object)child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "getChildrenAsPsiElements"));
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter) {
        int count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/CompositeElement", "countChildren"));
        }
        int count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        Object anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/CompositeElement", "deleteChildInternal"));
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChildInternal"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChildInternal"));
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start) {
        TreeElement child;
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/psi/impl/source/tree/CompositeElement", "drillDown"));
        }
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositeElement", "drillDown"));
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : cur.getTreeParent();
        }
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    public void addChild(@NotNull ASTNode child, final @Nullable ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/CompositeElement", "addChild"));
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, (Object)"anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        final TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first);
                }
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafType", "com/intellij/psi/impl/source/tree/CompositeElement", "addLeaf"));
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/CompositeElement", "addChild"));
        }
        this.addChild(child, null);
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/CompositeElement", "removeChild"));
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/CompositeElement", "removeRange"));
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/psi/impl/source/tree/CompositeElement", "replaceChild"));
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange(CompositeElement.this, changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild);
                    } else {
                        TreeElement first = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    @Nullable
    public final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = this.obtainStubBasedPsi();
        if (wrapper == null) {
            wrapper = this.createPsiNoLock();
        }
        return ourPsiUpdater.compareAndSet((Object)this, null, (Object)wrapper) ? wrapper : (PsiElement)ObjectUtils.assertNotNull((Object)this.myWrapper);
    }

    @Nullable
    private PsiElement obtainStubBasedPsi() {
        AstPath path = this.getElementType() instanceof IStubElementType ? AstPath.getNodePath(this) : null;
        return path == null ? null : path.getContainingFile().obtainPsi(path, () -> (StubBasedPsiElementBase)this.createPsiNoLock());
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/tree/CompositeElement", "getPsi"));
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement((ASTNode)this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/impl/source/tree/CompositeElement", "setPsi"));
        }
        this.myWrapper = psi;
    }

    protected void clearPsi() {
        this.myWrapper = null;
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/CompositeElement", "rawAddChildren"));
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        PsiFileImpl file2;
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/CompositeElement", "rawAddChildrenWithoutNotifications"));
        }
        if (DebugUtil.DO_EXPENSIVE_CHECKS && !(this instanceof LazyParseableElement) && (file2 = CompositeElement.getCachedFile(this)) != null && !file2.useStrongRefs()) {
            throw new AssertionError((Object)"Attempt to modify PSI in a file with weakly-referenced AST. Possible cause: missing PomTransaction.");
        }
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            first.rawRemoveUpToWithoutNotifications(null, false);
            this.setFirstChildNode(first);
            while (true) {
                TreeElement treeNext = first.getTreeNext();
                first.setTreeParent(this);
                if (treeNext == null) break;
                first = treeNext;
            }
            this.setLastChildNode(first);
            first.setTreeParent(this);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent, TreeElement first) {
        parent.rawAddChildren(first);
        for (TreeElement child = first; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            for (TreeElement child = first; child != last && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
            }
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first) {
        anchorBefore.rawInsertBeforeMe(first);
        for (TreeElement child = first; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newChild);
        sourceTreeChange.addElementaryChange(newChild, change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first, final TreeElement last) {
        final FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first, last);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first);
                }
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }
}

